/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.flow.core.Token;
import adams.flow.source.AbstractSource;

public abstract class AbstractForLoop
extends AbstractSource {
    private static final long serialVersionUID = 6216146938771296415L;
    protected int m_LoopLower;
    protected int m_LoopUpper;
    protected int m_LoopStep;
    protected int m_Current;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("lower", "loopLower", 1);
        this.m_OptionManager.add("upper", "loopUpper", 10);
        this.m_OptionManager.add("step", "loopStep", 1);
    }

    public void setLoopLower(int value) {
        this.m_LoopLower = value;
        this.reset();
    }

    public int getLoopLower() {
        return this.m_LoopLower;
    }

    public String loopLowerTipText() {
        return "The lower bound of the loop (= the first value).";
    }

    public void setLoopUpper(int value) {
        this.m_LoopUpper = value;
        this.reset();
    }

    public int getLoopUpper() {
        return this.m_LoopUpper;
    }

    public String loopUpperTipText() {
        return "The upper bound of the loop.";
    }

    public void setLoopStep(int value) {
        this.m_LoopStep = value;
        this.reset();
    }

    public int getLoopStep() {
        return this.m_LoopStep;
    }

    public String loopStepTipText() {
        return "The step size of the loop.";
    }

    @Override
    public String getQuickInfo() {
        String loopStep = this.getOptionManager().getVariableForProperty("loopStep");
        String loopLower = this.getOptionManager().getVariableForProperty("loopLower");
        String loopUpper = this.getOptionManager().getVariableForProperty("loopUpper");
        if (this.m_LoopStep >= 0 || loopStep != null) {
            return "for (i = " + (loopLower == null ? Integer.valueOf(this.m_LoopLower) : loopLower) + "; " + "i <= " + (loopUpper == null ? Integer.valueOf(this.m_LoopUpper) : loopUpper) + "; " + "i += " + (loopStep == null ? Integer.valueOf(this.m_LoopStep) : loopStep) + ")";
        }
        return "for (i = " + (loopUpper == null ? Integer.valueOf(this.m_LoopUpper) : loopUpper) + "; " + "i >= " + (loopLower == null ? Integer.valueOf(this.m_LoopLower) : loopLower) + "; " + "i += " + (loopStep == null ? Integer.valueOf(this.m_LoopStep) : loopStep) + ")";
    }

    @Override
    public abstract Class[] generates();

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            if (this.m_LoopStep == 0) {
                result = "Step size must be either greater or smaller than 0!";
            } else if (this.m_LoopLower > this.m_LoopUpper && this.m_LoopStep > 0) {
                result = "Lower bound cannot be larger than upper bound!";
            } else if (this.m_LoopLower < this.m_LoopUpper && this.m_LoopStep < 0) {
                result = "Upper bound cannot be larger than lower bound!";
            }
        }
        return result;
    }

    @Override
    protected String doExecute() {
        this.m_Current = this.m_LoopStep > 0 ? this.m_LoopLower : this.m_LoopUpper;
        return null;
    }

    @Override
    public abstract Token output();

    @Override
    public boolean hasPendingOutput() {
        boolean result = false;
        if (this.m_Executed) {
            result = this.m_LoopStep > 0 ? this.m_Current <= this.m_LoopUpper : this.m_Current >= this.m_LoopLower;
        }
        return result;
    }
}

