/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.application;

import adams.core.ClassLister;
import adams.core.option.OptionUtils;
import adams.gui.application.AbstractApplicationFrame;

public abstract class AbstractInitialization {
    public abstract String getTitle();

    public abstract boolean initialize(AbstractApplicationFrame var1);

    public static boolean initAll(AbstractApplicationFrame parent) {
        String[] classes;
        boolean result = true;
        for (String cls : classes = AbstractInitialization.getInitializations()) {
            try {
                AbstractInitialization init = (AbstractInitialization)Class.forName(cls).newInstance();
                result = init.initialize(parent) || result;
            }
            catch (Exception e) {
                System.err.println("Failed to run initialization applet '" + cls + "':");
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String[] getInitializations() {
        return ClassLister.getSingleton().getClassnames(AbstractInitialization.class);
    }

    public static AbstractInitialization forName(String classname, String[] options) {
        AbstractInitialization result;
        try {
            result = (AbstractInitialization)OptionUtils.forName(AbstractInitialization.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }
}

