/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.ClassLister;
import adams.data.io.input.AbstractDataContainerReader;
import adams.data.io.input.AbstractReportReader;
import adams.data.io.output.AbstractDataContainerWriter;
import adams.data.io.output.AbstractReportWriter;
import java.io.File;
import java.util.Vector;

public class ChooserHelper {
    protected static Object getInstance(Class superclass, String subclass) {
        Object result;
        try {
            result = Class.forName(subclass).newInstance();
            result.getClass().asSubclass(superclass);
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static String[] getDataContainerReadersForFile(Class cls, File file) {
        Vector<String> result = new Vector<String>();
        String[] classes = ClassLister.getSingleton().getClassnames(cls);
        String fileExt = file.getName().toLowerCase().replaceAll(".*\\.", "");
        block0: for (String clazz : classes) {
            String[] exts;
            AbstractDataContainerReader reader = (AbstractDataContainerReader)ChooserHelper.getInstance(AbstractDataContainerReader.class, clazz);
            if (reader == null) continue;
            for (String ext : exts = reader.getFormatExtensions()) {
                if (!ext.toLowerCase().equals(fileExt)) continue;
                result.add(clazz);
                continue block0;
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getDataContainerWritersForFile(Class cls, File file) {
        Vector<String> result = new Vector<String>();
        String[] classes = ClassLister.getSingleton().getClassnames(cls);
        String fileExt = file.getName().toLowerCase().replaceAll(".*\\.", "");
        block0: for (String clazz : classes) {
            String[] exts;
            AbstractDataContainerWriter writer = (AbstractDataContainerWriter)ChooserHelper.getInstance(AbstractDataContainerWriter.class, clazz);
            if (writer == null) continue;
            for (String ext : exts = writer.getFormatExtensions()) {
                if (!ext.toLowerCase().equals(fileExt)) continue;
                result.add(clazz);
                continue block0;
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getReportReadersForFile(Class cls, File file) {
        Vector<String> result = new Vector<String>();
        String[] classes = ClassLister.getSingleton().getClassnames(cls);
        String fileExt = file.getName().toLowerCase().replaceAll(".*\\.", "");
        block0: for (String clazz : classes) {
            String[] exts;
            AbstractReportReader reader = (AbstractReportReader)ChooserHelper.getInstance(AbstractReportReader.class, clazz);
            if (reader == null) continue;
            for (String ext : exts = reader.getFormatExtensions()) {
                if (!ext.toLowerCase().equals(fileExt)) continue;
                result.add(clazz);
                continue block0;
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getReportWritersForFile(Class cls, File file) {
        Vector<String> result = new Vector<String>();
        String[] classes = ClassLister.getSingleton().getClassnames(cls);
        String fileExt = file.getName().toLowerCase().replaceAll(".*\\.", "");
        block0: for (String clazz : classes) {
            String[] exts;
            AbstractReportWriter writer = (AbstractReportWriter)ChooserHelper.getInstance(AbstractReportWriter.class, clazz);
            if (writer == null) continue;
            for (String ext : exts = writer.getFormatExtensions()) {
                if (!ext.toLowerCase().equals(fileExt)) continue;
                result.add(clazz);
                continue block0;
            }
        }
        return result.toArray(new String[result.size()]);
    }
}

