/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.provenance;

import adams.core.CloneHandler;
import adams.core.net.HtmlUtils;
import adams.core.option.OptionUtils;
import adams.flow.provenance.ProvenanceInformation;
import adams.gui.core.BaseTreeNode;
import adams.gui.flow.provenance.ProvenanceTree;

public class ProvenanceNode
extends BaseTreeNode
implements CloneHandler<ProvenanceNode> {
    private static final long serialVersionUID = 624983664888717132L;
    protected ProvenanceTree m_Owner;

    public ProvenanceNode(ProvenanceTree owner) {
        this.m_Owner = owner;
    }

    public ProvenanceNode(ProvenanceTree owner, ProvenanceInformation info) {
        super(info);
        this.m_Owner = owner;
    }

    public void setOwner(ProvenanceTree value) {
        this.m_Owner = value;
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((ProvenanceNode)this.getChildAt(i)).setOwner(value);
        }
    }

    public ProvenanceTree getOwner() {
        return this.m_Owner;
    }

    public boolean hasProvenanceInformation() {
        return this.getUserObject() != null;
    }

    public ProvenanceInformation getProvenanceInformation() {
        return (ProvenanceInformation)this.getUserObject();
    }

    public String getClassname() {
        if (this.hasProvenanceInformation()) {
            return this.getProvenanceInformation().getClassname();
        }
        return null;
    }

    @Override
    public ProvenanceNode getClone() {
        ProvenanceNode result = new ProvenanceNode(this.getOwner(), this.getProvenanceInformation());
        for (int i = 0; i < this.getChildCount(); ++i) {
            ProvenanceNode child = ((ProvenanceNode)this.getChildAt(i)).getClone();
            result.add(child);
        }
        return result;
    }

    protected String classToString(Class cls) {
        StringBuilder result = new StringBuilder();
        Class<?> type = cls;
        if (type.isArray()) {
            type = type.getComponentType();
        }
        String name = type.getName();
        if (this.m_Owner != null) {
            for (int n = 0; n < this.m_Owner.getInputOutputPrefixes().length; ++n) {
                String prefix = this.m_Owner.getInputOutputPrefixes()[n];
                if (!name.startsWith(prefix)) continue;
                name = name.replace(prefix, "");
            }
        }
        result.append(name);
        if (cls.isArray()) {
            result.append("[]");
        }
        return result.toString();
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("<html>");
        if (this.hasProvenanceInformation()) {
            ProvenanceInformation info = this.getProvenanceInformation();
            if (info.hasOutputDataType()) {
                if (this.m_Owner == null) {
                    result.append("Output: " + HtmlUtils.toHTML(this.classToString(info.getOutputDataType())));
                } else {
                    result.append("<font size='" + this.m_Owner.getInputOutputSize() + "' color='" + this.m_Owner.getInputOutputColor() + "'>" + "Output: " + HtmlUtils.toHTML(this.classToString(info.getOutputDataType())) + "</font>");
                }
                result.append("<br>");
            }
            if (this.m_Owner == null) {
                result.append(HtmlUtils.toHTML(info.getActorType().toString()));
            } else {
                result.append("<font size='" + this.m_Owner.getActorTypeSize() + "' color='" + this.m_Owner.getActorTypeColor() + "'>" + HtmlUtils.toHTML(info.getActorType().toString()) + "</font>");
            }
            result.append(" ");
            if (this.m_Owner == null) {
                result.append(HtmlUtils.toHTML(OptionUtils.joinOptions(info.getOptions())));
            } else {
                result.append("<font size='" + this.m_Owner.getOptionsSize() + "' color='" + this.m_Owner.getOptionsColor() + "'>" + HtmlUtils.toHTML(OptionUtils.joinOptions(info.getOptions())) + "</font>");
            }
            if (info.hasInputDataType()) {
                result.append("<br>");
                if (this.m_Owner == null) {
                    result.append("Input: " + HtmlUtils.toHTML(this.classToString(info.getInputDataType())));
                } else {
                    result.append("<font size='" + this.m_Owner.getInputOutputSize() + "' color='" + this.m_Owner.getInputOutputColor() + "'>" + "Input: " + HtmlUtils.toHTML(this.classToString(info.getInputDataType())) + "</font>");
                }
            }
        } else {
            result.append("<b>[none]</b>");
        }
        result.append("</html>");
        return result.toString();
    }
}

