/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.core.ConsoleObject;
import adams.core.Properties;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionHandler;
import adams.env.Environment;
import adams.event.DatabaseConnectionChangeEvent;
import adams.event.DatabaseConnectionChangeListener;
import adams.gui.core.BasePanel;
import adams.gui.event.ScriptingInfoEvent;
import adams.gui.event.ScriptingInfoListener;
import adams.gui.scripting.AbstractCommandProcessor;
import adams.gui.scripting.ScriptingCommand;
import adams.gui.scripting.ScriptingCommandCode;
import adams.gui.scripting.ScriptingEngineThread;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public abstract class AbstractScriptingEngine
extends ConsoleObject
implements DatabaseConnectionHandler,
DatabaseConnectionChangeListener {
    private static final long serialVersionUID = -532845009254256601L;
    public static final String FILENAME = "ScriptingEngine.props";
    public static final String SCRIPT_DIRECTORY = "ScriptDirectory";
    public static final String LOG_FILE = "ScriptingLogFile";
    public static final String LOG_ENABLED = "ScriptingLogEnabled";
    public static final String COMMAND_PROCESSOR = "CommandProcessorClass";
    public static final String ALTERNATIVE_COMMAND_PROCESSOR = "AlternativeCommandProcessorClass";
    public static final String COMMENT = "#";
    protected AbstractDatabaseConnection m_DbConn;
    protected Vector<String> m_History;
    protected boolean m_Recording;
    protected Vector<String> m_Recorded;
    protected HashSet<ScriptingInfoListener> m_ScriptingInfoListeners;
    protected String m_LastError;
    protected boolean m_LoggingEnabled;
    protected String m_LogFile;
    protected static boolean m_LogCleared;
    protected AbstractCommandProcessor m_Processor;
    protected ScriptingEngineThread m_ProcessingThread;
    protected int m_DebugLevel = this.initDebugLevel();

    protected AbstractScriptingEngine() {
        this.getDebugging().setEnabled(this.getDebugLevel() > 0);
        this.m_History = new Vector();
        this.m_Recording = false;
        this.m_Recorded = new Vector();
        this.m_ScriptingInfoListeners = new HashSet();
        this.m_LastError = null;
        this.m_Processor = null;
        this.m_ProcessingThread = null;
        this.m_DbConn = this.getDefaultDatabaseConnection();
        this.m_DbConn.addChangeListener(this);
        this.getProcessingThread().start();
        this.m_LoggingEnabled = this.getProperties().getBoolean(LOG_ENABLED, false);
        this.m_LogFile = this.getScriptsLog();
        this.clearLog();
        this.updatePrefix();
    }

    protected void updatePrefix() {
        String prefix = this.getClass().getName() + "(" + this.getDatabaseConnection().toStringShort() + "/" + this.getDatabaseConnection().hashCode() + ")";
        this.getSystemOut().setPrefix(prefix);
        this.getSystemErr().setPrefix(prefix);
        this.getDebugging().setPrefix(prefix);
    }

    protected abstract int initDebugLevel();

    protected int getDebugLevel() {
        return this.m_DebugLevel;
    }

    protected abstract AbstractDatabaseConnection getDefaultDatabaseConnection();

    public synchronized AbstractCommandProcessor getProcessor() {
        if (this.m_Processor == null) {
            try {
                String classname = this.getProperties().getString(ALTERNATIVE_COMMAND_PROCESSOR, "").trim();
                if (classname.length() == 0) {
                    classname = this.getProperties().getString(COMMAND_PROCESSOR, "noCommandProcessorClassDefined");
                }
                Class<?> cls = Class.forName(classname);
                Constructor<?> constr = cls.getConstructor(AbstractScriptingEngine.class);
                this.m_Processor = (AbstractCommandProcessor)constr.newInstance(this);
            }
            catch (Exception e) {
                this.getSystemErr().printStackTrace(e);
                this.m_Processor = null;
            }
        }
        return this.m_Processor;
    }

    public synchronized ScriptingEngineThread getProcessingThread() {
        if (this.m_ProcessingThread == null) {
            this.m_ProcessingThread = new ScriptingEngineThread(this);
        }
        return this.m_ProcessingThread;
    }

    @Override
    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_DbConn;
    }

    @Override
    public void setDatabaseConnection(AbstractDatabaseConnection value) {
        this.m_DbConn.removeChangeListener(this);
        this.m_DbConn = value != null ? value : DatabaseConnection.getSingleton();
        this.m_DbConn.addChangeListener(this);
        if (this.isRecording()) {
            this.startRecording();
        }
        this.updatePrefix();
    }

    public boolean isEmpty() {
        return this.getProcessingThread().isEmpty();
    }

    public boolean isProcessing() {
        return this.getProcessingThread().isProcessing();
    }

    public void stop() {
        this.getProcessingThread().clear();
    }

    public synchronized void stopEngine() {
        if (!this.isEmpty() || this.isProcessing()) {
            this.stop();
        }
        this.getProcessingThread().stopExecution();
        DatabaseConnection.getSingleton().removeChangeListener(this);
    }

    public void addToHistory(String cmd) {
        this.m_History.add(cmd);
        if (this.m_Recording) {
            this.m_Recorded.add(cmd);
        }
    }

    public Vector<String> getCommandHistory() {
        return this.m_History;
    }

    public void startRecording() {
        this.m_Recording = true;
        this.m_Recorded.clear();
        this.m_Recorded.add("# Recording started at " + new Date());
        this.m_Recorded.add("");
        if (this.getDebugLevel() > 0) {
            this.getDebugging().println("Recoding started");
        }
    }

    public void stopRecording() {
        this.m_Recording = false;
        this.m_Recorded.add("");
        this.m_Recorded.add("# Recording stopped at " + new Date());
        if (this.getDebugLevel() > 0) {
            this.getDebugging().println("Recoding stopped");
        }
    }

    public boolean isRecording() {
        return this.m_Recording;
    }

    public boolean hasRecording() {
        return this.m_Recorded.size() > 0;
    }

    public Vector<String> getRecordedCommands() {
        return this.m_Recorded;
    }

    public void clear() {
        this.getProcessingThread().clear();
        this.m_History.add("");
        this.m_History.add("# command queue emptied");
        this.m_History.add("");
        if (this.getDebugLevel() > 0) {
            this.getDebugging().println("Cleared");
        }
    }

    public synchronized void add(ScriptingCommand command) {
        this.getProcessingThread().add(command);
        if (this.getDebugLevel() > 1) {
            this.getDebugging().println("add: " + command);
        }
    }

    public synchronized void add(BasePanel panel, String cmd, ScriptingCommandCode code) {
        this.add(new ScriptingCommand(panel, cmd, code));
    }

    public synchronized void add(BasePanel panel, String command) {
        if (AbstractScriptingEngine.check(command)) {
            this.add(new ScriptingCommand(panel, command));
        }
    }

    public synchronized void add(BasePanel panel, String[] commands) {
        commands = AbstractScriptingEngine.filter(commands);
        for (int i = 0; i < commands.length; ++i) {
            this.add(new ScriptingCommand(panel, commands[i]));
        }
    }

    public synchronized void add(BasePanel panel, Vector<String> commands) {
        commands = AbstractScriptingEngine.filter(commands);
        for (int i = 0; i < commands.size(); ++i) {
            this.add(new ScriptingCommand(panel, commands.get(i)));
        }
    }

    public synchronized void add(BasePanel panel, File commandFile) {
        this.add(panel, AbstractScriptingEngine.load(commandFile));
    }

    public synchronized boolean clearLog() {
        boolean result;
        if (!this.m_LoggingEnabled || m_LogCleared) {
            return true;
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.getScriptsLog(), false));
            writer.write(Utils.commentOut("Log started at " + new Date(), "# "));
            writer.newLine();
            writer.flush();
            writer.close();
            result = true;
            m_LogCleared = true;
        }
        catch (Exception e) {
            result = false;
        }
        if (this.getDebugLevel() > 1) {
            this.getDebugging().println("Log cleared: " + result);
        }
        return result;
    }

    protected boolean log(String msg, boolean commentOut) {
        boolean result;
        if (!this.m_LoggingEnabled) {
            return true;
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.m_LogFile, true));
            writer.write("# ScriptingEngine (" + this.hashCode() + "):");
            writer.newLine();
            if (commentOut) {
                msg = Utils.commentOut(msg, "# ");
            }
            writer.write(msg);
            writer.newLine();
            writer.flush();
            writer.close();
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public void addScriptingInfoListener(ScriptingInfoListener l) {
        this.m_ScriptingInfoListeners.add(l);
    }

    public void removeScriptingInfoListener(ScriptingInfoListener l) {
        this.m_ScriptingInfoListeners.remove(l);
    }

    public void notifyScriptingInfoListeners(String cmd) {
        ScriptingInfoEvent event = new ScriptingInfoEvent(this, cmd);
        Iterator<ScriptingInfoListener> iter = this.m_ScriptingInfoListeners.iterator();
        while (iter.hasNext()) {
            iter.next().scriptingInfo(event);
        }
    }

    public boolean hasLastError() {
        return this.m_LastError != null;
    }

    public void setLastError(String value) {
        this.m_LastError = value;
        if (this.getDebugLevel() > 0) {
            this.getDebugging().println("Last error: " + value);
        }
    }

    public String getLastError() {
        return this.m_LastError;
    }

    public static boolean check(String cmd) {
        boolean result = true;
        if (cmd.trim().startsWith(COMMENT)) {
            result = false;
        } else if (cmd.trim().length() == 0) {
            result = false;
        }
        return result;
    }

    public static String[] filter(String[] cmds) {
        Vector<String> list = new Vector<String>();
        for (int i = 0; i < cmds.length; ++i) {
            list.add(cmds[i]);
        }
        list = AbstractScriptingEngine.filter(list);
        return list.toArray(new String[list.size()]);
    }

    public static Vector<String> filter(Vector<String> cmds) {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < cmds.size(); ++i) {
            if (!AbstractScriptingEngine.check(cmds.get(i))) continue;
            result.add(cmds.get(i));
        }
        return result;
    }

    public static Vector<String> load(File file) {
        return FileUtils.loadFromFile(file);
    }

    public static boolean save(String[] script, File file) {
        return FileUtils.saveToFile(script, file);
    }

    public static boolean save(Vector<String> script, File file) {
        return FileUtils.saveToFile(script, file);
    }

    protected abstract String getDefinitionKey();

    protected synchronized Properties readProperties() {
        return Environment.getInstance().read(this.getDefinitionKey());
    }

    protected abstract Properties getProperties();

    public String getScriptsHome() {
        return this.getProperties().getString(SCRIPT_DIRECTORY, "%p/scripts");
    }

    public String getScriptsLog() {
        return this.getProperties().getString(LOG_FILE, "%h/scripts.log");
    }

    public Vector<String> getAvailableScripts() {
        return AbstractScriptingEngine.getAvailableScripts(this.getScriptsHome());
    }

    protected static Vector<String> getAvailableScripts(String home) {
        Vector<String> result = new Vector<String>();
        File file = new File(home);
        if (file.exists()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory() || files[i].getName().endsWith("~") || files[i].getName().endsWith(".bak") || files[i].getName().startsWith(".")) continue;
                result.add(files[i].getAbsolutePath());
            }
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public void databaseConnectionStateChanged(DatabaseConnectionChangeEvent e) {
        if (e.getType() == DatabaseConnectionChangeEvent.Type.CONNECT) {
            this.setDatabaseConnection(e.getDatabaseConnection());
        }
    }
}

