/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableSingleClassifierEnhancer;
import weka.classifiers.functions.SMO;
import weka.classifiers.meta.CVParameterSelectionAUC;
import weka.classifiers.meta.CVParameterSelectionAUCMulti;
import weka.classifiers.meta.IterativeHMMClassifier;
import weka.classifiers.sequence.IterativeProfileHMMClassifierSingleHMM;
import weka.classifiers.sequence.core.IllegalSymbolException;
import weka.classifiers.sequence.core.ImpossibleStateProbabilityException;
import weka.classifiers.sequence.core.InvalidStructureException;
import weka.classifiers.sequence.core.InvalidViterbiPathException;
import weka.classifiers.sequence.core.NumericStabilityException;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.converters.ArffLoader;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.RemoveWithValues;
import weka.utils.OptFileFilter;

public class IterativeHMMKernelizer
extends RandomizableSingleClassifierEnhancer
implements IterativeHMMClassifier<IterativeProfileHMMClassifierSingleHMM> {
    private static final long serialVersionUID = -5885510190237928451L;
    private static final String Model_DIR = "/set/appropriate/path";
    private IterativeProfileHMMClassifierSingleHMM m_sequenceLearner = new IterativeProfileHMMClassifierSingleHMM();
    protected Instances m_AlignedInstances;
    protected boolean m_reUseModels = false;
    protected int iterationStepSize;
    protected int iterationCount;
    protected boolean noKernelClassification;
    private int actualFold;
    private int numberOfFolds;
    private int modelNumber;
    protected boolean testSetAlreadyPropositionalised;
    private boolean firstTime;

    @Override
    public int getActualFold() {
        return this.actualFold;
    }

    @Override
    public int getNumberOfFolds() {
        return this.numberOfFolds;
    }

    @Override
    public void setActualFold(int actualFold) {
        this.actualFold = actualFold;
    }

    @Override
    public void setNumberOfFolds(int numberOfFolds) {
        this.numberOfFolds = numberOfFolds;
    }

    public String globalInfo() {
        return "";
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.functions.SMO";
    }

    protected String defaultSequenceLearnerString() {
        return "weka.classifiers.sequence.ProfileHMMClassifierNumbers";
    }

    public IterativeHMMKernelizer() {
        this.m_Classifier = new SMO();
        this.m_sequenceLearner = new IterativeProfileHMMClassifierSingleHMM();
        this.m_reUseModels = false;
        this.iterationCount = 0;
        this.noKernelClassification = false;
        this.testSetAlreadyPropositionalised = false;
        this.firstTime = false;
    }

    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>(7);
        newVector.addElement(new Option("\tFull class name of HMM classification algorithm to use, followed\n\tby HMM options.\n\teg: \"weka.classifiers.sequence.ProfileHMMClassifier\"", "H", 1, "-H <HMM specification>"));
        newVector.addElement(new Option("\tre-use already built HMM-models\n", "R", 0, "-R "));
        newVector.addElement(new Option("\tno Propositionalisation, just baseline HMM Classification\n", "N", 0, "-N "));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String hmmString = Utils.getOption((char)'H', (String[])options);
        if (hmmString.length() > 0) {
            String[] hmmSpec = Utils.splitOptions((String)hmmString);
            if (hmmSpec.length == 0) {
                throw new IllegalArgumentException("Invalid HMM specification string");
            }
            String hmmName = hmmSpec[0];
            hmmSpec[0] = "";
            this.setSequenceLearner((IterativeProfileHMMClassifierSingleHMM)Utils.forName(IterativeProfileHMMClassifierSingleHMM.class, (String)hmmName, (String[])hmmSpec));
        } else {
            this.setSequenceLearner(new IterativeProfileHMMClassifierSingleHMM());
        }
        this.m_reUseModels = Utils.getFlag((char)'R', (String[])options);
        this.noKernelClassification = Utils.getFlag((char)'N', (String[])options);
        super.setOptions(options);
    }

    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 17];
        int current = 0;
        options[current++] = "-H";
        options[current++] = "" + this.getSequenceLearnerSpec();
        if (this.m_reUseModels) {
            options[current++] = "-R";
        }
        if (this.noKernelClassification) {
            options[current++] = "-N";
        }
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        current += superOptions.length;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public void setSequenceLearner(IterativeProfileHMMClassifierSingleHMM hmm) {
        this.m_sequenceLearner = hmm;
    }

    @Override
    public IterativeProfileHMMClassifierSingleHMM getSequenceLearner() {
        return this.m_sequenceLearner;
    }

    protected String getSequenceLearnerSpec() {
        IterativeProfileHMMClassifierSingleHMM c = this.getSequenceLearner();
        if (c instanceof OptionHandler) {
            return c.getClass().getName() + " " + Utils.joinOptions((String[])c.getOptions());
        }
        return c.getClass().getName();
    }

    public Capabilities getCapabilities() {
        Capabilities result = this.getSequenceLearner() == null ? super.getCapabilities() : this.getSequenceLearner().getCapabilities();
        for (Capabilities.Capability cap : Capabilities.Capability.values()) {
            result.enableDependency(cap);
        }
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        if (this.m_Classifier == null) {
            throw new Exception("No base classifiers have been set!");
        }
        this.m_AlignedInstances = null;
        this.testSetAlreadyPropositionalised = false;
        data = new Instances(data);
        data.deleteWithMissingClass();
        this.getSequenceLearner().getCapabilities().testWithFail(data);
        if (!this.m_reUseModels) {
            System.out.println("buildHMM");
            this.doIterations(data);
        } else {
            this.modelNumber = this.reUseModels(data);
            System.out.println("arff and object saved");
            if (!this.noKernelClassification) {
                this.reUseKernelArffs(data, true);
                System.out.println("prop arff saved");
            }
        }
        if (!this.noKernelClassification) {
            System.out.println("use second classifier");
            this.getClassifier().getCapabilities().testWithFail(this.m_AlignedInstances);
            this.m_Classifier.buildClassifier(this.m_AlignedInstances);
        }
    }

    private void doIterations(Instances data) throws Exception, IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException, ImpossibleStateProbabilityException {
        if (!this.noKernelClassification) {
            if (this.iterationCount == 0) {
                this.m_sequenceLearner.initClassifier(data);
            }
            for (int i = 0; i < this.iterationStepSize; ++i) {
                ++this.iterationCount;
                this.m_sequenceLearner.next(this.iterationCount);
            }
            System.out.println("do prop");
            this.m_AlignedInstances = this.m_sequenceLearner.extractSufficientStatistics(data);
        } else {
            if (this.iterationCount == 0) {
                this.m_sequenceLearner.initClassifier(data);
            }
            for (int i = 0; i < this.iterationStepSize; ++i) {
                ++this.iterationCount;
                this.m_sequenceLearner.next(this.iterationCount);
            }
        }
    }

    public Instances getPropositionalTestSet(Instances testData) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException, ImpossibleStateProbabilityException, IOException, NumericStabilityException {
        if (!this.noKernelClassification) {
            this.reUseKernelArffs(testData, false);
        }
        this.testSetAlreadyPropositionalised = true;
        if (this.noKernelClassification) {
            return testData;
        }
        return this.m_AlignedInstances;
    }

    private void reUseKernelArffs(Instances data, boolean train) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException, ImpossibleStateProbabilityException, IOException, NumericStabilityException {
        File dir;
        String dirName = "";
        int modelLength = this.m_sequenceLearner.getRestrictMatchColumns();
        int sampleMethod = this.m_sequenceLearner.getSampleMethod();
        String length = modelLength == -1 ? "f" : modelLength + "";
        String sample = sampleMethod == -1 ? null : (sampleMethod == 1 ? "sampleUNI" : "sample" + sampleMethod);
        if (!(this.m_sequenceLearner instanceof IterativeProfileHMMClassifierSingleHMM)) {
            if (sampleMethod == -1) {
                dir = new File(Model_DIR + data.relationName() + "/bc" + "/l" + length + "/kernelArffs/");
                dirName = Model_DIR + data.relationName() + "/bc" + "/l" + length + "/kernelArffs/";
            } else {
                dir = new File(Model_DIR + data.relationName() + "/bc" + "/l" + length + "/" + sample + "/kernelArffs/");
                dirName = Model_DIR + data.relationName() + "/bc" + "/l" + length + "/" + sample + "/kernelArffs/";
            }
        } else {
            int classIndex = this.m_sequenceLearner.getClassIndexToKeep();
            String classNumber = classIndex == -1 ? "all" : classIndex + "";
            dir = new File(Model_DIR + data.relationName() + "/oneClass_" + classNumber + "/l" + length + "/kernelArffs/");
            dirName = Model_DIR + data.relationName() + "/oneClass_" + classNumber + "/l" + length + "/kernelArffs/";
        }
        if (!dir.exists()) {
            dir.mkdirs();
            if (train) {
                this.writePropInstances(data, dirName);
            } else {
                this.writePropInstances(data, dirName + "test_");
            }
        } else {
            File arff;
            if (!train) {
                dirName = dirName + "test_";
            }
            if (!(arff = new File(dirName + "model_prop_" + this.modelNumber + ".arff")).exists()) {
                arff = new File(dirName + "model_prop_" + this.modelNumber + ".arff.gz");
            }
            if (arff.exists()) {
                System.out.println("re-use prop");
                ArffLoader loader = new ArffLoader();
                loader.setFile(arff);
                this.m_AlignedInstances = loader.getDataSet();
                this.m_AlignedInstances.setClassIndex(this.m_AlignedInstances.numAttributes() - 1);
            } else {
                this.writePropInstances(data, dirName);
            }
        }
    }

    private void writePropInstances(Instances data, String dirName) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException, ImpossibleStateProbabilityException, IOException, NumericStabilityException {
        System.out.println("do prop");
        this.m_AlignedInstances = this.m_sequenceLearner.extractSufficientStatistics(data);
        File arff = new File(dirName + "model_prop_" + this.modelNumber + ".arff.gz");
        if (arff.exists()) {
            arff.delete();
        }
        if (!(arff = new File(dirName + "model_prop_" + this.modelNumber + ".arff")).exists()) {
            arff.createNewFile();
        }
        BufferedWriter outSpec = new BufferedWriter(new FileWriter(dirName + "model_prop_" + this.modelNumber + ".arff"));
        outSpec.write(this.m_AlignedInstances.toString());
        outSpec.flush();
        outSpec.close();
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (!this.noKernelClassification) {
            if (!this.testSetAlreadyPropositionalised) {
                return this.m_Classifier.distributionForInstance(this.m_sequenceLearner.extractSufficientStatisticsTestInstance(instance));
            }
            return this.m_Classifier.distributionForInstance(instance);
        }
        return this.m_sequenceLearner.distributionForInstance(instance);
    }

    private int reUseModels(Instances actualInstances) throws Exception {
        File dir;
        Object filter;
        String dirName;
        String relationName = actualInstances.relationName();
        int modelLength = this.m_sequenceLearner.getRestrictMatchColumns();
        int sampleMethod = this.m_sequenceLearner.getSampleMethod();
        String length = modelLength == -1 ? "f" : modelLength + "";
        String sample = sampleMethod == -1 ? null : (sampleMethod == 1 ? "sampleUNI" : "sample" + sampleMethod);
        if (!(this.m_sequenceLearner instanceof IterativeProfileHMMClassifierSingleHMM)) {
            dirName = sampleMethod == -1 ? Model_DIR + relationName + "/bc" + "/l" + length + "/" : Model_DIR + relationName + "/bc" + "/l" + length + "/" + sample + "/";
        } else {
            int classIndex = this.m_sequenceLearner.getClassIndexToKeep();
            length = modelLength == -1 ? "f" : modelLength + "";
            String classNumber = classIndex == -1 ? "all" : classIndex + "";
            dirName = Model_DIR + relationName + "/oneClass_" + classNumber + "/l" + length + "/";
            int index = this.m_sequenceLearner.getClassIndexToKeep();
            if (index >= 0) {
                filter = new RemoveWithValues();
                String[] options = new String[]{"-L", index + 1 + "", "-C", actualInstances.classIndex() + 1 + "", "-V"};
                filter.setInputFormat(actualInstances);
                filter.setOptions(options);
                actualInstances = new Instances(Filter.useFilter((Instances)actualInstances, (Filter)filter));
                actualInstances.setRelationName(relationName);
            }
        }
        File searchPath = new File(dirName);
        if (!searchPath.exists()) {
            System.out.println("buildHMM");
            this.doIterations(actualInstances);
            this.writeModels(actualInstances, 1);
            System.out.println("model written");
            return 1;
        }
        String hmmOptions = "";
        for (int i = 0; i < this.getOptions().length; ++i) {
            if (this.getOptions()[i] == null || !this.getOptions()[i].equals("-H")) continue;
            hmmOptions = this.getOptions()[++i];
            break;
        }
        hmmOptions = hmmOptions.replaceAll("-Y -?\\d", "");
        if (!(this.m_sequenceLearner instanceof IterativeProfileHMMClassifierSingleHMM)) {
            dir = sampleMethod == -1 ? new File(Model_DIR + relationName + "/bc" + "/l" + length + "/iterativeOpts/") : new File(Model_DIR + relationName + "/bc" + "/l" + length + "/" + sample + "/iterativeOpts/");
        } else {
            modelLength = this.m_sequenceLearner.getRestrictMatchColumns();
            int classIndex = this.m_sequenceLearner.getClassIndexToKeep();
            length = modelLength == -1 ? "f" : modelLength + "";
            String classNumber = classIndex == -1 ? "all" : classIndex + "";
            dir = new File(Model_DIR + relationName + "/oneClass_" + classNumber + "/l" + length + "/iterativeOpts/");
        }
        filter = new OptFileFilter();
        File[] files = dir.listFiles((FilenameFilter)filter);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                BufferedReader inNum = new BufferedReader(new FileReader(files[i]));
                String spec = inNum.readLine();
                String iterationSpec = inNum.readLine();
                int iterationNumberFile = Integer.parseInt(iterationSpec);
                String actualFoldSpec = inNum.readLine();
                int actualFoldFile = Integer.parseInt(actualFoldSpec);
                String numberOfFoldsSpec = inNum.readLine();
                int numberOfFoldsFile = Integer.parseInt(numberOfFoldsSpec);
                String seedSpec = inNum.readLine();
                int seedFile = Integer.parseInt(seedSpec);
                inNum.close();
                if (!spec.equals(hmmOptions) || iterationNumberFile != this.getIterationCount() + 1 || actualFoldFile != this.getActualFold() || numberOfFoldsFile != this.getNumberOfFolds() || seedFile != this.getSeed()) continue;
                String determineNumber = files[i].getName();
                determineNumber = determineNumber.substring(determineNumber.lastIndexOf("_") + 1, determineNumber.lastIndexOf("."));
                File arff = new File(dirName + "model_" + determineNumber + ".arff.gz");
                if (!arff.exists()) {
                    arff = new File(dirName + "model_" + determineNumber + ".arff");
                }
                ArffLoader loader = new ArffLoader();
                loader.setFile(arff);
                Instances loadedInstances = loader.getDataSet();
                loadedInstances.setClassIndex(actualInstances.classIndex());
                if (!loadedInstances.equalHeaders(actualInstances) || loadedInstances.numInstances() != actualInstances.numInstances()) continue;
                int j = 0;
                int k = 0;
                boolean equals = true;
                for (j = 0; j < loadedInstances.numInstances(); ++j) {
                    Instance loaded = loadedInstances.instance(j);
                    Instance actual = actualInstances.instance(j);
                    for (k = 0; k < loaded.numAttributes(); ++k) {
                        if (loaded.attribute(k).isNumeric()) {
                            if (loaded.value(k) == actual.value(k)) continue;
                            equals = false;
                            break;
                        }
                        if (loaded.stringValue(k).equals(actual.stringValue(k))) continue;
                        equals = false;
                        break;
                    }
                    if (!equals) break;
                }
                if (!equals) continue;
                System.out.println("re-use model");
                FileInputStream fis = new FileInputStream(dirName + "model_" + determineNumber + ".obj");
                ObjectInputStream ois = new ObjectInputStream(fis);
                this.m_sequenceLearner = (IterativeProfileHMMClassifierSingleHMM)ois.readObject();
                ois.close();
                fis.close();
                System.gc();
                this.iterationCount = iterationNumberFile;
                return Integer.parseInt(determineNumber);
            }
        }
        System.out.println("buildHMM");
        this.doIterations(actualInstances);
        BufferedReader inNum = new BufferedReader(new FileReader(dirName + "models" + ".num"));
        int modelNumber = Integer.parseInt(inNum.readLine());
        inNum.close();
        this.writeModels(actualInstances, ++modelNumber);
        return modelNumber;
    }

    private void writeModels(Instances actualInstances, int modelNumber) throws Exception {
        String dirName;
        String classNumber;
        int classIndex;
        File dir;
        String relationName = actualInstances.relationName();
        String hmmOptions = "";
        int modelLength = this.m_sequenceLearner.getRestrictMatchColumns();
        int sampleMethod = this.m_sequenceLearner.getSampleMethod();
        String length = modelLength == -1 ? "f" : modelLength + "";
        String sample = sampleMethod == -1 ? null : (sampleMethod == 1 ? "sampleUNI" : "sample" + sampleMethod);
        if (!(this.m_sequenceLearner instanceof IterativeProfileHMMClassifierSingleHMM)) {
            dir = sampleMethod == -1 ? new File(Model_DIR + relationName + "/bc" + "/l" + length + "/iterativeOpts/") : new File(Model_DIR + relationName + "/bc" + "/l" + length + "/" + sample + "/iterativeOpts/");
        } else {
            modelLength = this.m_sequenceLearner.getRestrictMatchColumns();
            classIndex = this.m_sequenceLearner.getClassIndexToKeep();
            length = modelLength == -1 ? "f" : modelLength + "";
            classNumber = classIndex == -1 ? "all" : classIndex + "";
            dir = new File(Model_DIR + relationName + "/oneClass_" + classNumber + "/l" + length + "/iterativeOpts/");
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        for (int i = 0; i < this.getOptions().length; ++i) {
            if (this.getOptions()[i] == null || !this.getOptions()[i].equals("-H")) continue;
            hmmOptions = this.getOptions()[++i];
            break;
        }
        hmmOptions = hmmOptions.replaceAll("-Y -?\\d", "");
        if (!(this.m_sequenceLearner instanceof IterativeProfileHMMClassifierSingleHMM)) {
            dirName = sampleMethod == -1 ? Model_DIR + relationName + "/bc" + "/l" + length + "/" : Model_DIR + relationName + "/bc" + "/l" + length + "/" + sample + "/";
        } else {
            modelLength = this.m_sequenceLearner.getRestrictMatchColumns();
            classIndex = this.m_sequenceLearner.getClassIndexToKeep();
            length = modelLength == -1 ? "f" : modelLength + "";
            classNumber = classIndex == -1 ? "all" : classIndex + "";
            dirName = Model_DIR + relationName + "/oneClass_" + classNumber + "/l" + length + "/";
        }
        File opt = new File(dirName + "iterativeOpts/model_" + modelNumber + ".opt");
        if (!opt.exists()) {
            opt.createNewFile();
        }
        BufferedWriter outSpec = new BufferedWriter(new FileWriter(dirName + "iterativeOpts/model_" + modelNumber + ".opt"));
        outSpec.write(hmmOptions + "\n");
        outSpec.write(this.getIterationCount() + "\n");
        outSpec.write(this.getActualFold() + "\n");
        outSpec.write(this.getNumberOfFolds() + "\n");
        outSpec.write(this.getSeed() + "");
        outSpec.flush();
        outSpec.close();
        File num = new File(dirName + "models.num");
        if (!num.exists()) {
            num.createNewFile();
        }
        outSpec = new BufferedWriter(new FileWriter(dirName + "models" + ".num"));
        outSpec.write(modelNumber + "");
        outSpec.flush();
        outSpec.close();
        File arff = new File(dirName + "model_" + modelNumber + ".arff.gz");
        if (arff.exists()) {
            arff.delete();
        }
        if (!(arff = new File(dirName + "model_" + modelNumber + ".arff")).exists()) {
            arff.createNewFile();
        }
        outSpec = new BufferedWriter(new FileWriter(dirName + "model_" + modelNumber + ".arff"));
        if (!(this.m_sequenceLearner instanceof IterativeProfileHMMClassifierSingleHMM)) {
            outSpec.write(actualInstances.toString());
        } else {
            outSpec.write(this.m_sequenceLearner.getOneClassClassificationArff().toString());
        }
        outSpec.flush();
        outSpec.close();
        FileOutputStream fos = new FileOutputStream(dirName + "model_" + modelNumber + ".obj");
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(this.m_sequenceLearner);
        oos.flush();
        oos.close();
    }

    @Override
    public boolean getReUse() {
        return this.m_reUseModels;
    }

    @Override
    public void setReUse(boolean flag) {
        this.m_reUseModels = flag;
    }

    @Override
    public String reUseTipText() {
        return "Re-uses already built HMM models";
    }

    public String toString() {
        if (this.m_AlignedInstances == null) {
            return "No Propositionalisation\nClassification using the PHMM(s):\n" + this.m_sequenceLearner.toString();
        }
        String result = "HMMPropositionalizer using " + this.getClassifierSpec() + " on data propositionalized through " + this.getSequenceLearnerSpec() + "\n\nPropositionalized Instances Summary:\n" + this.m_AlignedInstances.toSummaryString() + "\n\nClassifier Model\n" + this.m_Classifier.toString();
        if (this.getDebug()) {
            return result;
        }
        String addInfo = "";
        if (this.m_Classifier instanceof CVParameterSelectionAUC) {
            addInfo = ((CVParameterSelectionAUC)this.m_Classifier).toSummaryString();
        }
        if (this.m_Classifier instanceof CVParameterSelectionAUCMulti) {
            addInfo = ((CVParameterSelectionAUCMulti)this.m_Classifier).toSummaryString();
        }
        return "Propositionalized Instances Short Summary:\nnumber of attributes:\t" + this.m_AlignedInstances.numAttributes() + "\nnumber of instances:\t" + this.m_AlignedInstances.numInstances() + "\n" + this.m_sequenceLearner.toString() + "\n" + addInfo;
    }

    @Override
    public String sequenceLearnerTipText() {
        return "The HMM model";
    }

    public static void main(String[] argv) {
        IterativeHMMKernelizer.runClassifier((Classifier)new IterativeHMMKernelizer(), (String[])argv);
    }

    public String getRevision() {
        return null;
    }

    @Override
    public int getIterationStepSize() {
        return this.iterationStepSize;
    }

    @Override
    public void setIterationStepSize(int iterationStepSize) {
        this.iterationStepSize = iterationStepSize;
    }

    @Override
    public boolean hmmsConverged() {
        return this.m_sequenceLearner.fullyConverged();
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    public boolean isNoPropositionalisation() {
        return this.noKernelClassification;
    }

    public void setNoPropositionalisation(boolean noPropositionalisation) {
        this.noKernelClassification = noPropositionalisation;
    }

    public boolean isFirstTime() {
        return this.firstTime;
    }

    public void setFirstTime(boolean firstTime) {
        this.firstTime = firstTime;
    }
}

