/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.ImagePlus;
import ij.plugin.LZWEncoder;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class GifEncoder {
    int width;
    int height;
    boolean transparent;
    int transIndex;
    int repeat = 0;
    protected int delay = 50;
    boolean started = false;
    OutputStream out;
    ImagePlus image;
    byte[] pixels;
    byte[] indexedPixels;
    int colorDepth;
    byte[] colorTab;
    int lctSize = 7;
    int dispose = 0;
    boolean closeStream = false;
    boolean firstFrame = true;
    boolean sizeSet = false;
    int sample = 2;
    byte[] gct = null;
    boolean GCTextracted = false;
    boolean GCTloadedExternal = false;
    int GCTred = 0;
    int GCTgrn = 0;
    int GCTbl = 0;
    int GCTcindex = 0;
    boolean GCTsetTransparent = false;
    boolean GCToverideIndex = false;
    boolean GCToverideColor = false;

    GifEncoder() {
    }

    public boolean addFrame(ImagePlus image) {
        if (image == null || !this.started) {
            return false;
        }
        boolean ok = true;
        try {
            if (this.firstFrame) {
                if (!this.sizeSet) {
                    this.setSize(image.getWidth(), image.getHeight());
                }
                this.writeLSD();
                if (this.repeat >= 0) {
                    this.writeNetscapeExt();
                }
                this.firstFrame = false;
            }
            int bitDepth = image.getBitDepth();
            this.Process8bitCLT(image);
            this.writeGraphicCtrlExt();
            this.writeImageDesc();
            this.writePalette();
            this.writePixels();
        }
        catch (IOException e) {
            ok = false;
        }
        return ok;
    }

    void Process8bitCLT(ImagePlus image) {
        this.colorDepth = 8;
        ImageProcessor ip = image.getProcessor();
        ip = ip.convertToByte(true);
        ColorModel cm = ip.getColorModel();
        this.indexedPixels = (byte[])ip.getPixels();
        IndexColorModel m = (IndexColorModel)cm;
        int mapSize = m.getMapSize();
        if (this.transIndex >= mapSize) {
            this.setTransparent(false);
            this.transIndex = 0;
        }
        this.colorTab = new byte[mapSize * 3];
        for (int i = 0; i < mapSize; ++i) {
            int k = i * 3;
            this.colorTab[k] = (byte)m.getRed(i);
            this.colorTab[k + 1] = (byte)m.getGreen(i);
            this.colorTab[k + 2] = (byte)m.getBlue(i);
        }
        m.finalize();
    }

    public boolean finish() {
        if (!this.started) {
            return false;
        }
        boolean ok = true;
        this.started = false;
        try {
            this.out.write(59);
            this.out.flush();
            if (this.closeStream) {
                this.out.close();
            }
        }
        catch (IOException e) {
            ok = false;
        }
        this.GCTextracted = false;
        this.GCTloadedExternal = false;
        this.transIndex = 0;
        this.transparent = false;
        this.gct = null;
        this.out = null;
        this.image = null;
        this.pixels = null;
        this.indexedPixels = null;
        this.colorTab = null;
        this.closeStream = false;
        this.firstFrame = true;
        return ok;
    }

    public void setDelay(int ms) {
        this.delay = Math.round((float)ms / 10.0f);
    }

    public void setDispose(int code) {
        if (code >= 0) {
            this.dispose = code;
        }
    }

    public void setFrameRate(float fps) {
        if (fps != 0.0f) {
            this.delay = Math.round(100.0f / fps);
        }
    }

    public void setQuality(int quality) {
        if (quality < 1) {
            quality = 1;
        }
        this.sample = quality;
    }

    public void setRepeat(int iter) {
        if (iter >= 0) {
            this.repeat = iter;
        }
    }

    public void setSize(int w, int h) {
        if (this.started && !this.firstFrame) {
            return;
        }
        this.width = w;
        this.height = h;
        if (this.width < 1) {
            this.width = 320;
        }
        if (this.height < 1) {
            this.height = 240;
        }
        this.sizeSet = true;
    }

    public void setTransparent(boolean c) {
        this.transparent = c;
    }

    public boolean start(OutputStream os) {
        if (os == null) {
            return false;
        }
        boolean ok = true;
        this.closeStream = false;
        this.out = os;
        try {
            this.writeString("GIF89a");
        }
        catch (IOException e) {
            ok = false;
        }
        this.started = ok;
        return this.started;
    }

    public boolean start(String file) {
        boolean ok = true;
        try {
            this.out = new BufferedOutputStream(new FileOutputStream(file));
            ok = this.start(this.out);
            this.closeStream = true;
        }
        catch (IOException e) {
            ok = false;
        }
        this.started = ok;
        return this.started;
    }

    public void OverRideQuality(int npixs) {
        this.sample = npixs > 100000 ? 10 : npixs / 10000;
        if (this.sample < 1) {
            this.sample = 1;
        }
    }

    protected void writeGraphicCtrlExt() throws IOException {
        int disp;
        int transp;
        this.out.write(33);
        this.out.write(249);
        this.out.write(4);
        if (!this.transparent) {
            transp = 0;
            disp = 0;
        } else {
            transp = 1;
            disp = 2;
        }
        if (this.dispose >= 0) {
            disp = this.dispose & 7;
        }
        this.out.write(0 | (disp <<= 2) | 0 | transp);
        this.writeShort(this.delay);
        this.out.write(this.transIndex);
        this.out.write(0);
    }

    protected void writeImageDesc() throws IOException {
        this.out.write(44);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(0x80 | this.lctSize);
    }

    protected void writeLSDgct() throws IOException {
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(0xF0 | this.lctSize);
        this.out.write(0);
        this.out.write(0);
    }

    protected void writeLSD() throws IOException {
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(112);
        this.out.write(0);
        this.out.write(0);
    }

    protected void writeNetscapeExt() throws IOException {
        this.out.write(33);
        this.out.write(255);
        this.out.write(11);
        this.writeString("NETSCAPE2.0");
        this.out.write(3);
        this.out.write(1);
        this.writeShort(this.repeat);
        this.out.write(0);
    }

    protected void writePalette() throws IOException {
        this.out.write(this.colorTab, 0, this.colorTab.length);
        int n = 768 - this.colorTab.length;
        for (int i = 0; i < n; ++i) {
            this.out.write(0);
        }
    }

    protected void writePixels() throws IOException {
        LZWEncoder encoder = new LZWEncoder(this.width, this.height, this.indexedPixels, this.colorDepth);
        encoder.encode(this.out);
    }

    protected void writeShort(int value) throws IOException {
        this.out.write(value & 0xFF);
        this.out.write(value >> 8 & 0xFF);
    }

    protected void writeString(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.out.write((byte)s.charAt(i));
        }
    }
}

