/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class JavadocArgumentExpression
extends Expression {
    public char[] token;
    public Argument argument;

    public JavadocArgumentExpression(char[] name, int startPos, int endPos, TypeReference typeRef) {
        this.token = name;
        this.sourceStart = startPos;
        this.sourceEnd = endPos;
        long pos = ((long)startPos << 32) + (long)endPos;
        this.argument = new Argument(name, pos, typeRef, 0);
        this.bits |= 0x8000;
    }

    private TypeBinding internalResolveType(Scope scope) {
        TypeReference typeRef;
        this.constant = NotAConstant;
        if (this.resolvedType != null) {
            return this.resolvedType.isValidBinding() ? this.resolvedType : null;
        }
        if (this.argument != null && (typeRef = this.argument.type) != null) {
            typeRef.resolvedType = this.resolvedType = typeRef.getTypeBinding(scope);
            if (!this.resolvedType.isValidBinding()) {
                scope.problemReporter().javadocInvalidType(typeRef, this.resolvedType, scope.getDeclarationModifiers());
                return null;
            }
            if (this.isTypeUseDeprecated(this.resolvedType, scope)) {
                scope.problemReporter().javadocDeprecatedType(this.resolvedType, typeRef, scope.getDeclarationModifiers());
                return null;
            }
            this.resolvedType = scope.environment().convertToRawType(this.resolvedType);
            return this.resolvedType;
        }
        return null;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.argument == null) {
            if (this.token != null) {
                output.append(this.token);
            }
        } else {
            this.argument.print(indent, output);
        }
        return output;
    }

    public void resolve(BlockScope scope) {
        if (this.argument != null) {
            this.argument.resolve(scope);
        }
    }

    public TypeBinding resolveType(BlockScope scope) {
        return this.internalResolveType(scope);
    }

    public TypeBinding resolveType(ClassScope scope) {
        return this.internalResolveType(scope);
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope) && this.argument != null) {
            this.argument.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }
}

