/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;

public class NestedTypeBinding
extends SourceTypeBinding {
    public SourceTypeBinding enclosingType;
    public SyntheticArgumentBinding[] enclosingInstances;
    public SyntheticArgumentBinding[] outerLocalVariables;
    public int enclosingInstancesSlotSize;
    public int outerLocalVariablesSlotSize;

    public NestedTypeBinding(char[][] typeName, ClassScope scope, SourceTypeBinding enclosingType) {
        super(typeName, enclosingType.fPackage, scope);
        this.tagBits |= 4L;
        this.enclosingType = enclosingType;
    }

    public SyntheticArgumentBinding addSyntheticArgument(LocalVariableBinding actualOuterLocalVariable) {
        SyntheticArgumentBinding synthLocal = null;
        if (this.outerLocalVariables == null) {
            synthLocal = new SyntheticArgumentBinding(actualOuterLocalVariable);
            this.outerLocalVariables = new SyntheticArgumentBinding[]{synthLocal};
        } else {
            int size;
            int newArgIndex = size = this.outerLocalVariables.length;
            int i = size;
            while (--i >= 0) {
                if (this.outerLocalVariables[i].actualOuterLocalVariable == actualOuterLocalVariable) {
                    return this.outerLocalVariables[i];
                }
                if (this.outerLocalVariables[i].id <= actualOuterLocalVariable.id) continue;
                newArgIndex = i;
            }
            SyntheticArgumentBinding[] synthLocals = new SyntheticArgumentBinding[size + 1];
            System.arraycopy(this.outerLocalVariables, 0, synthLocals, 0, newArgIndex);
            synthLocals[newArgIndex] = synthLocal = new SyntheticArgumentBinding(actualOuterLocalVariable);
            System.arraycopy(this.outerLocalVariables, newArgIndex, synthLocals, newArgIndex + 1, size - newArgIndex);
            this.outerLocalVariables = synthLocals;
        }
        if (this.scope.referenceCompilationUnit().isPropagatingInnerClassEmulation) {
            this.updateInnerEmulationDependents();
        }
        return synthLocal;
    }

    public SyntheticArgumentBinding addSyntheticArgument(ReferenceBinding targetEnclosingType) {
        SyntheticArgumentBinding synthLocal = null;
        if (this.enclosingInstances == null) {
            synthLocal = new SyntheticArgumentBinding(targetEnclosingType);
            this.enclosingInstances = new SyntheticArgumentBinding[]{synthLocal};
        } else {
            int size;
            int newArgIndex = size = this.enclosingInstances.length;
            int i = size;
            while (--i >= 0) {
                if (this.enclosingInstances[i].type == targetEnclosingType) {
                    return this.enclosingInstances[i];
                }
                if (this.enclosingType() != targetEnclosingType) continue;
                newArgIndex = 0;
            }
            SyntheticArgumentBinding[] newInstances = new SyntheticArgumentBinding[size + 1];
            System.arraycopy(this.enclosingInstances, 0, newInstances, newArgIndex == 0 ? 1 : 0, size);
            newInstances[newArgIndex] = synthLocal = new SyntheticArgumentBinding(targetEnclosingType);
            this.enclosingInstances = newInstances;
        }
        if (this.scope.referenceCompilationUnit().isPropagatingInnerClassEmulation) {
            this.updateInnerEmulationDependents();
        }
        return synthLocal;
    }

    public SyntheticArgumentBinding addSyntheticArgumentAndField(LocalVariableBinding actualOuterLocalVariable) {
        SyntheticArgumentBinding synthLocal = this.addSyntheticArgument(actualOuterLocalVariable);
        if (synthLocal == null) {
            return null;
        }
        if (synthLocal.matchingField == null) {
            synthLocal.matchingField = this.addSyntheticFieldForInnerclass(actualOuterLocalVariable);
        }
        return synthLocal;
    }

    public SyntheticArgumentBinding addSyntheticArgumentAndField(ReferenceBinding targetEnclosingType) {
        SyntheticArgumentBinding synthLocal = this.addSyntheticArgument(targetEnclosingType);
        if (synthLocal == null) {
            return null;
        }
        if (synthLocal.matchingField == null) {
            synthLocal.matchingField = this.addSyntheticFieldForInnerclass(targetEnclosingType);
        }
        return synthLocal;
    }

    public final void computeSyntheticArgumentSlotSizes() {
        int slotSize = 0;
        int enclosingInstancesCount = this.enclosingInstances == null ? 0 : this.enclosingInstances.length;
        int i = 0;
        while (i < enclosingInstancesCount) {
            SyntheticArgumentBinding argument = this.enclosingInstances[i];
            argument.resolvedPosition = slotSize + 1;
            if (slotSize + 1 > 255) {
                this.scope.problemReporter().noMoreAvailableSpaceForArgument(argument, this.scope.referenceType());
            }
            slotSize = argument.type == LongBinding || argument.type == DoubleBinding ? (slotSize += 2) : ++slotSize;
            ++i;
        }
        this.enclosingInstancesSlotSize = slotSize;
        slotSize = 0;
        int outerLocalsCount = this.outerLocalVariables == null ? 0 : this.outerLocalVariables.length;
        int i2 = 0;
        while (i2 < outerLocalsCount) {
            SyntheticArgumentBinding argument = this.outerLocalVariables[i2];
            slotSize = argument.type == LongBinding || argument.type == DoubleBinding ? (slotSize += 2) : ++slotSize;
            ++i2;
        }
        this.outerLocalVariablesSlotSize = slotSize;
    }

    public ReferenceBinding enclosingType() {
        return this.enclosingType;
    }

    public SyntheticArgumentBinding getSyntheticArgument(LocalVariableBinding actualOuterLocalVariable) {
        if (this.outerLocalVariables == null) {
            return null;
        }
        int i = this.outerLocalVariables.length;
        while (--i >= 0) {
            if (this.outerLocalVariables[i].actualOuterLocalVariable != actualOuterLocalVariable) continue;
            return this.outerLocalVariables[i];
        }
        return null;
    }

    public SyntheticArgumentBinding[] syntheticEnclosingInstances() {
        return this.enclosingInstances;
    }

    public ReferenceBinding[] syntheticEnclosingInstanceTypes() {
        if (this.enclosingInstances == null) {
            return null;
        }
        int length = this.enclosingInstances.length;
        ReferenceBinding[] types = new ReferenceBinding[length];
        int i = 0;
        while (i < length) {
            types[i] = (ReferenceBinding)this.enclosingInstances[i].type;
            ++i;
        }
        return types;
    }

    public SyntheticArgumentBinding[] syntheticOuterLocalVariables() {
        return this.outerLocalVariables;
    }

    public void updateInnerEmulationDependents() {
    }

    public SyntheticArgumentBinding getSyntheticArgument(ReferenceBinding targetEnclosingType, boolean onlyExactMatch) {
        if (this.enclosingInstances == null) {
            return null;
        }
        int i = this.enclosingInstances.length;
        while (--i >= 0) {
            if (this.enclosingInstances[i].type != targetEnclosingType || this.enclosingInstances[i].actualOuterLocalVariable != null) continue;
            return this.enclosingInstances[i];
        }
        if (!onlyExactMatch) {
            i = this.enclosingInstances.length;
            while (--i >= 0) {
                if (this.enclosingInstances[i].actualOuterLocalVariable != null || ((ReferenceBinding)this.enclosingInstances[i].type).findSuperTypeWithSameErasure(targetEnclosingType) == null) continue;
                return this.enclosingInstances[i];
            }
        }
        return null;
    }
}

