/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.action;

import de.intarsys.pdf.app.action.ActionException;
import de.intarsys.pdf.app.action.ActionHandlerRegistry;
import de.intarsys.pdf.app.action.ActionTools;
import de.intarsys.pdf.app.action.IActionHandler;
import de.intarsys.pdf.app.action.IActionHandlerRegistry;
import de.intarsys.pdf.app.action.IActionProcessor;
import de.intarsys.pdf.app.action.PACKAGE;
import de.intarsys.pdf.app.action.TriggerEvent;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAction;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StandardActionProcessor
implements IActionProcessor {
    private static Logger Log = PACKAGE.Log;
    private IActionHandlerRegistry factory = ActionHandlerRegistry.get();

    protected IActionHandlerRegistry getFactory() {
        return this.factory;
    }

    protected void handleException(ActionException e) {
        Log.logp(Level.WARNING, "", "", "PDF action processing error", e);
    }

    protected void processAction(TriggerEvent event, COSName actionType, COSObject actionDefinition) {
        COSDocument doc = actionDefinition.getDoc();
        if (doc != null && !ActionTools.isEnabled(doc, actionType)) {
            return;
        }
        IActionHandler handler = this.getFactory().lookupActionHandler(actionType);
        if (handler != null) {
            try {
                handler.process(event, actionDefinition);
            }
            catch (ActionException e) {
                this.handleException(e);
            }
        }
    }

    public void process(TriggerEvent event, COSName actionType, COSObject actionDefinition) {
        COSDictionary defDict;
        PDAction action;
        List next;
        this.processAction(event, actionType, actionDefinition);
        if (actionDefinition instanceof COSDictionary && (next = (action = (PDAction)PDAction.META.createFromCos(defDict = (COSDictionary)actionDefinition)).getNext()) != null) {
            for (PDAction child : next) {
                this.process(event, child.cosGetActionType(), child.cosGetObject());
            }
        }
        event.setExecuted(true);
    }
}

