/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDMarkupAnnotation;

public class PDLineAnnotation
extends PDMarkupAnnotation {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());

    public PDLineAnnotation(COSObject object) {
        super(object);
    }

    protected COSName cosGetExpectedSubtype() {
        return PDMarkupAnnotation.CN_Subtype_Line;
    }

    public float getMinHeight() {
        float width = this.getBorderStyleWidth();
        return width;
    }

    public float getMinWidth() {
        float width = this.getBorderStyleWidth();
        return width;
    }

    protected void updateStateRectangle(CDSRectangle oldRectangle, CDSRectangle newRectangle) {
        COSArray line = this.cosGetField(PDMarkupAnnotation.DK_L).asArray();
        if (line == null) {
            return;
        }
        double oldX = oldRectangle.getLowerLeftX();
        double oldY = oldRectangle.getLowerLeftY();
        double oldWidth = oldRectangle.getWidth();
        double oldHeight = oldRectangle.getHeight();
        double dX = (double)newRectangle.getLowerLeftX() - oldX;
        double dY = (double)newRectangle.getLowerLeftY() - oldY;
        double fX = (double)newRectangle.getWidth() / oldWidth;
        double fY = (double)newRectangle.getHeight() / oldHeight;
        COSArray newLine = COSArray.create();
        this.cosSetField(PDMarkupAnnotation.DK_L, newLine);
        COSNumber cosX = (COSNumber)line.get(0);
        COSNumber cosY = (COSNumber)line.get(1);
        float x = cosX.floatValue();
        float y = cosY.floatValue();
        newLine.add(COSFixed.create((float)(((double)x - oldX) * fX + oldX + dX)));
        newLine.add(COSFixed.create((float)(((double)y - oldY) * fY + oldY + dY)));
        cosX = (COSNumber)line.get(2);
        cosY = (COSNumber)line.get(3);
        x = cosX.floatValue();
        y = cosY.floatValue();
        newLine.add(COSFixed.create((float)(((double)x - oldX) * fX + oldX + dX)));
        newLine.add(COSFixed.create((float)(((double)y - oldY) * fY + oldY + dY)));
    }

    public static class MetaClass
    extends PDMarkupAnnotation.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDLineAnnotation(object);
        }
    }
}

