/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.core.io.PlaceholderFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzipUtils {
    public static final String EXTENSION = ".gz";

    public static String decompress(File archiveFile, int buffer) {
        return GzipUtils.decompress(archiveFile, buffer, (File)new PlaceholderFile(archiveFile.getAbsolutePath().replaceAll("\\.gz$", "")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MixedCopyright(copyright="1994-2009 Sun Microsystems, Inc.", author="Qusay H. Mahmoud", license=License.PROPRIETARY, url="http://java.sun.com/developer/technicalArticles/Programming/compression/", note="http://www.oracle.com/us/legal/terms/index.html section 4 'Use of Community Services'")
    public static String decompress(File archiveFile, int buffer, File outputFile) {
        GZIPInputStream in = null;
        FilterOutputStream out = null;
        String result = null;
        try {
            int len;
            if (outputFile.exists()) {
                System.err.println("WARNING: overwriting '" + outputFile + "'!");
            }
            byte[] buf = new byte[buffer];
            in = new GZIPInputStream(new BufferedInputStream(new FileInputStream(archiveFile.getAbsolutePath())));
            out = new BufferedOutputStream(new FileOutputStream(outputFile), buffer);
            while ((len = in.read(buf)) > 0) {
                ((BufferedOutputStream)out).write(buf, 0, len);
            }
            in.close();
            in = null;
            out.close();
            out = null;
        }
        catch (Exception e) {
            String msg = "Failed to decompress '" + archiveFile + "': ";
            System.err.println(msg);
            e.printStackTrace();
            result = msg + e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    public static String compress(File inputFile, int buffer) {
        return GzipUtils.compress(inputFile, buffer, (File)new PlaceholderFile(inputFile.getAbsolutePath() + EXTENSION));
    }

    public static String compress(File inputFile, int buffer, File outputFile) {
        return GzipUtils.compress(inputFile, buffer, outputFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MixedCopyright(copyright="2003-2009 www.devshed.com", author="Kulvir Singh Bhogal and Javid Jamae", url="http://www.devshed.com/c/a/Java/GZIPping-with-Java/2/")
    public static String compress(File inputFile, int buffer, File outputFile, boolean removeInput) {
        BufferedInputStream in = null;
        DeflaterOutputStream out = null;
        String result = null;
        try {
            int len;
            if (outputFile.exists()) {
                System.err.println("WARNING: overwriting '" + outputFile + "'!");
            }
            byte[] buf = new byte[buffer];
            out = new GZIPOutputStream(new FileOutputStream(outputFile));
            in = new BufferedInputStream(new FileInputStream(inputFile.getAbsolutePath()));
            while ((len = in.read(buf)) > 0) {
                ((GZIPOutputStream)out).write(buf, 0, len);
            }
            in.close();
            in = null;
            out.close();
            out = null;
            if (removeInput && !inputFile.delete()) {
                result = "Failed to delete input file '" + inputFile + "' after successful compression!";
            }
        }
        catch (Exception e) {
            String msg = "Failed to compress '" + inputFile + "': ";
            System.err.println(msg);
            e.printStackTrace();
            result = msg + e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }
}

