/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPattern;
import com.itextpdf.text.pdf.PdfSpotColor;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;

public final class PdfPatternPainter
extends PdfTemplate {
    float xstep;
    float ystep;
    boolean stencil = false;
    BaseColor defaultColor;

    private PdfPatternPainter() {
        this.type = 3;
    }

    PdfPatternPainter(PdfWriter wr) {
        super(wr);
        this.type = 3;
    }

    PdfPatternPainter(PdfWriter wr, BaseColor defaultColor) {
        this(wr);
        this.stencil = true;
        this.defaultColor = defaultColor == null ? BaseColor.GRAY : defaultColor;
    }

    public void setXStep(float xstep) {
        this.xstep = xstep;
    }

    public void setYStep(float ystep) {
        this.ystep = ystep;
    }

    public float getXStep() {
        return this.xstep;
    }

    public float getYStep() {
        return this.ystep;
    }

    public boolean isStencil() {
        return this.stencil;
    }

    public void setPatternMatrix(float a, float b, float c, float d, float e, float f) {
        this.setMatrix(a, b, c, d, e, f);
    }

    PdfPattern getPattern() {
        return new PdfPattern(this);
    }

    PdfPattern getPattern(int compressionLevel) {
        return new PdfPattern(this, compressionLevel);
    }

    public PdfContentByte getDuplicate() {
        PdfPatternPainter tpl = new PdfPatternPainter();
        tpl.writer = this.writer;
        tpl.pdf = this.pdf;
        tpl.thisReference = this.thisReference;
        tpl.pageResources = this.pageResources;
        tpl.bBox = new Rectangle(this.bBox);
        tpl.xstep = this.xstep;
        tpl.ystep = this.ystep;
        tpl.matrix = this.matrix;
        tpl.stencil = this.stencil;
        tpl.defaultColor = this.defaultColor;
        return tpl;
    }

    public BaseColor getDefaultColor() {
        return this.defaultColor;
    }

    public void setGrayFill(float gray) {
        this.checkNoColor();
        super.setGrayFill(gray);
    }

    public void resetGrayFill() {
        this.checkNoColor();
        super.resetGrayFill();
    }

    public void setGrayStroke(float gray) {
        this.checkNoColor();
        super.setGrayStroke(gray);
    }

    public void resetGrayStroke() {
        this.checkNoColor();
        super.resetGrayStroke();
    }

    public void setRGBColorFillF(float red, float green, float blue) {
        this.checkNoColor();
        super.setRGBColorFillF(red, green, blue);
    }

    public void resetRGBColorFill() {
        this.checkNoColor();
        super.resetRGBColorFill();
    }

    public void setRGBColorStrokeF(float red, float green, float blue) {
        this.checkNoColor();
        super.setRGBColorStrokeF(red, green, blue);
    }

    public void resetRGBColorStroke() {
        this.checkNoColor();
        super.resetRGBColorStroke();
    }

    public void setCMYKColorFillF(float cyan, float magenta, float yellow, float black) {
        this.checkNoColor();
        super.setCMYKColorFillF(cyan, magenta, yellow, black);
    }

    public void resetCMYKColorFill() {
        this.checkNoColor();
        super.resetCMYKColorFill();
    }

    public void setCMYKColorStrokeF(float cyan, float magenta, float yellow, float black) {
        this.checkNoColor();
        super.setCMYKColorStrokeF(cyan, magenta, yellow, black);
    }

    public void resetCMYKColorStroke() {
        this.checkNoColor();
        super.resetCMYKColorStroke();
    }

    public void addImage(Image image, float a, float b, float c, float d, float e, float f) throws DocumentException {
        if (this.stencil && !image.isMask()) {
            this.checkNoColor();
        }
        super.addImage(image, a, b, c, d, e, f);
    }

    public void setCMYKColorFill(int cyan, int magenta, int yellow, int black) {
        this.checkNoColor();
        super.setCMYKColorFill(cyan, magenta, yellow, black);
    }

    public void setCMYKColorStroke(int cyan, int magenta, int yellow, int black) {
        this.checkNoColor();
        super.setCMYKColorStroke(cyan, magenta, yellow, black);
    }

    public void setRGBColorFill(int red, int green, int blue) {
        this.checkNoColor();
        super.setRGBColorFill(red, green, blue);
    }

    public void setRGBColorStroke(int red, int green, int blue) {
        this.checkNoColor();
        super.setRGBColorStroke(red, green, blue);
    }

    public void setColorStroke(BaseColor color) {
        this.checkNoColor();
        super.setColorStroke(color);
    }

    public void setColorFill(BaseColor color) {
        this.checkNoColor();
        super.setColorFill(color);
    }

    public void setColorFill(PdfSpotColor sp, float tint) {
        this.checkNoColor();
        super.setColorFill(sp, tint);
    }

    public void setColorStroke(PdfSpotColor sp, float tint) {
        this.checkNoColor();
        super.setColorStroke(sp, tint);
    }

    public void setPatternFill(PdfPatternPainter p) {
        this.checkNoColor();
        super.setPatternFill(p);
    }

    public void setPatternFill(PdfPatternPainter p, BaseColor color, float tint) {
        this.checkNoColor();
        super.setPatternFill(p, color, tint);
    }

    public void setPatternStroke(PdfPatternPainter p, BaseColor color, float tint) {
        this.checkNoColor();
        super.setPatternStroke(p, color, tint);
    }

    public void setPatternStroke(PdfPatternPainter p) {
        this.checkNoColor();
        super.setPatternStroke(p);
    }

    void checkNoColor() {
        if (this.stencil) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("colors.are.not.allowed.in.uncolored.tile.patterns", new Object[0]));
        }
    }
}

