/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.lang.reflect.Method;
import org.jopendocument.util.ExceptionUtils;

public final class CopyUtils {
    public static final <E> E copy(E e) {
        if (e == null) {
            return null;
        }
        if (e instanceof Cloneable) {
            Method method;
            try {
                method = e.getClass().getMethod("clone", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw ExceptionUtils.createExn(IllegalStateException.class, "Cloneable w/o clone()", noSuchMethodException);
            }
            try {
                return (E)method.invoke(e, new Object[0]);
            }
            catch (Exception exception) {
                throw ExceptionUtils.createExn(IllegalStateException.class, "clone() failed", exception);
            }
        }
        try {
            return (E)e.getClass().getConstructor(e.getClass()).newInstance(e);
        }
        catch (Exception exception) {
            throw ExceptionUtils.createExn(IllegalStateException.class, "Copy constructor failed", exception);
        }
    }
}

