/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util.cache;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jopendocument.util.cache.ICache;

public abstract class CacheWatcher<K, D> {
    private final ICache<K, ?, D> c;
    private final Set<K> keys;
    private final D data;

    protected CacheWatcher(ICache<K, ?, D> iCache, D d) {
        this.c = iCache;
        this.keys = new HashSet<K>();
        this.data = d;
    }

    public final D getData() {
        return this.data;
    }

    synchronized boolean isEmpty() {
        return this.keys.isEmpty();
    }

    final synchronized void add(K k) {
        this.keys.add(k);
    }

    final synchronized void remove(K k) {
        this.keys.remove(k);
    }

    public final synchronized void die() {
        this.dying();
        this.clearCache();
    }

    protected void dying() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clearCache() {
        ICache<K, ?, D> iCache = this.c;
        synchronized (iCache) {
            CacheWatcher cacheWatcher = this;
            synchronized (cacheWatcher) {
                Iterator<K> iterator = this.keys.iterator();
                while (iterator.hasNext()) {
                    K k = iterator.next();
                    iterator.remove();
                    this.c.clear(k);
                }
            }
        }
    }
}

