/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.io.AbstractSpreadSheetWriter;
import adams.core.io.SpreadSheet;
import adams.env.Environment;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelSpreadSheetWriter
extends AbstractSpreadSheetWriter {
    private static final long serialVersionUID = -3549185519778801930L;
    public static String FILE_EXTENSION = ".xls";
    public static String FILE_EXTENSION_OOXML = ".xlsx";
    protected boolean m_WriteOOXML;

    public String globalInfo() {
        return "Writes MS Excel files.";
    }

    public String getFormatDescription() {
        return "MS Excel spreadsheets";
    }

    public String[] getFormatExtensions() {
        return new String[]{"xls", "xlsx"};
    }

    protected boolean getUseOutputStream() {
        return true;
    }

    public void setWriteOOXML(boolean value) {
        this.m_WriteOOXML = value;
    }

    public boolean getWriteOOXML() {
        return this.m_WriteOOXML;
    }

    public boolean write(SpreadSheet content, String filename) {
        this.setWriteOOXML(filename.endsWith(FILE_EXTENSION_OOXML));
        return super.write(content, filename);
    }

    protected boolean doWrite(SpreadSheet content, OutputStream out) {
        boolean result = true;
        try {
            Cell cell;
            int i;
            Object workbook = this.getWriteOOXML() ? new XSSFWorkbook() : new HSSFWorkbook();
            Sheet sheet = workbook.createSheet();
            workbook.setSheetName(0, Environment.getInstance().getProject());
            Row row = sheet.createRow(0);
            for (i = 0; i < content.getColumnCount(); ++i) {
                cell = row.createCell(i);
                cell.setCellValue(content.getHeaderRow().getCell(i).getContent());
            }
            for (int n = 0; n < content.getRowCount(); ++n) {
                row = sheet.createRow(n + 1);
                SpreadSheet.Row spRow = content.getRow(n);
                for (i = 0; i < content.getColumnCount(); ++i) {
                    cell = row.createCell(i);
                    SpreadSheet.Cell spCell = spRow.getCell(i);
                    if (spCell.isMissing()) {
                        if (this.m_MissingValue.length() > 0) {
                            cell.setCellValue(this.m_MissingValue);
                            continue;
                        }
                        cell.setCellType(3);
                        continue;
                    }
                    if (spCell.isNumeric()) {
                        cell.setCellValue(Double.parseDouble(spCell.getContent()));
                        continue;
                    }
                    cell.setCellValue(spCell.getContent());
                }
            }
            workbook.write(out);
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }
}

