/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.scripting.Jython;
import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractScriptActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.AdditionalOptionsHandler;
import adams.flow.core.AdditionalOptionsHandlerUtils;
import java.io.File;

public abstract class AbstractJythonActor
extends AbstractScriptActor {
    private static final long serialVersionUID = -2562159780167388413L;
    protected transient AbstractActor m_ActorObject;

    public String scriptOptionsTipText() {
        return "The options for the Jython script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'self.getAdditionalOptions().getXYZ(\"key\")' method in the Jython actor.";
    }

    protected String loadScriptObject() {
        String result = null;
        try {
            this.m_ScriptObject = null;
            if (this.m_ScriptFile.isFile()) {
                this.m_ScriptObject = (AbstractActor)Jython.newInstance((File)this.m_ScriptFile, AbstractActor.class);
                if (this.m_ScriptObject != null) {
                    if (!AdditionalOptionsHandlerUtils.setOptions((Object)this.m_ScriptObject, (String)this.m_ScriptOptions)) {
                        result = "Does not implement '" + AdditionalOptionsHandler.class.getName() + "': " + this.m_ScriptFile;
                    }
                } else {
                    result = "Failed to instantiate script '" + this.m_ScriptFile + "'!";
                }
            } else {
                result = "No script provided!";
            }
        }
        catch (Exception e) {
            this.m_ScriptObject = null;
            this.getSystemErr().printStackTrace((Throwable)e);
            result = "Failed to initialize Jython script '" + this.m_ScriptFile + "': " + e.toString();
        }
        return result;
    }

    protected String checkScriptObject() {
        String result = null;
        AbstractActor script = (AbstractActor)this.m_ScriptObject;
        if (ActorUtils.isStandalone((AbstractActor)this) && !ActorUtils.isStandalone((AbstractActor)script)) {
            result = "Script object is not a singleton!";
        } else if (ActorUtils.isSource((AbstractActor)this) && !ActorUtils.isSource((AbstractActor)script)) {
            result = "Script object is not a source!";
        } else if (ActorUtils.isTransformer((AbstractActor)this) && !ActorUtils.isTransformer((AbstractActor)script)) {
            result = "Script object is not a transformer!";
        } else if (ActorUtils.isSink((AbstractActor)this) && !ActorUtils.isSink((AbstractActor)script)) {
            result = "Script object is not a sink!";
        }
        return result;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_ActorObject = (AbstractActor)this.m_ScriptObject;
            result = this.m_ActorObject.setUp();
        }
        return result;
    }

    public void wrapUp() {
        super.wrapUp();
        if (this.m_ActorObject != null) {
            this.m_ActorObject.destroy();
        }
        this.m_ActorObject = null;
    }
}

