/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.entrywise.creators;

import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.MathUtil;

public class Rand
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 1482175899706574542L;
    private double min = 0.0;
    private double max = 1.0;

    public Rand(Matrix matrix) {
        super(matrix);
    }

    public Rand(Matrix matrix, double min, double max) {
        super(matrix);
        this.min = min;
        this.max = max;
    }

    public double getDouble(long ... coordinates) {
        return MathUtil.nextUniform(this.min, this.max);
    }

    public static Matrix calc(long ... size) throws MatrixException {
        return Rand.calc(ValueType.DOUBLE, size);
    }

    public static Matrix calc(Matrix source, double min, double max) throws MatrixException {
        Matrix ret = Matrix.factory.zeros(source.getSize());
        for (long[] c : source.allCoordinates()) {
            ret.setAsDouble(MathUtil.nextUniform(min, max), c);
        }
        return ret;
    }

    public static Matrix calc(ValueType valueType, long ... size) throws MatrixException {
        Matrix ret = MatrixFactory.zeros(valueType, size);
        for (long[] c : ret.allCoordinates()) {
            ret.setAsDouble(MathUtil.nextUniform(0.0, 1.0), c);
        }
        return ret;
    }
}

