/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.io;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import org.ujmp.core.util.io.FileSelector;

public abstract class ExportJPEG {
    private static final Logger logger = Logger.getLogger(ExportJPEG.class.getName());

    public static final File selectFile() {
        return ExportJPEG.selectFile(null);
    }

    public static final File selectFile(Component c) {
        return FileSelector.selectFile(c, "JPEG Files", ".jpg");
    }

    public static final void save(String filename, Component c) {
        ExportJPEG.save(new File(filename), c, c.getWidth());
    }

    public static final void save(String filename, Component c, int width) {
        ExportJPEG.save(new File(filename), c, width);
    }

    public static final void save(File file, Component c) {
        ExportJPEG.save(file, c, c.getWidth());
    }

    public static final void save(File file, Component c, int width) {
        if (file == null) {
            logger.log(Level.WARNING, "no file selected");
            return;
        }
        if (c == null) {
            logger.log(Level.WARNING, "no component provided");
            return;
        }
        double factor = width / c.getWidth();
        BufferedImage myImage = new BufferedImage((int)((double)c.getWidth() * factor), (int)((double)c.getHeight() * factor), 1);
        Graphics2D g2 = myImage.createGraphics();
        g2.scale(factor, factor);
        c.paint(g2);
        try {
            ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(file);
            writer.setOutput(ios);
            JPEGImageWriteParam iwparam = new JPEGImageWriteParam(Locale.getDefault());
            iwparam.setCompressionMode(2);
            iwparam.setCompressionQuality(1.0f);
            writer.write(null, new IIOImage(myImage, null, null), iwparam);
            ios.flush();
            writer.dispose();
            ios.close();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "could not save jpg image", e);
        }
    }
}

