/*
 * Decompiled with CFR 0.152.
 */
package adams.core.management;

import adams.core.io.FileUtils;
import adams.core.management.Java;
import adams.core.management.ProcessUtils;
import java.io.File;

public class JConsole
extends Java {
    public static final String EXECUTABLE = "jconsole";

    public static boolean isAvailable() {
        boolean result = JConsole.isJDK();
        if (result) {
            result = new File(JConsole.getBinDir() + File.separator + FileUtils.fixExecutable(EXECUTABLE)).exists();
        }
        return result;
    }

    public static String getExecutablePath() {
        String result = JConsole.getBinDir() + File.separator + FileUtils.fixExecutable(EXECUTABLE);
        result = FileUtils.quoteExecutable(result);
        return result;
    }

    public static String getDefaultOptions() {
        return "-J-Xmx512m";
    }

    public static String execute(long pid) {
        return JConsole.execute(JConsole.getExecutablePath(), pid);
    }

    public static String execute(String options, long pid) {
        return JConsole.execute(JConsole.getExecutablePath(), options, pid);
    }

    public static String execute(String executable, String options, long pid) {
        if (pid == -999L) {
            pid = ProcessUtils.getVirtualMachinePID();
        }
        options = options + " " + pid;
        return JConsole.execute(executable, options);
    }
}

