/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.Variables;
import adams.flow.core.ControlActor;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import adams.parser.BooleanExpression;
import adams.parser.GrammarSupplier;
import java.util.HashMap;

public class Sinkhole
extends AbstractTransformer
implements ControlActor,
GrammarSupplier {
    private static final long serialVersionUID = -2318544907798411076L;
    protected String m_Expression;

    @Override
    public String globalInfo() {
        return "Blocks for propagation of tokens if the expression evaluates to 'true'.\nIn case of integer or double tokens that arrive at the input, these can be accessed in the expression via 'X'.\n\nThe following grammar is used for evaluating the boolean expressions:\n\n" + this.getGrammar();
    }

    @Override
    public String getGrammar() {
        return new BooleanExpression().getGrammar();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expression", "expression", "false");
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("expression");
        if (variable != null) {
            return variable;
        }
        if (this.m_Expression != null && this.m_Expression.length() > 0) {
            return this.m_Expression;
        }
        return null;
    }

    public void setExpression(String value) {
        if (Variables.isPlaceholder(value)) {
            value = "(" + value + ")";
        }
        this.m_Expression = value;
        this.reset();
    }

    public String getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The expression to evaluate - only as long as it evaluates to 'true' the loop actors get executed; expressions that consists solely of a variable (eg '@{blah}') get automatically wrapped in parentheses, since the expression string gets interpreted as attached variable instead.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null && (this.m_Expression == null || this.m_Expression.length() == 0)) {
            result = "No expression provided!";
        }
        return result;
    }

    @Override
    protected String doExecute() {
        boolean forward;
        String result = null;
        String exp = this.getVariables().expand(this.m_Expression);
        HashMap<String, Double> symbols = new HashMap<String, Double>();
        Object value = this.m_InputToken.getPayload();
        if (value instanceof Integer) {
            symbols.put("X", ((Integer)value).doubleValue());
        } else if (value instanceof Double) {
            symbols.put("X", (Double)value);
        }
        try {
            boolean bl = forward = !BooleanExpression.evaluate(exp, symbols);
            if (this.getDebugLevel() >= 2) {
                this.debug("exp: " + this.m_Expression + "\n" + "  --> " + exp + "\n" + "  = " + !forward + " (" + (forward ? "" : "don't ") + "forward)", 2);
            }
        }
        catch (Exception e) {
            forward = true;
            String msg = "Failed to evaluate expression '" + this.m_Expression + "': ";
            result = msg + e;
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace(e);
        }
        this.m_OutputToken = forward ? this.m_InputToken : null;
        return result;
    }
}

