/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tab;

import adams.core.Properties;
import adams.env.Environment;
import adams.flow.core.AbstractActor;
import adams.gui.core.BaseTabbedPaneWithTabHiding;
import adams.gui.flow.tab.AbstractEditorTab;
import adams.gui.flow.tab.SelectionAwareEditorTab;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.Tree;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;

public class FlowTabManager
extends BaseTabbedPaneWithTabHiding {
    private static final long serialVersionUID = 3685631497946681192L;
    public static final String SESSION_FILE = "FlowTabManagerSession.props";
    public static final String MENUITEM_TABS = "Show tabs";
    public static final String SUFFIX_VISIBLE = ".Visible";
    protected static Properties m_Properties;
    protected Vector<AbstractEditorTab> m_TabList;

    @Override
    protected void initialize() {
        super.initialize();
        this.setCloseTabsWithMiddelMouseButton(false);
        String[] tabs = AbstractEditorTab.getTabs();
        this.m_TabList = new Vector();
        Properties props = FlowTabManager.getProperties();
        boolean update = false;
        for (String tabName : tabs) {
            AbstractEditorTab tab = AbstractEditorTab.forName(tabName);
            if (tab == null) continue;
            this.m_TabList.add(tab);
            String key = this.createPropertyKey(tab.getClass());
            if (props.hasKey(key)) continue;
            props.setBoolean(key, true);
            update = true;
        }
        Collections.sort(this.m_TabList);
        if (update) {
            this.updateProperties();
        }
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        for (int i = 0; i < this.m_TabList.size(); ++i) {
            AbstractEditorTab tab = this.m_TabList.get(i);
            this.addTab(tab.getTitle(), tab);
            if (this.isVisible(tab.getClass())) continue;
            this.hideTab(tab);
        }
    }

    public void notifyTabs(TreePath[] paths, AbstractActor[] actors) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!(this.getComponentAt(i) instanceof SelectionAwareEditorTab)) continue;
            ((SelectionAwareEditorTab)((Object)this.getComponentAt(i))).actorSelectionChanged(paths, actors);
        }
    }

    public void refresh(Tree tree) {
        if (tree == null) {
            return;
        }
        TreePath[] paths = tree.getSelectionPaths();
        AbstractActor[] actors = new AbstractActor[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            actors[i] = ((Node)paths[i].getLastPathComponent()).getActor();
        }
        this.notifyTabs(paths, actors);
    }

    public void addTabsSubmenu(JMenu menu) {
        final JMenu submenu = new JMenu(MENUITEM_TABS);
        submenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FlowTabManager.this.updateMenu(submenu);
            }
        });
        menu.add(submenu);
        JMenuItem menuitem = new JMenuItem("Enable all");
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowTabManager.this.setAllVisible(true);
            }
        });
        submenu.add(menuitem);
        menuitem = new JMenuItem("Disable all");
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowTabManager.this.setAllVisible(false);
            }
        });
        submenu.add(menuitem);
        boolean first = true;
        for (final AbstractEditorTab tab : this.m_TabList) {
            if (first) {
                first = false;
                submenu.addSeparator();
            }
            menuitem = new JCheckBoxMenuItem(tab.getTitle());
            menuitem.setSelected(this.isVisible(tab.getClass()));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FlowTabManager.this.setVisible(tab.getClass(), !FlowTabManager.this.isVisible(tab.getClass()));
                    if (FlowTabManager.this.isVisible(tab.getClass())) {
                        FlowTabManager.this.displayTab(tab);
                    } else {
                        FlowTabManager.this.hideTab(tab);
                    }
                }
            });
            submenu.add(menuitem);
        }
    }

    protected void updateMenu(JMenu menu) {
        block0: for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
            if (!(menu.getMenuComponent(i) instanceof JCheckBoxMenuItem)) continue;
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)menu.getMenuComponent(i);
            for (int n = 0; n < this.m_TabList.size(); ++n) {
                if (!item.getText().equals(this.m_TabList.get(n).getTitle())) continue;
                item.setSelected(this.isVisible(this.m_TabList.get(n).getClass()));
                continue block0;
            }
        }
    }

    protected String createPropertyKey(Class cls) {
        return cls.getName() + SUFFIX_VISIBLE;
    }

    public synchronized boolean isVisible(Class cls) {
        return FlowTabManager.getProperties().getBoolean(this.createPropertyKey(cls), true);
    }

    public synchronized void setVisible(Class cls, boolean value) {
        FlowTabManager.getProperties().setBoolean(this.createPropertyKey(cls), value);
        this.updateProperties();
    }

    public synchronized void setAllVisible(boolean value) {
        for (AbstractEditorTab tab : this.m_TabList) {
            FlowTabManager.getProperties().setBoolean(this.createPropertyKey(tab.getClass()), value);
            if (value) {
                this.displayTab(tab);
                continue;
            }
            this.hideTab(tab);
        }
        this.updateProperties();
    }

    protected synchronized boolean updateProperties() {
        String filename = Environment.getInstance().createPropertiesFilename(SESSION_FILE);
        return FlowTabManager.getProperties().save(filename);
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            try {
                m_Properties = Properties.read(SESSION_FILE);
            }
            catch (Exception e) {
                m_Properties = new Properties();
            }
        }
        return m_Properties;
    }
}

