/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import java.lang.reflect.Method;
import java.util.Hashtable;

public class GlobalInfoCache {
    public static final String METHOD_GLOBALINFO = "globalInfo";
    protected Hashtable<String, String> m_GlobalInfo = new Hashtable();
    protected Hashtable<String, Boolean> m_Available = new Hashtable();
    protected static GlobalInfoCache m_Singleton;

    private GlobalInfoCache() {
    }

    public synchronized boolean has(Class cls) {
        return this.has(cls.getName());
    }

    public synchronized boolean has(String clsname) {
        if (!this.m_Available.containsKey(clsname)) {
            String info;
            try {
                Class<?> cls = Class.forName(clsname);
                Method method = cls.getMethod(METHOD_GLOBALINFO, new Class[0]);
                Object obj = cls.newInstance();
                info = (String)method.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                info = null;
            }
            this.m_Available.put(clsname, info != null);
            if (info != null) {
                this.m_GlobalInfo.put(clsname, info);
            }
        }
        return this.m_Available.get(clsname);
    }

    public synchronized String get(Class cls) {
        return this.get(cls.getName());
    }

    public synchronized String get(String clsname) {
        if (this.has(clsname)) {
            return this.m_GlobalInfo.get(clsname);
        }
        return null;
    }

    public static synchronized GlobalInfoCache getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new GlobalInfoCache();
        }
        return m_Singleton;
    }
}

