/*
 * Decompiled with CFR 0.152.
 */
package weka.hadoop;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.swing.DefaultListModel;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.NLineInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instances;
import weka.core.Summarizable;
import weka.core.Utils;
import weka.core.converters.ArffLoader;
import weka.core.converters.ConverterUtils;
import weka.experiment.ClassifierSplitEvaluator;
import weka.experiment.CrossValidationResultProducer;
import weka.experiment.InstancesResultListener;
import weka.experiment.RegressionSplitEvaluator;
import weka.experiment.ResultListener;
import weka.experiment.SplitEvaluator;

public class HadoopExperiment
extends Configured
implements Tool {
    protected static final int RESULT_SIZE = 30;
    protected static final int Regression_RESULT_SIZE = 23;
    protected static final int NUM_IR_STATISTICS = 14;
    protected static final int NUM_WEIGHTED_IR_STATISTICS = 8;
    protected static final int NUM_UNWEIGHTED_IR_STATISTICS = 2;
    protected int m_NumFolds = 10;
    protected int m_Repetition = 10;
    protected int m_attID = -1;
    protected int m_IRclass = 0;
    protected CrossValidationResultProducer m_RP = new CrossValidationResultProducer();
    protected InstancesResultListener m_ResultListener = new InstancesResultListener();
    protected boolean m_predTargetColumn = false;
    protected Classifier m_Classifier;
    protected ClassifierSplitEvaluator m_SplitEvaluator = new ClassifierSplitEvaluator();
    protected RegressionSplitEvaluator m_SplitEvaluator2 = new RegressionSplitEvaluator();
    protected ArrayList<String> measures = new ArrayList();
    protected String[] m_AdditionalMeasures = null;
    protected String num = "";
    protected String uniqueFile = "";
    protected String uniqueFolder = "";
    protected int inputSize = 0;
    protected int folderCount = 0;
    public static HadoopExperiment m_Exp = new HadoopExperiment();

    public static Double getTimestamp() {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        double timestamp = (double)(now.get(1) * 10000 + (now.get(2) + 1) * 100 + now.get(5)) + (double)now.get(11) / 100.0 + (double)now.get(12) / 10000.0;
        return new Double(timestamp);
    }

    public int run(String[] args) throws Exception {
        Job job = new Job(this.getConf());
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        int argIndex = 0;
        while (args[argIndex].startsWith("-")) {
            argIndex += 2;
        }
        if (fs.isDirectory(new Path(args[++argIndex]))) {
            fs.delete(new Path(args[argIndex]), true);
        }
        job.setJarByClass(HadoopExperiment.class);
        job.setJobName("hadoopExperiment");
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setMapperClass(Map.class);
        job.setReducerClass(Reduce.class);
        if (HadoopExperiment.m_Exp.inputSize > 30) {
            job.setInputFormatClass(NLineInputFormat.class);
            job.getConfiguration().set("mapreduce.input.lineinputformat.linespermap", HadoopExperiment.m_Exp.num);
        } else {
            job.setInputFormatClass(TextInputFormat.class);
        }
        job.setOutputFormatClass(TextOutputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(args[argIndex - 1])});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[argIndex]));
        boolean success = job.waitForCompletion(true);
        return success ? 0 : 1;
    }

    public static void determineLinesPerMap(int number) {
        int current = 30;
        while (true) {
            if (number % current == 0) break;
            --current;
        }
        HadoopExperiment.m_Exp.num = new Integer(current).toString();
    }

    public static void main(String[] args) throws Exception {
        int folds;
        int run;
        if (args.length == 0) {
            System.out.println("\nUsage: weka.hadoop.HardiredHadoopExperiment\n\t   -jar  the jar file to execute\n\t   -libjars  all the class paths\n\t   -classifier <classifier incl. parameters>(can be supplied multiple times)\n\t   -dataset  datasets (can be supplied multiple times)\n\t   -runs <# of runs>\n\t   -folds <folds for CV>\n\t   -exptype <classification|regression>\n\t   -classindex <first|last|a number|default>\n\t   -confhome  path of hadoop configuration folder\n\t   -csv <post-process csv file>");
        }
        ArrayList<String> tempargs = new ArrayList<String>();
        boolean isClassification = false;
        String[] originalArgs = (String[])args.clone();
        String option = Utils.getOption((String)"exptype", (String[])args);
        if (option.length() == 0) {
            throw new IllegalArgumentException("No experiment type provided!");
        }
        if (option.equals("classification")) {
            isClassification = true;
        } else if (option.equals("regression")) {
            isClassification = false;
        } else {
            throw new IllegalArgumentException("Unknown experiment type '" + option + "'!");
        }
        boolean c = false;
        DefaultListModel<String> classifiers = new DefaultListModel<String>();
        do {
            if ((option = Utils.getOption((String)"classifier", (String[])args)).length() <= 0) continue;
            c = true;
            classifiers.addElement(option);
        } while (option.length() > 0);
        if (!c) {
            throw new IllegalArgumentException("No classifiers provided!");
        }
        option = Utils.getOption((String)"runs", (String[])args);
        HadoopExperiment.m_Exp.m_Repetition = run = Integer.parseInt(option);
        option = Utils.getOption((String)"folds", (String[])args);
        HadoopExperiment.m_Exp.m_NumFolds = folds = Integer.parseInt(option);
        String confFolder = option = Utils.getOption((String)"confHome", (String[])args);
        boolean data = false;
        DefaultListModel<File> model = new DefaultListModel<File>();
        do {
            if ((option = Utils.getOption((String)"dataset", (String[])args)).length() <= 0) continue;
            File file = new File(option);
            if (!file.exists()) {
                throw new IllegalArgumentException("File '" + option + "' does not exist!");
            }
            data = true;
            model.addElement(file);
        } while (option.length() > 0);
        if (!data) {
            throw new IllegalArgumentException("No data files provided!");
        }
        String index = Utils.getOption((String)"classindex", (String[])args);
        int argIndex = 0;
        while (args[argIndex].startsWith("-")) {
            argIndex += 2;
        }
        File fi = null;
        try {
            fi = File.createTempFile("input", ".tmp");
            fi.deleteOnExit();
            tempargs.add(originalArgs[0]);
            tempargs.add(originalArgs[1]);
            tempargs.add(fi.getName());
            HadoopExperiment.m_Exp.inputSize = classifiers.size() * run * model.size() * folds;
            HadoopExperiment.determineLinesPerMap(HadoopExperiment.m_Exp.inputSize);
            BufferedWriter output = new BufferedWriter(new FileWriter(fi));
            for (int datasets = 0; datasets < model.size(); ++datasets) {
                for (int repetition = 1; repetition <= run; ++repetition) {
                    for (int algorithm = 0; algorithm < classifiers.size(); ++algorithm) {
                        for (int fold = 0; fold < folds; ++fold) {
                            String msg = classifiers.getElementAt(algorithm).toString() + "," + repetition + "," + model.getElementAt(datasets).toString() + "," + fold + "," + index + "," + new Boolean(isClassification).toString() + "," + confFolder;
                            output.write(msg + "\n");
                        }
                    }
                }
            }
            output.flush();
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Configuration conf = new Configuration();
        conf.addResource(new Path(confFolder + "/core-site.xml"));
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.copyFromLocalFile(new Path(fi.getPath()), new Path(fi.getName()));
        File x = File.createTempFile("output", ".tmp");
        x.deleteOnExit();
        String foldername = x.getName().substring(0, x.getName().length() - 4);
        tempargs.add(foldername);
        String[] a = tempargs.toArray(new String[tempargs.size()]);
        int ret = ToolRunner.run((Tool)m_Exp, (String[])a);
        if (ret == 0) {
            String strLine;
            fi.delete();
            fs.delete(new Path(fi.getName()), false);
            ArrayList<String> title = new ArrayList<String>();
            File fii = File.createTempFile("temp", ".txt");
            fii.deleteOnExit();
            fs.copyToLocalFile(new Path(foldername + "/part-r-00000"), new Path(fii.getAbsolutePath()));
            BufferedReader bf = new BufferedReader(new FileReader(fii));
            String csvPath = option = Utils.getOption((String)"csv", (String[])args);
            if (option.length() == 0) {
                throw new IllegalArgumentException("No csv output directory provided");
            }
            File f = new File(option);
            if (f.exists()) {
                f.delete();
            }
            BufferedWriter output = new BufferedWriter(new FileWriter(f));
            int counter = 1;
            while ((strLine = bf.readLine()) != null) {
                if (counter % 2 == 0) {
                    ++counter;
                    continue;
                }
                StringTokenizer token = new StringTokenizer(strLine, ",");
                while (token.hasMoreElements()) {
                    String header = token.nextToken();
                    if (title.isEmpty()) {
                        title.add(header);
                        continue;
                    }
                    if (title.contains(header)) continue;
                    title.add(header);
                }
                ++counter;
            }
            bf.close();
            String temp = "";
            for (int i = 0; i < title.size(); ++i) {
                temp = temp + (String)title.get(i);
                if (i >= title.size() - 1) continue;
                temp = temp + ",";
            }
            output.write(temp + "\n");
            bf = new BufferedReader(new FileReader(fii));
            strLine = "";
            counter = 1;
            ArrayList<String> key_title = new ArrayList<String>();
            Hashtable<String, String> table = new Hashtable<String, String>();
            while ((strLine = bf.readLine()) != null) {
                StringTokenizer token = new StringTokenizer(strLine, ",");
                if (counter % 2 == 0) {
                    for (String k : key_title) {
                        String datA = token.nextToken();
                        table.put(k, datA);
                    }
                    temp = "";
                    for (int i = 0; i < title.size(); ++i) {
                        String key = (String)title.get(i);
                        temp = table.containsKey(key) ? temp + (String)table.get(key) : temp + "?";
                        if (i >= title.size() - 1) continue;
                        temp = temp + ",";
                    }
                    output.write(temp + "\n");
                    table.clear();
                    key_title.clear();
                } else {
                    while (token.hasMoreElements()) {
                        String tk = token.nextToken();
                        table.put(tk, "");
                        key_title.add(tk);
                    }
                }
                ++counter;
            }
            output.flush();
            output.close();
            bf.close();
            Instances csvDataset = ConverterUtils.DataSource.read((String)csvPath);
            String arffPath = csvPath.substring(0, csvPath.length() - 3) + "arff";
            ConverterUtils.DataSink.write((String)arffPath, (Instances)csvDataset);
            System.exit(ret);
        }
    }

    public static class Reduce
    extends Reducer<Text, Text, Text, NullWritable> {
        public void reduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            try {
                Text word = null;
                Iterator<Text> i$ = values.iterator();
                while (i$.hasNext()) {
                    Text s;
                    word = s = i$.next();
                }
                context.write(word, null);
                context.write((Object)key, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class Map
    extends Mapper<LongWritable, Text, Text, Text> {
        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String line = value.toString();
            int tokenIndex = 0;
            String[] token = line.split(",");
            String algorithm = token[tokenIndex++];
            int repetition = Integer.parseInt(token[tokenIndex++]);
            String datasets = token[tokenIndex++];
            int fold = Integer.parseInt(token[tokenIndex++]);
            String classIndex = token[tokenIndex++];
            String isClassification = token[tokenIndex++];
            HadoopExperiment.m_Exp.m_RP.setResultListener((ResultListener)HadoopExperiment.m_Exp.m_ResultListener);
            if (isClassification.equals("true")) {
                HadoopExperiment.m_Exp.m_RP.setSplitEvaluator((SplitEvaluator)HadoopExperiment.m_Exp.m_SplitEvaluator);
            } else {
                HadoopExperiment.m_Exp.m_RP.setSplitEvaluator((SplitEvaluator)HadoopExperiment.m_Exp.m_SplitEvaluator2);
            }
            try {
                Double v;
                int i;
                ObjectOutputStream oostream;
                ByteArrayOutputStream bastream;
                Classifier c;
                String[] options = Utils.splitOptions((String)algorithm);
                String classname = options[0];
                options[0] = "";
                HadoopExperiment.m_Exp.m_Classifier = c = (Classifier)Utils.forName(Classifier.class, (String)classname, (String[])options);
                if (c instanceof AdditionalMeasureProducer) {
                    Enumeration enm = ((AdditionalMeasureProducer)c).enumerateMeasures();
                    HadoopExperiment.m_Exp.measures.clear();
                    while (enm.hasMoreElements()) {
                        String input = enm.nextElement().toString();
                        HadoopExperiment.m_Exp.measures.add(input);
                    }
                } else {
                    HadoopExperiment.m_Exp.measures.clear();
                }
                if (isClassification.equals("true")) {
                    HadoopExperiment.m_Exp.m_SplitEvaluator.setClassifier(c);
                } else {
                    HadoopExperiment.m_Exp.m_SplitEvaluator2.setClassifier(c);
                }
                File currentFile = new File(datasets);
                ArffLoader loader = new ArffLoader();
                loader.setFile(currentFile);
                Instances data = new Instances(loader.getDataSet());
                if (classIndex.equals("last") || classIndex.equals("default")) {
                    data.setClassIndex(data.numAttributes() - 1);
                } else if (classIndex.equals("first")) {
                    data.setClassIndex(0);
                } else {
                    int in = Integer.parseInt(classIndex);
                    data.setClassIndex(in);
                }
                Instances runInstances = new Instances(data);
                Random random = new Random(repetition);
                runInstances.randomize(random);
                if (runInstances.classAttribute().isNominal()) {
                    runInstances.stratify(HadoopExperiment.m_Exp.m_NumFolds);
                }
                ArrayList<Object> result = new ArrayList<Object>();
                Instances train = runInstances.trainCV(HadoopExperiment.m_Exp.m_NumFolds, fold, random);
                Instances test = runInstances.testCV(HadoopExperiment.m_Exp.m_NumFolds, fold);
                ThreadMXBean thMonitor = ManagementFactory.getThreadMXBean();
                boolean canMeasureCPUTime = thMonitor.isThreadCpuTimeSupported();
                if (canMeasureCPUTime && !thMonitor.isThreadCpuTimeEnabled()) {
                    thMonitor.setThreadCpuTimeEnabled(true);
                }
                long thID = Thread.currentThread().getId();
                long CPUStartTime = -1L;
                long trainCPUTimeElapsed = -1L;
                long testCPUTimeElapsed = -1L;
                long time4 = System.currentTimeMillis();
                Evaluation eval = new Evaluation(train);
                long trainTimeStart = System.currentTimeMillis();
                long time11 = System.currentTimeMillis();
                if (canMeasureCPUTime) {
                    CPUStartTime = thMonitor.getThreadUserTime(thID);
                }
                c.buildClassifier(train);
                System.out.println("[algorithm:" + algorithm + "] [dataset:" + datasets + "] [fold:" + fold + "] [repetition:" + repetition + "]");
                long time12 = System.currentTimeMillis();
                System.out.println("Train: " + (time12 - time11));
                if (canMeasureCPUTime) {
                    trainCPUTimeElapsed = thMonitor.getThreadUserTime(thID) - CPUStartTime;
                }
                long trainTimeElapsed = System.currentTimeMillis() - trainTimeStart;
                long testTimeStart = System.currentTimeMillis();
                if (canMeasureCPUTime) {
                    CPUStartTime = thMonitor.getThreadUserTime(thID);
                }
                double[] predictions = eval.evaluateModel(c, test, new Object[0]);
                if (canMeasureCPUTime) {
                    testCPUTimeElapsed = thMonitor.getThreadUserTime(thID) - CPUStartTime;
                }
                long testTimeElapsed = System.currentTimeMillis() - testTimeStart;
                thMonitor = null;
                Object[] seKey = isClassification.equals("true") ? HadoopExperiment.m_Exp.m_SplitEvaluator.getKey() : HadoopExperiment.m_Exp.m_SplitEvaluator2.getKey();
                if (isClassification.equals("true")) {
                    result.add(data.relationName());
                    result.add(new Double(repetition));
                    result.add(new Double(fold + 1));
                    result.add(seKey[0]);
                    result.add(new String("'" + seKey[1] + "'"));
                    result.add(seKey[2]);
                    result.add(new Double(HadoopExperiment.getTimestamp()));
                    result.add(new Double(train.numInstances()));
                    result.add(new Double(eval.numInstances()));
                    result.add(new Double(eval.correct()));
                    result.add(new Double(eval.incorrect()));
                    result.add(new Double(eval.unclassified()));
                    result.add(new Double(eval.pctCorrect()));
                    result.add(new Double(eval.pctIncorrect()));
                    result.add(new Double(eval.pctUnclassified()));
                    result.add(new Double(eval.kappa()));
                    result.add(new Double(eval.meanAbsoluteError()));
                    result.add(new Double(eval.rootMeanSquaredError()));
                    result.add(new Double(eval.relativeAbsoluteError()));
                    result.add(new Double(eval.rootRelativeSquaredError()));
                    result.add(new Double(eval.SFPriorEntropy()));
                    result.add(new Double(eval.SFSchemeEntropy()));
                    result.add(new Double(eval.SFEntropyGain()));
                    result.add(new Double(eval.SFMeanPriorEntropy()));
                    result.add(new Double(eval.SFMeanSchemeEntropy()));
                    result.add(new Double(eval.SFMeanEntropyGain()));
                    result.add(new Double(eval.KBInformation()));
                    result.add(new Double(eval.KBMeanInformation()));
                    result.add(new Double(eval.KBRelativeInformation()));
                    result.add(new Double(eval.truePositiveRate(HadoopExperiment.m_Exp.m_IRclass)));
                    result.add(new Double(eval.numTruePositives(HadoopExperiment.m_Exp.m_IRclass)));
                    result.add(new Double(eval.falsePositiveRate(HadoopExperiment.m_Exp.m_IRclass)));
                    result.add(new Double(eval.numFalsePositives(HadoopExperiment.m_Exp.m_IRclass)));
                    result.add(new Double(eval.trueNegativeRate(HadoopExperiment.m_Exp.m_IRclass)));
                    result.add(new Double(eval.numTrueNegatives(HadoopExperiment.m_Exp.m_IRclass)));
                    result.add(new Double(eval.falseNegativeRate(HadoopExperiment.m_Exp.m_IRclass)));
                    result.add(new Double(eval.numFalseNegatives(HadoopExperiment.m_Exp.m_IRclass)));
                    result.add(new Double(eval.precision(HadoopExperiment.m_Exp.m_IRclass)));
                    result.add(new Double(eval.recall(HadoopExperiment.m_Exp.m_IRclass)));
                    result.add(new Double(eval.fMeasure(HadoopExperiment.m_Exp.m_IRclass)));
                    result.add(new Double(eval.areaUnderROC(HadoopExperiment.m_Exp.m_IRclass)));
                    result.add(new Double(eval.areaUnderPRC(HadoopExperiment.m_Exp.m_IRclass)));
                    result.add(new Double(eval.weightedTruePositiveRate()));
                    result.add(new Double(eval.weightedFalsePositiveRate()));
                    result.add(new Double(eval.weightedTrueNegativeRate()));
                    result.add(new Double(eval.weightedFalseNegativeRate()));
                    result.add(new Double(eval.weightedPrecision()));
                    result.add(new Double(eval.weightedRecall()));
                    result.add(new Double(eval.weightedFMeasure()));
                    result.add(new Double(eval.weightedAreaUnderROC()));
                    result.add(new Double(eval.weightedAreaUnderPRC()));
                    result.add(new Double(eval.unweightedMacroFmeasure()));
                    result.add(new Double(eval.unweightedMicroFmeasure()));
                    result.add(new Double((double)trainTimeElapsed / 1000.0));
                    result.add(new Double((double)testTimeElapsed / 1000.0));
                    if (canMeasureCPUTime) {
                        result.add(new Double((double)trainCPUTimeElapsed / 1000000.0 / 1000.0));
                        result.add(new Double((double)testCPUTimeElapsed / 1000000.0 / 1000.0));
                    } else {
                        result.add(new Double(Utils.missingValue()));
                        result.add(new Double(Utils.missingValue()));
                    }
                    bastream = new ByteArrayOutputStream();
                    oostream = new ObjectOutputStream(bastream);
                    oostream.writeObject(c);
                    result.add(new Double(bastream.size()));
                    bastream = new ByteArrayOutputStream();
                    oostream = new ObjectOutputStream(bastream);
                    oostream.writeObject(train);
                    result.add(new Double(bastream.size()));
                    bastream = new ByteArrayOutputStream();
                    oostream = new ObjectOutputStream(bastream);
                    oostream.writeObject(test);
                    result.add(new Double(bastream.size()));
                    result.add(new Double(eval.coverageOfTestCasesByPredictedRegions()));
                    result.add(new Double(eval.sizeOfPredictedRegions()));
                    if (HadoopExperiment.m_Exp.m_attID >= 0) {
                        int i2;
                        StringBuilder idsString = new StringBuilder("");
                        if (test.attribute(HadoopExperiment.m_Exp.m_attID).isNumeric()) {
                            if (test.numInstances() > 0) {
                                idsString.append(test.instance(0).value(HadoopExperiment.m_Exp.m_attID));
                            }
                            for (i2 = 1; i2 < test.numInstances(); ++i2) {
                                idsString.append("|" + test.instance(i2).value(HadoopExperiment.m_Exp.m_attID));
                            }
                        } else {
                            if (test.numInstances() > 0) {
                                idsString.append(test.instance(0).stringValue(HadoopExperiment.m_Exp.m_attID));
                            }
                            for (i2 = 1; i2 < test.numInstances(); ++i2) {
                                idsString.append("|" + test.instance(i2).stringValue(HadoopExperiment.m_Exp.m_attID));
                            }
                        }
                        result.add(idsString.toString());
                    }
                    if (HadoopExperiment.m_Exp.m_predTargetColumn) {
                        int i3;
                        StringBuilder predictionsString = new StringBuilder("");
                        StringBuilder targetsString = new StringBuilder("");
                        if (test.classAttribute().isNumeric()) {
                            if (test.numInstances() > 0) {
                                targetsString.append(test.instance(0).value(test.classIndex()));
                                for (i3 = 1; i3 < test.numInstances(); ++i3) {
                                    targetsString.append("|" + test.instance(i3).value(test.classIndex()));
                                }
                                result.add(targetsString.toString());
                            }
                            if (predictions.length > 0) {
                                predictionsString.append(predictions[0]);
                                for (i3 = 1; i3 < predictions.length; ++i3) {
                                    predictionsString.append("|" + predictions[i3]);
                                }
                                result.add(predictionsString.toString());
                            }
                        } else {
                            if (test.numInstances() > 0) {
                                targetsString.append(test.instance(0).stringValue(test.classIndex()));
                                for (i3 = 1; i3 < test.numInstances(); ++i3) {
                                    targetsString.append("|" + test.instance(i3).stringValue(test.classIndex()));
                                }
                                result.add(targetsString.toString());
                            }
                            if (predictions.length > 0) {
                                predictionsString.append(test.classAttribute().value((int)predictions[0]));
                                for (i3 = 1; i3 < predictions.length; ++i3) {
                                    predictionsString.append("|" + test.classAttribute().value((int)predictions[i3]));
                                }
                                result.add(predictionsString.toString());
                            }
                        }
                    }
                    if (c instanceof Summarizable) {
                        String out = ((Summarizable)c).toSummaryString();
                        result.add(new String("'" + Utils.backQuoteChars((String)out) + "'"));
                    } else {
                        result.add(new String("?"));
                    }
                    for (i = 0; i < HadoopExperiment.m_Exp.measures.size(); ++i) {
                        try {
                            double dv = ((AdditionalMeasureProducer)c).getMeasure(HadoopExperiment.m_Exp.measures.get(i));
                            if (!Utils.isMissingValue((double)dv)) {
                                v = new Double(dv);
                                result.add(v);
                                continue;
                            }
                            result.add(null);
                            continue;
                        }
                        catch (Exception ex) {
                            System.err.println(ex);
                        }
                    }
                } else {
                    result.add(new String(data.relationName()));
                    result.add(new Double(repetition));
                    result.add(new Double(fold + 1));
                    result.add(seKey[0]);
                    result.add("'" + seKey[1] + "'");
                    result.add(seKey[2]);
                    result.add(new Double(HadoopExperiment.getTimestamp()));
                    result.add(new Double(train.numInstances()));
                    result.add(new Double(eval.numInstances()));
                    result.add(new Double(eval.meanAbsoluteError()));
                    result.add(new Double(eval.rootMeanSquaredError()));
                    result.add(new Double(eval.relativeAbsoluteError()));
                    result.add(new Double(eval.rootRelativeSquaredError()));
                    result.add(new Double(eval.correlationCoefficient()));
                    result.add(new Double(eval.SFPriorEntropy()));
                    result.add(new Double(eval.SFSchemeEntropy()));
                    result.add(new Double(eval.SFEntropyGain()));
                    result.add(new Double(eval.SFMeanPriorEntropy()));
                    result.add(new Double(eval.SFMeanSchemeEntropy()));
                    result.add(new Double(eval.SFMeanEntropyGain()));
                    result.add(new Double((double)trainTimeElapsed / 1000.0));
                    result.add(new Double((double)testTimeElapsed / 1000.0));
                    if (canMeasureCPUTime) {
                        result.add(new Double((double)trainCPUTimeElapsed / 1000000.0 / 1000.0));
                        result.add(new Double((double)testCPUTimeElapsed / 1000000.0 / 1000.0));
                    } else {
                        result.add(new Double(Utils.missingValue()));
                        result.add(new Double(Utils.missingValue()));
                    }
                    bastream = new ByteArrayOutputStream();
                    oostream = new ObjectOutputStream(bastream);
                    oostream.writeObject(c);
                    result.add(new Double(bastream.size()));
                    bastream = new ByteArrayOutputStream();
                    oostream = new ObjectOutputStream(bastream);
                    oostream.writeObject(train);
                    result.add(new Double(bastream.size()));
                    bastream = new ByteArrayOutputStream();
                    oostream = new ObjectOutputStream(bastream);
                    oostream.writeObject(test);
                    result.add(new Double(bastream.size()));
                    result.add(new Double(eval.coverageOfTestCasesByPredictedRegions()));
                    result.add(new Double(eval.sizeOfPredictedRegions()));
                    if (c instanceof Summarizable) {
                        String out = ((Summarizable)c).toSummaryString();
                        result.add(new String("'" + Utils.backQuoteChars((String)out) + "'"));
                    } else {
                        result.add(new String("?"));
                    }
                    for (i = 0; i < HadoopExperiment.m_Exp.measures.size(); ++i) {
                        try {
                            double dv = ((AdditionalMeasureProducer)c).getMeasure(HadoopExperiment.m_Exp.measures.get(i));
                            if (!Utils.isMissingValue((double)dv)) {
                                v = new Double(dv);
                                result.add(v);
                                continue;
                            }
                            result.add(null);
                            continue;
                        }
                        catch (Exception ex) {
                            System.err.println(ex);
                        }
                    }
                }
                StringBuffer output = new StringBuffer();
                for (int i4 = 0; i4 < result.size(); ++i4) {
                    if (i4 > 0) {
                        output.append(",");
                    }
                    if (result.get(i4) == null) continue;
                    output.append(result.get(i4).toString());
                }
                Text word = new Text();
                word.set(output.toString());
                StringBuilder values = new StringBuilder("");
                if (!HadoopExperiment.m_Exp.measures.isEmpty()) {
                    for (String s : HadoopExperiment.m_Exp.measures) {
                        values.append("," + s);
                    }
                } else {
                    values.append("");
                }
                StringBuffer re = new StringBuffer();
                String[] keyNames = HadoopExperiment.m_Exp.m_RP.getKeyNames();
                String[] resultNames = HadoopExperiment.m_Exp.m_RP.getResultNames();
                int[] m_AttributeTypes = new int[keyNames.length + resultNames.length];
                for (int i5 = 0; i5 < m_AttributeTypes.length; ++i5) {
                    String attribName = "Unknown";
                    attribName = i5 < keyNames.length ? "Key_" + keyNames[i5] : resultNames[i5 - keyNames.length];
                    re.append(attribName);
                    if (i5 >= m_AttributeTypes.length - 1) continue;
                    re.append(",");
                }
                re.append(values.toString());
                Text mapValue = new Text();
                mapValue.set(re.toString());
                context.write((Object)new Text("1"), (Object)new Text("2"));
                long time6 = System.currentTimeMillis();
                System.out.println("Whole Process:" + (time6 - time4));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

