/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.sequence.core;

import java.util.Vector;
import weka.classifiers.sequence.core.BackwardAlgorithm;
import weka.classifiers.sequence.core.ForwardAlgorithm;
import weka.classifiers.sequence.core.IllegalSymbolException;
import weka.classifiers.sequence.core.ImpossibleStateProbabilityException;
import weka.classifiers.sequence.core.InvalidStructureException;
import weka.classifiers.sequence.core.InvalidViterbiPathException;
import weka.classifiers.sequence.core.ProfileHMM;
import weka.classifiers.sequence.core.ProfileHMMAlgorithms;

public class ProbabilityPerStateCalculator
extends ProfileHMMAlgorithms {
    private static final long serialVersionUID = -2163580005173691767L;
    private int numberOfMatchStates;
    private boolean isLogSpace;
    private String testSequence;
    private ForwardAlgorithm fwd;
    private BackwardAlgorithm bwd;
    private double scoreOfTestSequence;
    private Vector<Double> scores4AllStates;

    public ProbabilityPerStateCalculator(ProfileHMM net, String sequence) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException {
        super(net);
        this.numberOfMatchStates = net.getNumberMatchStates();
        this.isLogSpace = net.isUseLogSpace();
        this.testSequence = sequence;
        this.fwd = new ForwardAlgorithm(net, this.testSequence);
        this.bwd = new BackwardAlgorithm(net, this.testSequence);
        this.fwd.calculateForward();
        this.bwd.calculateBackward();
        this.scoreOfTestSequence = this.fwd.getScore();
        this.scores4AllStates = new Vector();
    }

    public Vector<Double> getScores() throws ImpossibleStateProbabilityException {
        int i;
        double sumPerState;
        int k;
        this.testScores();
        for (k = 1; k < this.numberOfMatchStates - 1; ++k) {
            sumPerState = Double.NEGATIVE_INFINITY;
            for (i = 0; i < this.testSequence.length(); ++i) {
                sumPerState = ProbabilityPerStateCalculator.logplus(sumPerState, ProbabilityPerStateCalculator.logsum(this.fwd.getMatchMatrixPos(k, i), this.bwd.getMatchMatrixPos(k, i)));
            }
            sumPerState = ProbabilityPerStateCalculator.logsum(sumPerState, this.scoreOfTestSequence * -1.0);
            if (!this.isLogSpace) {
                sumPerState = Math.exp(sumPerState);
            }
            this.scores4AllStates.add(sumPerState);
        }
        for (k = 0; k < this.numberOfMatchStates - 1; ++k) {
            sumPerState = Double.NEGATIVE_INFINITY;
            for (i = 0; i < this.testSequence.length(); ++i) {
                sumPerState = ProbabilityPerStateCalculator.logplus(sumPerState, ProbabilityPerStateCalculator.logsum(this.fwd.getInsertMatrixPos(k, i), this.bwd.getInsertMatrixPos(k, i)));
            }
            sumPerState = ProbabilityPerStateCalculator.logsum(sumPerState, this.scoreOfTestSequence * -1.0);
            if (!this.isLogSpace) {
                sumPerState = Math.exp(sumPerState);
            }
            this.scores4AllStates.add(sumPerState);
        }
        for (k = 0; k < this.numberOfMatchStates - 2; ++k) {
            sumPerState = Double.NEGATIVE_INFINITY;
            for (i = 0; i < this.testSequence.length(); ++i) {
                sumPerState = ProbabilityPerStateCalculator.logplus(sumPerState, ProbabilityPerStateCalculator.logsum(this.fwd.getDeleteMatrixPos(k, i), this.bwd.getDeleteMatrixPos(k, i)));
            }
            sumPerState = ProbabilityPerStateCalculator.logsum(sumPerState, this.scoreOfTestSequence * -1.0);
            if (!this.isLogSpace) {
                sumPerState = Math.exp(sumPerState);
            }
            this.scores4AllStates.add(sumPerState);
        }
        return this.scores4AllStates;
    }

    private void testScores() throws ImpossibleStateProbabilityException {
        double sumPerState = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.testSequence.length(); ++i) {
            sumPerState = ProbabilityPerStateCalculator.logplus(sumPerState, ProbabilityPerStateCalculator.logsum(this.fwd.getMatchMatrixPos(0, i), this.bwd.getMatchMatrixPos(0, i)));
        }
        if ((sumPerState = ProbabilityPerStateCalculator.logsum(sumPerState, this.scoreOfTestSequence * -1.0)) > 1.0E-8) {
            throw new ImpossibleStateProbabilityException("Probablity of first match state M0 should be 1, but it is" + Math.exp(sumPerState));
        }
        sumPerState = Double.NEGATIVE_INFINITY;
        int lastState = this.numberOfMatchStates - 1;
        for (int i = 0; i < this.testSequence.length(); ++i) {
            sumPerState = ProbabilityPerStateCalculator.logplus(sumPerState, ProbabilityPerStateCalculator.logsum(this.fwd.getMatchMatrixPos(lastState, i), this.bwd.getMatchMatrixPos(lastState, i)));
        }
        if ((sumPerState = ProbabilityPerStateCalculator.logsum(sumPerState, this.scoreOfTestSequence * -1.0)) > 1.0E-8) {
            throw new ImpossibleStateProbabilityException("Probablity of last match state M" + lastState + " should be 1, but it is" + Math.exp(sumPerState));
        }
    }
}

