/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.bayes.net.ADNode;
import weka.classifiers.bayes.net.BIFReader;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.estimate.BayesNetEstimator;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorBayes;
import weka.classifiers.bayes.net.estimate.SimpleEstimator;
import weka.classifiers.bayes.net.search.SearchAlgorithm;
import weka.classifiers.bayes.net.search.local.K2;
import weka.classifiers.bayes.net.search.local.LocalScoreSearchAlgorithm;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.estimators.Estimator;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class BayesNet
extends AbstractClassifier
implements OptionHandler,
WeightedInstancesHandler,
Drawable,
AdditionalMeasureProducer {
    static final long serialVersionUID = 746037443258775954L;
    protected ParentSet[] m_ParentSets;
    public Estimator[][] m_Distributions;
    protected Discretize m_DiscretizeFilter = null;
    int m_nNonDiscreteAttribute = -1;
    protected ReplaceMissingValues m_MissingValuesFilter = null;
    protected int m_NumClasses;
    public Instances m_Instances;
    ADNode m_ADTree;
    protected BIFReader m_otherBayesNet = null;
    boolean m_bUseADTree = false;
    SearchAlgorithm m_SearchAlgorithm = new K2();
    BayesNetEstimator m_BayesNetEstimator = new SimpleEstimator();

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        instances = this.normalizeDataSet(instances);
        this.m_Instances = new Instances(instances);
        this.m_NumClasses = instances.numClasses();
        if (this.m_bUseADTree) {
            this.m_ADTree = ADNode.makeADTree(instances);
        }
        this.initStructure();
        this.buildStructure();
        this.estimateCPTs();
        this.m_ADTree = null;
    }

    protected Instances normalizeDataSet(Instances instances) throws Exception {
        this.m_DiscretizeFilter = null;
        this.m_MissingValuesFilter = null;
        boolean bHasNonNominal = false;
        boolean bHasMissingValues = false;
        Enumeration enu = instances.enumerateAttributes();
        while (enu.hasMoreElements()) {
            Attribute attribute = (Attribute)enu.nextElement();
            if (attribute.type() != 1) {
                this.m_nNonDiscreteAttribute = attribute.index();
                bHasNonNominal = true;
            }
            Enumeration enum2 = instances.enumerateInstances();
            while (enum2.hasMoreElements()) {
                if (!((Instance)enum2.nextElement()).isMissing(attribute)) continue;
                bHasMissingValues = true;
            }
        }
        if (bHasNonNominal) {
            System.err.println("Warning: discretizing data set");
            this.m_DiscretizeFilter = new Discretize();
            this.m_DiscretizeFilter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_DiscretizeFilter);
        }
        if (bHasMissingValues) {
            System.err.println("Warning: filling in missing values in data set");
            this.m_MissingValuesFilter = new ReplaceMissingValues();
            this.m_MissingValuesFilter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_MissingValuesFilter);
        }
        return instances;
    }

    protected Instance normalizeInstance(Instance instance) throws Exception {
        if (this.m_DiscretizeFilter != null && instance.attribute(this.m_nNonDiscreteAttribute).type() != 1) {
            this.m_DiscretizeFilter.input(instance);
            instance = this.m_DiscretizeFilter.output();
        }
        if (this.m_MissingValuesFilter != null) {
            this.m_MissingValuesFilter.input(instance);
            instance = this.m_MissingValuesFilter.output();
        } else {
            for (int iAttribute = 0; iAttribute < this.m_Instances.numAttributes(); ++iAttribute) {
                if (iAttribute == instance.classIndex() || !instance.isMissing(iAttribute)) continue;
                System.err.println("Warning: Found missing value in test set, filling in values.");
                this.m_MissingValuesFilter = new ReplaceMissingValues();
                this.m_MissingValuesFilter.setInputFormat(this.m_Instances);
                Filter.useFilter(this.m_Instances, this.m_MissingValuesFilter);
                this.m_MissingValuesFilter.input(instance);
                instance = this.m_MissingValuesFilter.output();
                iAttribute = this.m_Instances.numAttributes();
            }
        }
        return instance;
    }

    public void initStructure() throws Exception {
        int nAttribute = 0;
        for (int iOrder = 1; iOrder < this.m_Instances.numAttributes(); ++iOrder) {
            if (nAttribute != this.m_Instances.classIndex()) continue;
            ++nAttribute;
        }
        this.m_ParentSets = new ParentSet[this.m_Instances.numAttributes()];
        for (int iAttribute = 0; iAttribute < this.m_Instances.numAttributes(); ++iAttribute) {
            this.m_ParentSets[iAttribute] = new ParentSet(this.m_Instances.numAttributes());
        }
    }

    public void buildStructure() throws Exception {
        this.m_SearchAlgorithm.buildStructure(this, this.m_Instances);
    }

    public void estimateCPTs() throws Exception {
        this.m_BayesNetEstimator.estimateCPTs(this);
    }

    public void initCPTs() throws Exception {
        this.m_BayesNetEstimator.initCPTs(this);
    }

    public void updateClassifier(Instance instance) throws Exception {
        instance = this.normalizeInstance(instance);
        this.m_BayesNetEstimator.updateClassifier(this, instance);
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        instance = this.normalizeInstance(instance);
        return this.m_BayesNetEstimator.distributionForInstance(this, instance);
    }

    public double[] countsForInstance(Instance instance) throws Exception {
        int iClass;
        double[] fCounts = new double[this.m_NumClasses];
        for (iClass = 0; iClass < this.m_NumClasses; ++iClass) {
            fCounts[iClass] = 0.0;
        }
        iClass = 0;
        while (iClass < this.m_NumClasses) {
            double fCount = 0.0;
            for (int iAttribute = 0; iAttribute < this.m_Instances.numAttributes(); ++iAttribute) {
                double iCPT = 0.0;
                for (int iParent = 0; iParent < this.m_ParentSets[iAttribute].getNrOfParents(); ++iParent) {
                    int nParent = this.m_ParentSets[iAttribute].getParent(iParent);
                    iCPT = nParent == this.m_Instances.classIndex() ? iCPT * (double)this.m_NumClasses + (double)iClass : iCPT * (double)this.m_Instances.attribute(nParent).numValues() + instance.value(nParent);
                }
                if (iAttribute == this.m_Instances.classIndex()) {
                    fCount += ((DiscreteEstimatorBayes)this.m_Distributions[iAttribute][(int)iCPT]).getCount(iClass);
                    continue;
                }
                fCount += ((DiscreteEstimatorBayes)this.m_Distributions[iAttribute][(int)iCPT]).getCount(instance.value(iAttribute));
            }
            int n = iClass++;
            fCounts[n] = fCounts[n] + fCount;
        }
        return fCounts;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tDo not use ADTree data structure\n", "D", 0, "-D"));
        newVector.addElement(new Option("\tBIF file to compare with\n", "B", 1, "-B <BIF file>"));
        newVector.addElement(new Option("\tSearch algorithm\n", "Q", 1, "-Q weka.classifiers.bayes.net.search.SearchAlgorithm"));
        newVector.addElement(new Option("\tEstimator algorithm\n", "E", 1, "-E weka.classifiers.bayes.net.estimate.SimpleEstimator"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String searchAlgorithmName;
        this.m_bUseADTree = !Utils.getFlag('D', options);
        String sBIFFile = Utils.getOption('B', options);
        if (sBIFFile != null && !sBIFFile.equals("")) {
            this.setBIFFile(sBIFFile);
        }
        if ((searchAlgorithmName = Utils.getOption('Q', options)).length() != 0) {
            this.setSearchAlgorithm((SearchAlgorithm)Utils.forName(SearchAlgorithm.class, searchAlgorithmName, BayesNet.partitionOptions(options)));
        } else {
            this.setSearchAlgorithm(new K2());
        }
        String estimatorName = Utils.getOption('E', options);
        if (estimatorName.length() != 0) {
            this.setEstimator((BayesNetEstimator)Utils.forName(BayesNetEstimator.class, estimatorName, Utils.partitionOptions(options)));
        } else {
            this.setEstimator(new SimpleEstimator());
        }
        Utils.checkForRemainingOptions(options);
    }

    public static String[] partitionOptions(String[] options) {
        for (int i = 0; i < options.length; ++i) {
            int j;
            if (!options[i].equals("--")) continue;
            for (j = i; j < options.length && !options[j].equals("-E"); ++j) {
            }
            options[i++] = "";
            String[] result = new String[options.length - i];
            for (j = i; j < options.length && !options[j].equals("-E"); ++j) {
                result[j - i] = options[j];
                options[j] = "";
            }
            while (j < options.length) {
                result[j - i] = "";
                ++j;
            }
            return result;
        }
        return new String[0];
    }

    @Override
    public String[] getOptions() {
        int iOption;
        String[] searchOptions = this.m_SearchAlgorithm.getOptions();
        String[] estimatorOptions = this.m_BayesNetEstimator.getOptions();
        String[] options = new String[11 + searchOptions.length + estimatorOptions.length];
        int current = 0;
        if (!this.m_bUseADTree) {
            options[current++] = "-D";
        }
        if (this.m_otherBayesNet != null) {
            options[current++] = "-B";
            options[current++] = this.m_otherBayesNet.getFileName();
        }
        options[current++] = "-Q";
        options[current++] = "" + this.getSearchAlgorithm().getClass().getName();
        options[current++] = "--";
        for (iOption = 0; iOption < searchOptions.length; ++iOption) {
            options[current++] = searchOptions[iOption];
        }
        options[current++] = "-E";
        options[current++] = "" + this.getEstimator().getClass().getName();
        options[current++] = "--";
        for (iOption = 0; iOption < estimatorOptions.length; ++iOption) {
            options[current++] = estimatorOptions[iOption];
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public void setSearchAlgorithm(SearchAlgorithm newSearchAlgorithm) {
        this.m_SearchAlgorithm = newSearchAlgorithm;
    }

    public SearchAlgorithm getSearchAlgorithm() {
        return this.m_SearchAlgorithm;
    }

    public void setEstimator(BayesNetEstimator newBayesNetEstimator) {
        this.m_BayesNetEstimator = newBayesNetEstimator;
    }

    public BayesNetEstimator getEstimator() {
        return this.m_BayesNetEstimator;
    }

    public void setUseADTree(boolean bUseADTree) {
        this.m_bUseADTree = bUseADTree;
    }

    public boolean getUseADTree() {
        return this.m_bUseADTree;
    }

    public void setBIFFile(String sBIFFile) {
        try {
            this.m_otherBayesNet = new BIFReader().processFile(sBIFFile);
        }
        catch (Throwable t) {
            this.m_otherBayesNet = null;
        }
    }

    public String getBIFFile() {
        if (this.m_otherBayesNet != null) {
            return this.m_otherBayesNet.getFileName();
        }
        return "";
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("Bayes Network Classifier");
        text.append("\n" + (this.m_bUseADTree ? "Using " : "not using ") + "ADTree");
        if (this.m_Instances == null) {
            text.append(": No model built yet.");
        } else {
            text.append("\n#attributes=");
            text.append(this.m_Instances.numAttributes());
            text.append(" #classindex=");
            text.append(this.m_Instances.classIndex());
            text.append("\nNetwork structure (nodes followed by parents)\n");
            for (int iAttribute = 0; iAttribute < this.m_Instances.numAttributes(); ++iAttribute) {
                text.append(this.m_Instances.attribute(iAttribute).name() + "(" + this.m_Instances.attribute(iAttribute).numValues() + "): ");
                for (int iParent = 0; iParent < this.m_ParentSets[iAttribute].getNrOfParents(); ++iParent) {
                    text.append(this.m_Instances.attribute(this.m_ParentSets[iAttribute].getParent(iParent)).name() + " ");
                }
                text.append("\n");
            }
            text.append("LogScore Bayes: " + this.measureBayesScore() + "\n");
            text.append("LogScore BDeu: " + this.measureBDeuScore() + "\n");
            text.append("LogScore MDL: " + this.measureMDLScore() + "\n");
            text.append("LogScore ENTROPY: " + this.measureEntropyScore() + "\n");
            text.append("LogScore AIC: " + this.measureAICScore() + "\n");
            if (this.m_otherBayesNet != null) {
                text.append("Missing: " + this.m_otherBayesNet.missingArcs(this) + " Extra: " + this.m_otherBayesNet.extraArcs(this) + " Reversed: " + this.m_otherBayesNet.reversedArcs(this) + "\n");
                text.append("Divergence: " + this.m_otherBayesNet.divergence(this) + "\n");
            }
        }
        return text.toString();
    }

    @Override
    public int graphType() {
        return 2;
    }

    @Override
    public String graph() throws Exception {
        return this.toXMLBIF03();
    }

    public String getBIFHeader() {
        StringBuffer text = new StringBuffer();
        text.append("<?xml version=\"1.0\"?>\n");
        text.append("<!-- DTD for the XMLBIF 0.3 format -->\n");
        text.append("<!DOCTYPE BIF [\n");
        text.append("\t<!ELEMENT BIF ( NETWORK )*>\n");
        text.append("\t      <!ATTLIST BIF VERSION CDATA #REQUIRED>\n");
        text.append("\t<!ELEMENT NETWORK ( NAME, ( PROPERTY | VARIABLE | DEFINITION )* )>\n");
        text.append("\t<!ELEMENT NAME (#PCDATA)>\n");
        text.append("\t<!ELEMENT VARIABLE ( NAME, ( OUTCOME |  PROPERTY )* ) >\n");
        text.append("\t      <!ATTLIST VARIABLE TYPE (nature|decision|utility) \"nature\">\n");
        text.append("\t<!ELEMENT OUTCOME (#PCDATA)>\n");
        text.append("\t<!ELEMENT DEFINITION ( FOR | GIVEN | TABLE | PROPERTY )* >\n");
        text.append("\t<!ELEMENT FOR (#PCDATA)>\n");
        text.append("\t<!ELEMENT GIVEN (#PCDATA)>\n");
        text.append("\t<!ELEMENT TABLE (#PCDATA)>\n");
        text.append("\t<!ELEMENT PROPERTY (#PCDATA)>\n");
        text.append("]>\n");
        return text.toString();
    }

    public String toXMLBIF03() {
        int iAttribute;
        if (this.m_Instances == null) {
            return "<!--No model built yet-->";
        }
        StringBuffer text = new StringBuffer();
        text.append(this.getBIFHeader());
        text.append("\n");
        text.append("\n");
        text.append("<BIF VERSION=\"0.3\">\n");
        text.append("<NETWORK>\n");
        text.append("<NAME>" + this.XMLNormalize(this.m_Instances.relationName()) + "</NAME>\n");
        for (iAttribute = 0; iAttribute < this.m_Instances.numAttributes(); ++iAttribute) {
            text.append("<VARIABLE TYPE=\"nature\">\n");
            text.append("<NAME>" + this.XMLNormalize(this.m_Instances.attribute(iAttribute).name()) + "</NAME>\n");
            for (int iValue = 0; iValue < this.m_Instances.attribute(iAttribute).numValues(); ++iValue) {
                text.append("<OUTCOME>" + this.XMLNormalize(this.m_Instances.attribute(iAttribute).value(iValue)) + "</OUTCOME>\n");
            }
            text.append("</VARIABLE>\n");
        }
        for (iAttribute = 0; iAttribute < this.m_Instances.numAttributes(); ++iAttribute) {
            int iParent;
            text.append("<DEFINITION>\n");
            text.append("<FOR>" + this.XMLNormalize(this.m_Instances.attribute(iAttribute).name()) + "</FOR>\n");
            for (iParent = 0; iParent < this.m_ParentSets[iAttribute].getNrOfParents(); ++iParent) {
                text.append("<GIVEN>" + this.XMLNormalize(this.m_Instances.attribute(this.m_ParentSets[iAttribute].getParent(iParent)).name()) + "</GIVEN>\n");
            }
            text.append("<TABLE>\n");
            for (iParent = 0; iParent < this.m_ParentSets[iAttribute].getCardinalityOfParents(); ++iParent) {
                for (int iValue = 0; iValue < this.m_Instances.attribute(iAttribute).numValues(); ++iValue) {
                    text.append(this.m_Distributions[iAttribute][iParent].getProbability(iValue));
                    text.append(' ');
                }
                text.append('\n');
            }
            text.append("</TABLE>\n");
            text.append("</DEFINITION>\n");
        }
        text.append("</NETWORK>\n");
        text.append("</BIF>\n");
        return text.toString();
    }

    protected String XMLNormalize(String sStr) {
        StringBuffer sStr2 = new StringBuffer();
        block7: for (int iStr = 0; iStr < sStr.length(); ++iStr) {
            char c = sStr.charAt(iStr);
            switch (c) {
                case '&': {
                    sStr2.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    sStr2.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sStr2.append("&quot;");
                    continue block7;
                }
                case '<': {
                    sStr2.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sStr2.append("&gt;");
                    continue block7;
                }
                default: {
                    sStr2.append(c);
                }
            }
        }
        return sStr2.toString();
    }

    public String useADTreeTipText() {
        return "When ADTree (the data structure for increasing speed on counts, not to be confused with the classifier under the same name) is used learning time goes down typically. However, because ADTrees are memory intensive, memory problems may occur. Switching this option off makes the structure learning algorithms slower, and run with less memory. By default, ADTrees are used.";
    }

    public String searchAlgorithmTipText() {
        return "Select method used for searching network structures.";
    }

    public String estimatorTipText() {
        return "Select Estimator algorithm for finding the conditional probability tables of the Bayes Network.";
    }

    public String BIFFileTipText() {
        return "Set the name of a file in BIF XML format. A Bayes network learned from data can be compared with the Bayes network represented by the BIF file. Statistics calculated are o.a. the number of missing and extra arcs.";
    }

    public String globalInfo() {
        return "Bayes Network learning using various search algorithms and quality measures.\nBase class for a Bayes Network classifier. Provides datastructures (network structure, conditional probability distributions, etc.) and facilities common to Bayes Network learning algorithms like K2 and B.\n\nFor more information see:\n\nhttp://www.cs.waikato.ac.nz/~remco/weka.pdf";
    }

    public static void main(String[] argv) {
        BayesNet.runClassifier(new BayesNet(), argv);
    }

    public String getName() {
        return this.m_Instances.relationName();
    }

    public int getNrOfNodes() {
        return this.m_Instances.numAttributes();
    }

    public String getNodeName(int iNode) {
        return this.m_Instances.attribute(iNode).name();
    }

    public int getCardinality(int iNode) {
        return this.m_Instances.attribute(iNode).numValues();
    }

    public String getNodeValue(int iNode, int iValue) {
        return this.m_Instances.attribute(iNode).value(iValue);
    }

    public int getNrOfParents(int iNode) {
        return this.m_ParentSets[iNode].getNrOfParents();
    }

    public int getParent(int iNode, int iParent) {
        return this.m_ParentSets[iNode].getParent(iParent);
    }

    public ParentSet[] getParentSets() {
        return this.m_ParentSets;
    }

    public Estimator[][] getDistributions() {
        return this.m_Distributions;
    }

    public int getParentCardinality(int iNode) {
        return this.m_ParentSets[iNode].getCardinalityOfParents();
    }

    public double getProbability(int iNode, int iParent, int iValue) {
        return this.m_Distributions[iNode][iParent].getProbability(iValue);
    }

    public ParentSet getParentSet(int iNode) {
        return this.m_ParentSets[iNode];
    }

    public ADNode getADTree() {
        return this.m_ADTree;
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(4);
        newVector.addElement("measureExtraArcs");
        newVector.addElement("measureMissingArcs");
        newVector.addElement("measureReversedArcs");
        newVector.addElement("measureDivergence");
        newVector.addElement("measureBayesScore");
        newVector.addElement("measureBDeuScore");
        newVector.addElement("measureMDLScore");
        newVector.addElement("measureAICScore");
        newVector.addElement("measureEntropyScore");
        return newVector.elements();
    }

    public double measureExtraArcs() {
        if (this.m_otherBayesNet != null) {
            return this.m_otherBayesNet.extraArcs(this);
        }
        return 0.0;
    }

    public double measureMissingArcs() {
        if (this.m_otherBayesNet != null) {
            return this.m_otherBayesNet.missingArcs(this);
        }
        return 0.0;
    }

    public double measureReversedArcs() {
        if (this.m_otherBayesNet != null) {
            return this.m_otherBayesNet.reversedArcs(this);
        }
        return 0.0;
    }

    public double measureDivergence() {
        if (this.m_otherBayesNet != null) {
            return this.m_otherBayesNet.divergence(this);
        }
        return 0.0;
    }

    public double measureBayesScore() {
        LocalScoreSearchAlgorithm s = new LocalScoreSearchAlgorithm(this, this.m_Instances);
        return s.logScore(0);
    }

    public double measureBDeuScore() {
        LocalScoreSearchAlgorithm s = new LocalScoreSearchAlgorithm(this, this.m_Instances);
        return s.logScore(1);
    }

    public double measureMDLScore() {
        LocalScoreSearchAlgorithm s = new LocalScoreSearchAlgorithm(this, this.m_Instances);
        return s.logScore(2);
    }

    public double measureAICScore() {
        LocalScoreSearchAlgorithm s = new LocalScoreSearchAlgorithm(this, this.m_Instances);
        return s.logScore(4);
    }

    public double measureEntropyScore() {
        LocalScoreSearchAlgorithm s = new LocalScoreSearchAlgorithm(this, this.m_Instances);
        return s.logScore(3);
    }

    @Override
    public double getMeasure(String measureName) {
        if (measureName.equals("measureExtraArcs")) {
            return this.measureExtraArcs();
        }
        if (measureName.equals("measureMissingArcs")) {
            return this.measureMissingArcs();
        }
        if (measureName.equals("measureReversedArcs")) {
            return this.measureReversedArcs();
        }
        if (measureName.equals("measureDivergence")) {
            return this.measureDivergence();
        }
        if (measureName.equals("measureBayesScore")) {
            return this.measureBayesScore();
        }
        if (measureName.equals("measureBDeuScore")) {
            return this.measureBDeuScore();
        }
        if (measureName.equals("measureMDLScore")) {
            return this.measureMDLScore();
        }
        if (measureName.equals("measureAICScore")) {
            return this.measureAICScore();
        }
        if (measureName.equals("measureEntropyScore")) {
            return this.measureEntropyScore();
        }
        return 0.0;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

