/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.sql;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;

public class ResultSetHelper {
    protected ResultSet m_ResultSet;
    protected boolean m_Initialized = false;
    protected int m_MaxRows = 0;
    protected int m_ColumnCount = 0;
    protected int m_RowCount = 0;
    protected String[] m_ColumnNames = null;
    protected boolean[] m_NumericColumns = null;
    protected Class[] m_ColumnClasses = null;

    public ResultSetHelper(ResultSet rs) {
        this(rs, 0);
    }

    public ResultSetHelper(ResultSet rs, int max) {
        this.m_ResultSet = rs;
        this.m_MaxRows = max;
    }

    protected void initialize() {
        if (this.m_Initialized) {
            return;
        }
        try {
            block17: {
                int i;
                ResultSetMetaData meta = this.m_ResultSet.getMetaData();
                this.m_ColumnNames = new String[meta.getColumnCount()];
                for (i = 1; i <= meta.getColumnCount(); ++i) {
                    this.m_ColumnNames[i - 1] = meta.getColumnLabel(i);
                }
                this.m_NumericColumns = new boolean[meta.getColumnCount()];
                for (i = 1; i <= meta.getColumnCount(); ++i) {
                    this.m_NumericColumns[i - 1] = ResultSetHelper.typeIsNumeric(meta.getColumnType(i));
                }
                this.m_ColumnClasses = new Class[meta.getColumnCount()];
                for (i = 1; i <= meta.getColumnCount(); ++i) {
                    try {
                        this.m_ColumnClasses[i - 1] = ResultSetHelper.typeToClass(meta.getColumnType(i));
                        continue;
                    }
                    catch (Exception ex) {
                        this.m_ColumnClasses[i - 1] = String.class;
                    }
                }
                this.m_ColumnCount = meta.getColumnCount();
                if (this.m_ResultSet.getType() == 1003) {
                    this.m_RowCount = -1;
                } else {
                    this.m_RowCount = 0;
                    this.m_ResultSet.first();
                    if (this.m_MaxRows > 0) {
                        try {
                            this.m_ResultSet.absolute(this.m_MaxRows);
                            this.m_RowCount = this.m_ResultSet.getRow();
                        }
                        catch (Exception ex) {}
                    } else {
                        this.m_ResultSet.last();
                        this.m_RowCount = this.m_ResultSet.getRow();
                    }
                    try {
                        if (this.m_RowCount != 0 || !this.m_ResultSet.first()) break block17;
                        this.m_RowCount = 1;
                        while (this.m_ResultSet.next()) {
                            ++this.m_RowCount;
                            if (this.m_ResultSet.getRow() != this.m_MaxRows) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            this.m_Initialized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ResultSet getResultSet() {
        return this.m_ResultSet;
    }

    public int getColumnCount() {
        this.initialize();
        return this.m_ColumnCount;
    }

    public int getRowCount() {
        this.initialize();
        return this.m_RowCount;
    }

    public String[] getColumnNames() {
        this.initialize();
        return this.m_ColumnNames;
    }

    public boolean[] getNumericColumns() {
        this.initialize();
        return this.m_NumericColumns;
    }

    public Class[] getColumnClasses() {
        this.initialize();
        return this.m_ColumnClasses;
    }

    public boolean hasMaxRows() {
        return this.m_MaxRows > 0;
    }

    public int getMaxRows() {
        return this.m_MaxRows;
    }

    public Object[][] getCells() {
        this.initialize();
        Vector<Object[]> result = new Vector<Object[]>();
        try {
            boolean proceed;
            int rowCount = this.getRowCount();
            if (rowCount == -1) {
                rowCount = this.getMaxRows();
                proceed = this.m_ResultSet.next();
            } else {
                proceed = this.m_ResultSet.first();
            }
            if (proceed) {
                int i = 0;
                while (true) {
                    Object[] row = new Object[this.getColumnCount()];
                    result.add(row);
                    for (int n = 0; n < this.getColumnCount(); ++n) {
                        try {
                            if (this.getColumnClasses()[n] == String.class) {
                                row[n] = this.m_ResultSet.getString(n + 1);
                                continue;
                            }
                            row[n] = this.m_ResultSet.getObject(n + 1);
                            continue;
                        }
                        catch (Exception e) {
                            row[n] = null;
                        }
                    }
                    if (i != rowCount - 1 && this.m_ResultSet.next()) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (Object[][])result.toArray((T[])new Object[result.size()][this.getColumnCount()]);
    }

    public static Class typeToClass(int type) {
        Class result;
        switch (type) {
            case -5: {
                result = Long.class;
                break;
            }
            case -2: {
                result = String.class;
                break;
            }
            case -7: {
                result = Boolean.class;
                break;
            }
            case 1: {
                result = Character.class;
                break;
            }
            case 91: {
                result = Date.class;
                break;
            }
            case 3: {
                result = Double.class;
                break;
            }
            case 8: {
                result = Double.class;
                break;
            }
            case 6: {
                result = Float.class;
                break;
            }
            case 4: {
                result = Integer.class;
                break;
            }
            case -4: {
                result = String.class;
                break;
            }
            case -1: {
                result = String.class;
                break;
            }
            case 0: {
                result = String.class;
                break;
            }
            case 2: {
                result = Double.class;
                break;
            }
            case 1111: {
                result = String.class;
                break;
            }
            case 7: {
                result = Double.class;
                break;
            }
            case 5: {
                result = Short.class;
                break;
            }
            case 92: {
                result = Time.class;
                break;
            }
            case 93: {
                result = Timestamp.class;
                break;
            }
            case -6: {
                result = Short.class;
                break;
            }
            case -3: {
                result = String.class;
                break;
            }
            case 12: {
                result = String.class;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public static boolean typeIsNumeric(int type) {
        boolean result;
        switch (type) {
            case -5: {
                result = true;
                break;
            }
            case -2: {
                result = false;
            }
            case -7: {
                result = false;
                break;
            }
            case 1: {
                result = false;
                break;
            }
            case 91: {
                result = false;
                break;
            }
            case 3: {
                result = true;
                break;
            }
            case 8: {
                result = true;
                break;
            }
            case 6: {
                result = true;
                break;
            }
            case 4: {
                result = true;
                break;
            }
            case -4: {
                result = false;
                break;
            }
            case -1: {
                result = false;
                break;
            }
            case 0: {
                result = false;
                break;
            }
            case 2: {
                result = true;
                break;
            }
            case 1111: {
                result = false;
                break;
            }
            case 7: {
                result = true;
                break;
            }
            case 5: {
                result = true;
                break;
            }
            case 92: {
                result = false;
                break;
            }
            case 93: {
                result = true;
                break;
            }
            case -6: {
                result = true;
                break;
            }
            case -3: {
                result = false;
                break;
            }
            case 12: {
                result = false;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }
}

