/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.gui.visualization.core.axis.Type;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.paintlet.AbstractProbabilityPaintlet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Arrays;

public class Logistic
extends AbstractProbabilityPaintlet {
    private static final long serialVersionUID = 1695496606711390657L;

    @Override
    public void setAxis() {
        this.m_AxisBottom = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        this.m_AxisLeft = this.getPanel().getPlot().getAxis(Axis.LEFT);
        this.m_AxisBottom.setType(Type.ABSOLUTE);
        this.m_AxisLeft.setType(Type.LOG_ABSOLUTE);
        this.m_AxisLeft.setNumberFormat("#.##");
    }

    public void performPaint(Graphics g) {
        if (this.m_Instances != null) {
            int i;
            if (this.m_AntiAliasingEnabled) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            double[] data = this.m_Instances.attributeToDoubleArray(this.m_Index);
            this.m_TransformedY = new double[data.length];
            Arrays.sort(data);
            for (i = 0; i < data.length; ++i) {
                double median = ((double)(i + 1) - 0.3) / ((double)data.length + 0.4);
                this.m_TransformedY[i] = median / (1.0 - median);
            }
            if (this.m_AxisBottom.getType().canHandle(data[0], data[data.length - 1])) {
                this.m_AxisBottom.setMinimum(data[0]);
                this.m_AxisBottom.setMaximum(data[data.length - 1]);
            } else {
                System.err.println("errors in plotting");
            }
            if (this.m_AxisLeft.getType().canHandle(this.m_TransformedY[0], this.m_TransformedY[this.m_TransformedY.length - 1])) {
                this.m_AxisLeft.setMinimum(this.m_TransformedY[0]);
                this.m_AxisLeft.setMaximum(this.m_TransformedY[this.m_TransformedY.length - 1]);
            } else {
                System.err.println("errors in plotting");
            }
            this.m_AxisBottom.setAxisName(this.m_Instances.attribute(this.m_Index).name());
            this.m_AxisLeft.setAxisName("Inverse Logistic");
            for (i = 0; i < data.length; ++i) {
                Graphics2D g2d = (Graphics2D)g;
                if (this.m_Fill) {
                    g2d.setColor(this.m_FillColor);
                    g2d.setStroke(new BasicStroke(0.0f));
                    g2d.fillOval(this.m_AxisBottom.valueToPos(data[i]) - this.m_Size / 2, this.m_AxisLeft.valueToPos(this.m_TransformedY[i]) - this.m_Size / 2, this.m_Size, this.m_Size);
                }
                g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
                g2d.setColor(this.m_Color);
                g2d.drawOval(this.m_AxisBottom.valueToPos(data[i]) - this.m_Size / 2, this.m_AxisLeft.valueToPos(this.m_TransformedY[i]) - this.m_Size / 2, this.m_Size, this.m_Size);
            }
            if (this.m_RegressionLine) {
                g.setColor(Color.BLACK);
                for (i = 0; i < data.length - 1; ++i) {
                    double prob1 = 1.0 / (1.0 + Math.exp(-data[i]));
                    double prob2 = 1.0 / (1.0 + Math.exp(-data[i + 1]));
                    double p1 = prob1 / (1.0 - prob1);
                    double p2 = prob2 / (1.0 - prob2);
                    g.drawLine(this.m_AxisBottom.valueToPos(data[i]), this.m_AxisLeft.valueToPos(p1), this.m_AxisBottom.valueToPos(data[i + 1]), this.m_AxisLeft.valueToPos(p2));
                }
            }
        }
    }

    public String globalInfo() {
        return "paints the transformed logistic distribution";
    }

    @Override
    public boolean hasFitLine() {
        return false;
    }
}

