/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.ima4;

import com.ibm.media.codec.audio.AudioCodec;
import com.ibm.media.codec.audio.ima4.IMA4;
import com.ibm.media.codec.audio.ima4.IMA4State;
import com.sun.media.controls.SilenceSuppressionAdapter;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class JavaDecoder
extends AudioCodec {
    private IMA4State ima4state;

    public JavaDecoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("ima4")};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR")};
        this.PLUGIN_NAME = "IMA4 Decoder";
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat af = (AudioFormat)in;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR", af.getSampleRate(), 16, af.getChannels(), 1, 1)};
        return this.supportedOutputFormats;
    }

    public void open() {
        this.ima4state = new IMA4State();
    }

    public void close() {
        this.ima4state = null;
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        int channels = this.outputFormat.getChannels();
        byte[] inData = (byte[])inputBuffer.getData();
        byte[] outData = this.validateByteArraySize(outputBuffer, inData.length * 4);
        int outLength = this.decodeJavaIMA4(inData, outData, inputBuffer.getLength(), outData.length, channels);
        this.updateOutput(outputBuffer, this.outputFormat, outLength, 0);
        return 0;
    }

    int decodeJavaIMA4(byte[] inData, byte[] outData, int lenIn, int lenOut, int nChannels) {
        switch (nChannels) {
            case 1: {
                return this.decodeIMA4mono(inData, outData, lenIn, lenOut, 32);
            }
            case 2: {
                return this.decodeIMA4stereo(inData, outData, lenIn, lenOut, 32);
            }
        }
        throw new RuntimeException("IMA4: Can only handle 1 or 2 channels\n");
    }

    private int decodeIMA4mono(byte[] inData, byte[] outData, int lenIn, int lenOut, int blockSize) {
        int inCount = 0;
        int outCount = 0;
        lenIn = lenIn / (blockSize + 2) * (blockSize + 2);
        while (inCount < lenIn) {
            int index;
            int state = inData[inCount++] << 8;
            if ((index = (state |= inData[inCount++] & 0xFF) & 0x7F) > 88) {
                index = 88;
            }
            this.ima4state.valprev = state & 0xFFFFFF80;
            this.ima4state.index = index;
            IMA4.decode(inData, inCount, outData, outCount, blockSize << 1, this.ima4state, 0);
            inCount += blockSize;
            outCount += blockSize << 2;
        }
        return outCount;
    }

    private int decodeIMA4stereo(byte[] inData, byte[] outData, int lenIn, int lenOut, int blockSize) {
        int inCount = 0;
        int outCount = 0;
        lenIn = lenIn / 2 / (blockSize + 2) * (blockSize + 2) * 2;
        while (inCount < lenIn) {
            int indexL;
            int stateL = inData[inCount++] << 8;
            if ((indexL = (stateL |= inData[inCount++] & 0xFF) & 0x7F) > 88) {
                indexL = 88;
            }
            this.ima4state.valprev = stateL & 0xFFFFFF80;
            this.ima4state.index = indexL;
            IMA4.decode(inData, inCount, outData, outCount, blockSize << 1, this.ima4state, 2);
            inCount += blockSize;
            int stateR = inData[inCount++] << 8;
            int indexR = (stateR |= inData[inCount++] & 0xFF) & 0x7F;
            if (indexR > 88) {
                indexR = 88;
            }
            this.ima4state.valprev = stateR & 0xFFFFFF80;
            this.ima4state.index = indexR;
            IMA4.decode(inData, inCount, outData, outCount + 2, blockSize << 1, this.ima4state, 2);
            inCount += blockSize;
            outCount += blockSize << 3;
        }
        return outCount;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new SilenceSuppressionAdapter(this, false, false);
        }
        return this.controls;
    }
}

