/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicPlugIn;
import com.sun.media.BasicTrackControl;
import com.sun.media.GraphInspector;
import com.sun.media.GraphNode;
import com.sun.media.Log;
import com.sun.media.codec.audio.mpa.DePacketizer;
import com.sun.media.codec.audio.mpa.Packetizer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.Codec;
import javax.media.Format;
import javax.media.PlugIn;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;

public class SimpleGraphBuilder {
    protected int STAGES = 4;
    protected Hashtable plugIns = new Hashtable(40);
    protected GraphNode[] targetPlugins = null;
    protected Vector targetPluginNames = null;
    protected int targetType = -1;
    int indent = 0;
    protected static GraphInspector inspector;
    static /* synthetic */ Class class$javax$media$Codec;
    static /* synthetic */ Class class$javax$media$Renderer;
    static /* synthetic */ Class class$javax$media$Multiplexer;
    static /* synthetic */ Class class$javax$media$PlugIn;

    public static void setGraphInspector(GraphInspector insp) {
        inspector = insp;
    }

    public void reset() {
        Enumeration enumeration = this.plugIns.elements();
        while (enumeration.hasMoreElements()) {
            GraphNode n2 = (GraphNode)enumeration.nextElement();
            n2.resetAttempted();
        }
    }

    boolean buildGraph(BasicTrackControl tc) {
        Log.comment("Input: " + tc.getOriginalFormat());
        Vector<GraphNode> candidates = new Vector<GraphNode>();
        GraphNode node = new GraphNode(null, null, tc.getOriginalFormat(), null, 0);
        this.indent = 1;
        Log.setIndent(this.indent);
        if (!this.setDefaultTargets(tc.getOriginalFormat())) {
            return false;
        }
        candidates.addElement(node);
        while ((node = this.buildGraph(candidates)) != null) {
            GraphNode failed = this.buildTrackFromGraph(tc, node);
            if (failed == null) {
                this.indent = 0;
                Log.setIndent(this.indent);
                return true;
            }
            this.removeFailure(candidates, failed, tc.getOriginalFormat());
        }
        this.indent = 0;
        Log.setIndent(this.indent);
        return false;
    }

    protected GraphNode buildTrackFromGraph(BasicTrackControl tc, GraphNode node) {
        return null;
    }

    GraphNode buildGraph(Format input) {
        Log.comment("Input: " + input);
        Vector<GraphNode> candidates = new Vector<GraphNode>();
        GraphNode node = new GraphNode(null, null, input, null, 0);
        this.indent = 1;
        Log.setIndent(this.indent);
        if (!this.setDefaultTargets(input)) {
            return null;
        }
        candidates.addElement(node);
        while ((node = this.buildGraph(candidates)) != null) {
            GraphNode failed = this.verifyGraph(node);
            if (failed == null) {
                this.indent = 0;
                Log.setIndent(this.indent);
                return node;
            }
            this.removeFailure(candidates, failed, input);
        }
        this.indent = 0;
        Log.setIndent(this.indent);
        return node;
    }

    GraphNode buildGraph(Vector candidates) {
        GraphNode node;
        while ((node = this.doBuildGraph(candidates)) == null) {
            if (candidates.isEmpty()) break;
        }
        return node;
    }

    GraphNode doBuildGraph(Vector candidates) {
        Format input;
        Format[] outs;
        if (candidates.isEmpty()) {
            return null;
        }
        GraphNode node = (GraphNode)candidates.firstElement();
        candidates.removeElementAt(0);
        if (!(node.input != null || node.plugin != null && node.plugin instanceof Codec)) {
            Log.error("Internal error: doBuildGraph");
            return null;
        }
        int oldIndent = this.indent;
        Log.setIndent(node.level + 1);
        if (node.plugin != null && SimpleGraphBuilder.verifyInput(node.plugin, node.input) == null) {
            return null;
        }
        GraphNode n2 = this.findTarget(node);
        if (n2 != null) {
            this.indent = oldIndent;
            Log.setIndent(this.indent);
            return n2;
        }
        if (node.level >= this.STAGES) {
            this.indent = oldIndent;
            Log.setIndent(this.indent);
            return null;
        }
        boolean mp3Pkt = false;
        if (node.plugin != null) {
            if (node.output != null) {
                outs = new Format[]{node.output};
            } else {
                outs = node.getSupportedOutputs(node.input);
                if (outs == null || outs.length == 0) {
                    this.indent = oldIndent;
                    Log.setIndent(this.indent);
                    return null;
                }
            }
            input = node.input;
            if (node.plugin instanceof Packetizer) {
                mp3Pkt = true;
            }
        } else {
            outs = new Format[]{node.input};
            input = null;
        }
        boolean foundSomething = false;
        int i2 = 0;
        while (i2 < outs.length) {
            block23: {
                Vector cnames;
                block24: {
                    block25: {
                        if (!node.custom && input != null && input.equals(outs[i2])) break block23;
                        if (node.plugin == null) break block24;
                        if (SimpleGraphBuilder.verifyOutput(node.plugin, outs[i2]) != null) break block25;
                        if (inspector != null && inspector.detailMode()) {
                            inspector.verifyOutputFailed(node.plugin, outs[i2]);
                        }
                        break block23;
                    }
                    if (inspector != null && !inspector.verify((Codec)node.plugin, node.input, outs[i2])) break block23;
                }
                if ((cnames = PlugInManager.getPlugInList(outs[i2], null, 2)) != null && cnames.size() != 0) {
                    int j2 = 0;
                    while (j2 < cnames.size()) {
                        GraphNode gn = SimpleGraphBuilder.getPlugInNode((String)cnames.elementAt(j2), 2, this.plugIns);
                        if (!(gn == null || mp3Pkt && gn.plugin instanceof DePacketizer || gn.checkAttempted(outs[i2]))) {
                            Format[] ins = gn.getSupportedInputs();
                            Format fmt = SimpleGraphBuilder.matches(outs[i2], ins, null, gn.plugin);
                            if (fmt == null) {
                                if (inspector != null && inspector.detailMode()) {
                                    inspector.verifyInputFailed(gn.plugin, outs[i2]);
                                }
                            } else if (inspector == null || !inspector.detailMode() || inspector.verify((Codec)gn.plugin, fmt, null)) {
                                n2 = new GraphNode(gn, fmt, node, node.level + 1);
                                candidates.addElement(n2);
                                foundSomething = true;
                            }
                        }
                        ++j2;
                    }
                }
            }
            ++i2;
        }
        this.indent = oldIndent;
        Log.setIndent(this.indent);
        return null;
    }

    GraphNode findTarget(GraphNode node) {
        GraphNode n2;
        Format[] outs;
        if (node.plugin == null) {
            outs = new Format[]{node.input};
        } else if (node.output != null) {
            outs = new Format[]{node.output};
        } else {
            outs = node.getSupportedOutputs(node.input);
            if (outs == null || outs.length == 0) {
                return null;
            }
        }
        if (this.targetPlugins != null && (n2 = this.verifyTargetPlugins(node, outs)) != null) {
            return n2;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    GraphNode verifyTargetPlugins(GraphNode node, Format[] outs) {
        i = 0;
        while (i < this.targetPlugins.length) {
            block7: {
                gn = this.targetPlugins[i];
                if (gn != null) ** GOTO lbl12
                name = (String)this.targetPluginNames.elementAt(i);
                if (name == null || SimpleGraphBuilder.matches(outs, base = PlugInManager.getSupportedInputFormats(name, this.targetType), null, null) == null) break block7;
                gn = SimpleGraphBuilder.getPlugInNode(name, this.targetType, this.plugIns);
                if (gn == null) {
                    this.targetPluginNames.setElementAt(null, i);
                } else {
                    this.targetPlugins[i] = gn;
lbl12:
                    // 2 sources

                    if ((fmt = SimpleGraphBuilder.matches(outs, gn.getSupportedInputs(), node.plugin, gn.plugin)) != null && (SimpleGraphBuilder.inspector == null || (node.plugin == null || SimpleGraphBuilder.inspector.verify((Codec)node.plugin, node.input, fmt)) && !((gn.type == -1 || gn.type == 2) && gn.plugin instanceof Codec != false ? SimpleGraphBuilder.inspector.verify((Codec)gn.plugin, fmt, null) == false : (gn.type == -1 || gn.type == 4) && gn.plugin instanceof Renderer != false && SimpleGraphBuilder.inspector.verify((Renderer)gn.plugin, fmt) == false))) {
                        return new GraphNode(gn, fmt, node, node.level + 1);
                    }
                }
            }
            ++i;
        }
        return null;
    }

    boolean setDefaultTargets(Format in) {
        return this.setDefaultTargetRenderer(in);
    }

    boolean setDefaultTargetRenderer(Format in) {
        this.targetPluginNames = in instanceof AudioFormat ? PlugInManager.getPlugInList(new AudioFormat(null, -1.0, -1, -1, -1, -1, -1, -1.0, null), null, 4) : (in instanceof VideoFormat ? PlugInManager.getPlugInList(new VideoFormat(null, null, -1, null, -1.0f), null, 4) : PlugInManager.getPlugInList(null, null, 4));
        if (this.targetPluginNames == null || this.targetPluginNames.size() == 0) {
            return false;
        }
        this.targetPlugins = new GraphNode[this.targetPluginNames.size()];
        this.targetType = 4;
        return true;
    }

    protected GraphNode verifyGraph(GraphNode node) {
        Format prevFormat = null;
        Vector<PlugIn> used = new Vector<PlugIn>(5);
        if (node.plugin == null) {
            return null;
        }
        Log.setIndent(this.indent++);
        while (node != null && node.plugin != null) {
            if (used.contains(node.plugin)) {
                PlugIn p;
                if (node.cname == null || (p = SimpleGraphBuilder.createPlugIn(node.cname, -1)) == null) {
                    Log.write("Failed to instantiate " + node.cname);
                    return node;
                }
                node.plugin = p;
            } else {
                used.addElement(node.plugin);
            }
            if ((node.type == -1 || node.type == 4) && node.plugin instanceof Renderer) {
                ((Renderer)node.plugin).setInputFormat(node.input);
            } else if ((node.type == -1 || node.type == 2) && node.plugin instanceof Codec) {
                ((Codec)node.plugin).setInputFormat(node.input);
                if (prevFormat != null) {
                    ((Codec)node.plugin).setOutputFormat(prevFormat);
                } else if (node.output != null) {
                    ((Codec)node.plugin).setOutputFormat(node.output);
                }
            }
            if (node.type != -1 && node.type != 4 || !(node.plugin instanceof Renderer)) {
                try {
                    node.plugin.open();
                }
                catch (Exception e2) {
                    Log.warning("Failed to open: " + node.plugin);
                    node.failed = true;
                    return node;
                }
            }
            prevFormat = node.input;
            node = node.prev;
        }
        Log.setIndent(this.indent--);
        return null;
    }

    void removeFailure(Vector candidates, GraphNode failed, Format input) {
        if (failed.plugin == null) {
            return;
        }
        Log.comment("Failed to open plugin " + failed.plugin + ". Will re-build the graph allover again");
        candidates.removeAllElements();
        GraphNode hsyn = new GraphNode(null, null, input, null, 0);
        this.indent = 1;
        Log.setIndent(this.indent);
        candidates.addElement(hsyn);
        failed.failed = true;
        this.plugIns.put(failed.plugin.getClass().getName(), failed);
        Enumeration e2 = this.plugIns.keys();
        while (e2.hasMoreElements()) {
            String ss = (String)e2.nextElement();
            GraphNode nn = (GraphNode)this.plugIns.get(ss);
            if (nn.failed) continue;
            this.plugIns.remove(ss);
        }
    }

    public static GraphNode getPlugInNode(String name, int type, Hashtable plugIns) {
        GraphNode gn = null;
        Object obj = null;
        boolean add = false;
        if (plugIns == null || (gn = (GraphNode)plugIns.get(name)) == null) {
            PlugIn p = SimpleGraphBuilder.createPlugIn(name, type);
            gn = new GraphNode(name, p, null, null, 0);
            if (plugIns != null) {
                plugIns.put(name, gn);
            }
            if (p == null) {
                gn.failed = true;
                return null;
            }
            return gn;
        }
        if (gn.failed) {
            return null;
        }
        if (SimpleGraphBuilder.verifyClass(gn.plugin, type)) {
            return gn;
        }
        return null;
    }

    public static Codec findCodec(Format in, Format out, Format[] selectedIn, Format[] selectedOut) {
        Vector cnames = PlugInManager.getPlugInList(in, out, 2);
        if (cnames == null) {
            return null;
        }
        Codec c2 = null;
        int i2 = 0;
        while (i2 < cnames.size()) {
            block9: {
                Format[] fmts;
                Format matched;
                c2 = (Codec)SimpleGraphBuilder.createPlugIn((String)cnames.elementAt(i2), 2);
                if (c2 == null || (matched = SimpleGraphBuilder.matches(in, fmts = c2.getSupportedInputFormats(), null, (PlugIn)c2)) == null) break block9;
                if (selectedIn != null && selectedIn.length > 0) {
                    selectedIn[0] = matched;
                }
                if ((fmts = c2.getSupportedOutputFormats(matched)) == null || fmts.length == 0) break block9;
                boolean success = false;
                int j2 = 0;
                while (j2 < fmts.length) {
                    block12: {
                        block11: {
                            block10: {
                                if (out == null) break block10;
                                if (out.matches(fmts[j2]) && (matched = out.intersects(fmts[j2])) != null) break block11;
                                break block12;
                            }
                            matched = fmts[j2];
                        }
                        if (c2.setOutputFormat(matched) != null) {
                            success = true;
                            break;
                        }
                    }
                    ++j2;
                }
                if (success) {
                    try {
                        c2.open();
                    }
                    catch (ResourceUnavailableException e2) {
                        // empty catch block
                    }
                    if (selectedOut != null && selectedOut.length > 0) {
                        selectedOut[0] = matched;
                    }
                    return c2;
                }
            }
            ++i2;
        }
        return null;
    }

    public static Renderer findRenderer(Format in) {
        Vector names = PlugInManager.getPlugInList(in, null, 4);
        if (names == null) {
            return null;
        }
        Renderer r = null;
        int i2 = 0;
        while (i2 < names.size()) {
            Format[] fmts;
            Format matched;
            r = (Renderer)SimpleGraphBuilder.createPlugIn((String)names.elementAt(i2), 4);
            if (r != null && (matched = SimpleGraphBuilder.matches(in, fmts = r.getSupportedInputFormats(), null, (PlugIn)r)) != null) {
                try {
                    r.open();
                }
                catch (ResourceUnavailableException e2) {
                    // empty catch block
                }
                return r;
            }
            ++i2;
        }
        return null;
    }

    public static Vector findRenderingChain(Format in, Vector formats) {
        SimpleGraphBuilder gb = new SimpleGraphBuilder();
        GraphNode n2 = gb.buildGraph(in);
        if (n2 == null) {
            return null;
        }
        Vector<PlugIn> list = new Vector<PlugIn>(10);
        while (n2 != null && n2.plugin != null) {
            list.addElement(n2.plugin);
            if (formats != null) {
                formats.addElement(n2.input);
            }
            n2 = n2.prev;
        }
        return list;
    }

    public static PlugIn createPlugIn(String name, int type) {
        Object obj;
        try {
            Class cls = BasicPlugIn.getClassForName(name);
            obj = cls.newInstance();
        }
        catch (Exception e2) {
            return null;
        }
        catch (Error e3) {
            return null;
        }
        if (SimpleGraphBuilder.verifyClass(obj, type)) {
            return (PlugIn)obj;
        }
        return null;
    }

    public static boolean verifyClass(Object obj, int type) {
        Class cls;
        switch (type) {
            case 2: {
                cls = class$javax$media$Codec == null ? (class$javax$media$Codec = SimpleGraphBuilder.class$("javax.media.Codec")) : class$javax$media$Codec;
                break;
            }
            case 4: {
                cls = class$javax$media$Renderer == null ? (class$javax$media$Renderer = SimpleGraphBuilder.class$("javax.media.Renderer")) : class$javax$media$Renderer;
                break;
            }
            case 5: {
                cls = class$javax$media$Multiplexer == null ? (class$javax$media$Multiplexer = SimpleGraphBuilder.class$("javax.media.Multiplexer")) : class$javax$media$Multiplexer;
                break;
            }
            default: {
                Class clazz = cls = class$javax$media$PlugIn == null ? (class$javax$media$PlugIn = SimpleGraphBuilder.class$("javax.media.PlugIn")) : class$javax$media$PlugIn;
            }
        }
        return cls.isInstance(obj);
    }

    public static Format matches(Format[] outs, Format[] ins, PlugIn up, PlugIn down) {
        if (outs == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < outs.length) {
            Format fmt = SimpleGraphBuilder.matches(outs[i2], ins, up, down);
            if (fmt != null) {
                return fmt;
            }
            ++i2;
        }
        return null;
    }

    public static Format matches(Format out, Format[] ins, PlugIn up, PlugIn down) {
        if (out == null || ins == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < ins.length) {
            Format fmt;
            if (ins[i2] != null && ins[i2].getClass().isAssignableFrom(out.getClass()) && out.matches(ins[i2]) && (fmt = out.intersects(ins[i2])) != null && (down == null || (fmt = SimpleGraphBuilder.verifyInput(down, fmt)) != null)) {
                Format refined = fmt;
                if (!(up != null && (refined = SimpleGraphBuilder.verifyOutput(up, fmt)) == null || down != null && refined != fmt && SimpleGraphBuilder.verifyInput(down, refined) == null)) {
                    return refined;
                }
            }
            ++i2;
        }
        return null;
    }

    public static Format matches(Format[] outs, Format in, PlugIn up, PlugIn down) {
        Format[] ins = new Format[]{in};
        return SimpleGraphBuilder.matches(outs, ins, up, down);
    }

    public static Format verifyInput(PlugIn p, Format in) {
        if (p instanceof Codec) {
            return ((Codec)p).setInputFormat(in);
        }
        if (p instanceof Renderer) {
            return ((Renderer)p).setInputFormat(in);
        }
        return null;
    }

    public static Format verifyOutput(PlugIn p, Format out) {
        if (p instanceof Codec) {
            return ((Codec)p).setOutputFormat(out);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

