/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTCPCompoundPacket;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketConsumer;
import com.sun.media.rtp.util.PacketFilter;
import com.sun.media.rtp.util.RTPPacketSender;
import com.sun.media.rtp.util.UDPPacket;
import com.sun.media.rtp.util.UDPPacketSender;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.media.rtp.SessionAddress;

public class RTCPRawSender
extends PacketFilter {
    private InetAddress destaddr;
    private int destport;

    public String filtername() {
        return "RTCP Raw Packet Sender";
    }

    public RTCPRawSender(int port, String address) throws UnknownHostException, IOException {
        this.destaddr = InetAddress.getByName(address);
        this.destport = port | 1;
        this.destAddressList = null;
    }

    public RTCPRawSender(int port, String address, UDPPacketSender sender) throws UnknownHostException, IOException {
        this(port, address);
        this.setConsumer(sender);
        this.destAddressList = null;
    }

    public RTCPRawSender(RTPPacketSender sender) {
        this.setConsumer(sender);
    }

    public void addDestAddr(InetAddress newaddr) {
        int i2 = 0;
        if (this.destAddressList == null) {
            this.destAddressList = new Vector();
            this.destAddressList.addElement(this.destaddr);
        }
        i2 = 0;
        while (i2 < this.destAddressList.size()) {
            InetAddress curraddr = (InetAddress)this.destAddressList.elementAt(i2);
            if (curraddr.equals(newaddr)) break;
            ++i2;
        }
        if (i2 == this.destAddressList.size()) {
            this.destAddressList.addElement(newaddr);
        }
    }

    public InetAddress getRemoteAddr() {
        return this.destaddr;
    }

    public Packet handlePacket(Packet p, SessionAddress sessionAddress) {
        this.assemble((RTCPCompoundPacket)p);
        PacketConsumer consumer = this.getConsumer();
        if (consumer instanceof RTPPacketSender) {
            return p;
        }
        UDPPacket udpp = new UDPPacket();
        udpp.received = false;
        udpp.data = p.data;
        udpp.offset = p.offset;
        udpp.length = p.length;
        udpp.remoteAddress = sessionAddress.getControlAddress();
        udpp.remotePort = sessionAddress.getControlPort();
        return udpp;
    }

    public Packet handlePacket(Packet p, int index) {
        this.assemble((RTCPCompoundPacket)p);
        UDPPacket udpp = new UDPPacket();
        udpp.received = false;
        udpp.data = p.data;
        udpp.offset = p.offset;
        udpp.length = p.length;
        udpp.remoteAddress = (InetAddress)this.destAddressList.elementAt(index);
        udpp.remotePort = this.destport;
        return udpp;
    }

    public Packet handlePacket(Packet p) {
        this.assemble((RTCPCompoundPacket)p);
        PacketConsumer consumer = this.getConsumer();
        if (consumer instanceof RTPPacketSender) {
            return p;
        }
        UDPPacket udpp = new UDPPacket();
        udpp.received = false;
        udpp.data = p.data;
        udpp.offset = p.offset;
        udpp.length = p.length;
        udpp.remoteAddress = this.destaddr;
        udpp.remotePort = this.destport;
        return udpp;
    }

    public void assemble(RTCPCompoundPacket p) {
        int len = p.calcLength();
        p.assemble(len, false);
    }

    public void setDestAddresses(Vector destAddresses) {
        this.destAddressList = destAddresses;
    }
}

