/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtsp.protocol;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Vector;

public class Parser {
    private Vector buffer;

    public Parser() {
        this.init();
    }

    public int readChar(ByteArrayInputStream bin) {
        int ch;
        if (this.buffer.size() > 0) {
            ch = (Integer)this.buffer.elementAt(0);
            this.buffer.removeElementAt(0);
        } else {
            ch = bin.read();
        }
        return ch;
    }

    public String getToken(ByteArrayInputStream bin) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.skipWhitespace(bin);
        if (bin.available() > 0) {
            int ch = this.readChar(bin);
            while (ch != 32 && ch != 10 && ch != 13 && ch != -1) {
                bout.write(ch);
                ch = this.readChar(bin);
            }
            this.ungetChar(ch);
        }
        String token = new String(bout.toByteArray());
        return token;
    }

    public void ungetChar(int ch) {
        this.buffer.insertElementAt(new Integer(ch), 0);
    }

    public String getLine(ByteArrayInputStream bin) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int ch = this.readChar(bin);
        while (ch != 10 && ch != 13 && ch != -1) {
            bout.write(ch);
            ch = this.readChar(bin);
        }
        ch = this.readChar(bin);
        if (ch != 10) {
            this.ungetChar(ch);
        }
        String line = new String(bout.toByteArray());
        return line;
    }

    public String getStringToken(ByteArrayInputStream bin) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.skipWhitespace(bin);
        int ch = this.readChar(bin);
        while (ch != 10 && ch != 13 && ch != -1) {
            bout.write(ch);
            ch = this.readChar(bin);
        }
        String token = new String(bout.toByteArray());
        return token;
    }

    public byte[] getContent(ByteArrayInputStream bin) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.skipWhitespace(bin);
        int ch = this.readChar(bin);
        while (ch != -1) {
            bout.write(ch);
            ch = this.readChar(bin);
        }
        return bout.toByteArray();
    }

    private void skipWhitespace(ByteArrayInputStream bin) {
        int ch = this.readChar(bin);
        while (ch == 32 || ch == 10 || ch == 13) {
            ch = this.readChar(bin);
        }
        this.ungetChar(ch);
    }

    private void init() {
        this.buffer = new Vector();
    }
}

