/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.lang.reflect.Array;
import java.util.List;
import ognl.ASTConst;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlOps;
import ognl.OgnlParser;
import ognl.OgnlRuntime;
import ognl.SimpleNode;
import ognl.TypeConverter;

class ASTCtor
extends SimpleNode {
    private String className;
    private boolean isArray;

    public ASTCtor(int id) {
        super(id);
    }

    public ASTCtor(OgnlParser p, int id) {
        super(p, id);
    }

    void setClassName(String className) {
        this.className = className;
    }

    void setArray(boolean value) {
        this.isArray = value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getValueBody(OgnlContext context, Object source) throws OgnlException {
        Object root = context.getRoot();
        int count = this.jjtGetNumChildren();
        Object[] args = OgnlRuntime.getObjectArrayPool().create(count);
        try {
            Object result;
            block12: {
                int i = 0;
                while (true) {
                    if (i >= count) {
                        if (!this.isArray) break;
                        if (args.length != 1) throw new OgnlException("only expect array size or fixed initializer list");
                        try {
                            int size;
                            Class componentClass = OgnlRuntime.classForName(context, this.className);
                            List sourceList = null;
                            if (args[0] instanceof List) {
                                sourceList = (List)args[0];
                                size = sourceList.size();
                            } else {
                                size = (int)OgnlOps.longValue(args[0]);
                            }
                            result = Array.newInstance(componentClass, size);
                            if (sourceList != null) {
                                TypeConverter converter = context.getTypeConverter();
                                int i2 = 0;
                                int icount = sourceList.size();
                                while (i2 < icount) {
                                    Object o = sourceList.get(i2);
                                    if (o == null || componentClass.isInstance(o)) {
                                        Array.set(result, i2, o);
                                    } else {
                                        Array.set(result, i2, converter.convertValue(context, null, null, null, o, componentClass));
                                    }
                                    ++i2;
                                }
                            }
                            break block12;
                        }
                        catch (ClassNotFoundException ex) {
                            throw new OgnlException("array component class '" + this.className + "' not found", ex);
                        }
                    }
                    args[i] = this.children[i].getValue(context, root);
                    ++i;
                }
                result = OgnlRuntime.callConstructor(context, this.className, args);
            }
            Object object = result;
            Object var14_17 = null;
            OgnlRuntime.getObjectArrayPool().recycle(args);
            return object;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            OgnlRuntime.getObjectArrayPool().recycle(args);
            throw throwable;
        }
    }

    public String toString() {
        String result = "new " + this.className;
        if (this.isArray) {
            result = this.children[0] instanceof ASTConst ? String.valueOf(result) + "[" + this.children[0] + "]" : String.valueOf(result) + "[] " + this.children[0];
        } else {
            result = String.valueOf(result) + "(";
            if (this.children != null && this.children.length > 0) {
                int i = 0;
                while (i < this.children.length) {
                    if (i > 0) {
                        result = String.valueOf(result) + ", ";
                    }
                    result = String.valueOf(result) + this.children[i];
                    ++i;
                }
            }
            result = String.valueOf(result) + ")";
        }
        return result;
    }
}

