/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.text;

import java.awt.Color;
import org.jdom.Element;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.dom.StyleProperties;
import org.jopendocument.dom.StyleStyle;

public class TextStyle
extends StyleStyle {
    public static final String STYLE_FAMILY = "text";
    private SyleTextProperties textProps = null;

    public TextStyle(ODPackage oDPackage, Element element) {
        super(oDPackage, element);
    }

    public final SyleTextProperties getTextProperties() {
        if (this.textProps == null) {
            this.textProps = new SyleTextProperties(this);
        }
        return this.textProps;
    }

    public final Color getColor() {
        return this.getTextProperties().getColor();
    }

    public final Color getBackgroundColor() {
        return this.getTextProperties().getBackgroundColor();
    }

    public static class SyleTextProperties
    extends StyleProperties {
        public SyleTextProperties(StyleStyle styleStyle) {
            super(styleStyle, TextStyle.STYLE_FAMILY);
        }

        public final Color getColor() {
            return OOUtils.decodeRGB(this.getElement().getAttributeValue("color", this.getNS("fo")));
        }

        public final void setColor(Color color) {
            this.getElement().setAttribute("color", OOUtils.encodeRGB(color), this.getNS("fo"));
        }

        public final String getFontName() {
            return this.getElement().getAttributeValue("font-name", this.getElement().getNamespace("style"));
        }

        public final String getLanguage() {
            return this.getElement().getAttributeValue("language", this.getNS("fo"));
        }

        public final String getCountry() {
            return this.getElement().getAttributeValue("country", this.getNS("fo"));
        }

        public final String getWeight() {
            return this.getElement().getAttributeValue("font-weight", this.getNS("fo"));
        }
    }
}

