/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import twitter4j.AccountSettings;
import twitter4j.AccountTotals;
import twitter4j.Category;
import twitter4j.DirectMessage;
import twitter4j.Friendship;
import twitter4j.GeoLocation;
import twitter4j.GeoQuery;
import twitter4j.IDs;
import twitter4j.Location;
import twitter4j.PagableResponseList;
import twitter4j.Paging;
import twitter4j.Place;
import twitter4j.ProfileImage;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.RateLimitStatus;
import twitter4j.RateLimitStatusListener;
import twitter4j.RelatedResults;
import twitter4j.Relationship;
import twitter4j.ResponseList;
import twitter4j.SimilarPlaces;
import twitter4j.Status;
import twitter4j.StatusUpdate;
import twitter4j.Trends;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.TwitterListener;
import twitter4j.TwitterMethod;
import twitter4j.TwitterOAuthSupportBase;
import twitter4j.TwitterStream;
import twitter4j.User;
import twitter4j.UserList;
import twitter4j.api.AccountMethodsAsync;
import twitter4j.api.BlockMethodsAsync;
import twitter4j.api.DirectMessageMethodsAsync;
import twitter4j.api.FavoriteMethodsAsync;
import twitter4j.api.FriendsFollowersMethodsAsync;
import twitter4j.api.FriendshipMethodsAsync;
import twitter4j.api.GeoMethodsAsync;
import twitter4j.api.HelpMethodsAsync;
import twitter4j.api.LegalResourcesAsync;
import twitter4j.api.ListMembersMethodsAsync;
import twitter4j.api.ListMethodsAsync;
import twitter4j.api.ListSubscribersMethodsAsync;
import twitter4j.api.LocalTrendsMethodsAsync;
import twitter4j.api.NewTwitterMethodsAsync;
import twitter4j.api.NotificationMethodsAsync;
import twitter4j.api.SavedSearchesMethodsAsync;
import twitter4j.api.SearchMethodsAsync;
import twitter4j.api.SpamReportingMethodsAsync;
import twitter4j.api.StatusMethodsAsync;
import twitter4j.api.TimelineMethodsAsync;
import twitter4j.api.TrendsMethodsAsync;
import twitter4j.api.UserMethodsAsync;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;
import twitter4j.http.AccessToken;
import twitter4j.http.Authorization;
import twitter4j.http.RequestToken;
import twitter4j.internal.async.Dispatcher;
import twitter4j.internal.async.DispatcherFactory;
import twitter4j.internal.http.HttpResponseEvent;

public class AsyncTwitter
extends TwitterOAuthSupportBase
implements Serializable,
SearchMethodsAsync,
TrendsMethodsAsync,
TimelineMethodsAsync,
StatusMethodsAsync,
UserMethodsAsync,
ListMethodsAsync,
ListMembersMethodsAsync,
ListSubscribersMethodsAsync,
DirectMessageMethodsAsync,
FriendshipMethodsAsync,
FriendsFollowersMethodsAsync,
AccountMethodsAsync,
FavoriteMethodsAsync,
NotificationMethodsAsync,
BlockMethodsAsync,
SpamReportingMethodsAsync,
SavedSearchesMethodsAsync,
LocalTrendsMethodsAsync,
GeoMethodsAsync,
LegalResourcesAsync,
NewTwitterMethodsAsync,
HelpMethodsAsync {
    private static final long serialVersionUID = -2008667933225051907L;
    private final Twitter twitter;
    private final List<TwitterListener> listeners = new ArrayList<TwitterListener>();
    private static transient Dispatcher dispatcher;

    public AsyncTwitter(String screenName, String password, TwitterListener listener) {
        super(ConfigurationContext.getInstance(), screenName, password);
        this.twitter = new TwitterFactory(ConfigurationContext.getInstance()).getInstance(screenName, password);
        this.addListener(listener);
    }

    AsyncTwitter(Configuration conf, Authorization auth) {
        super(conf, auth);
        this.twitter = new TwitterFactory(conf).getInstance(auth);
    }

    public void addListener(TwitterListener listener) {
        this.listeners.add(listener);
    }

    public String getScreenName() throws TwitterException, IllegalStateException {
        return this.twitter.getScreenName();
    }

    public int getId() throws TwitterException, IllegalStateException {
        return this.twitter.getId();
    }

    public void search(final Query query) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SEARCH, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                QueryResult result = AsyncTwitter.this.twitter.search(query);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.searched(result);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getTrends() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.TRENDS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Trends trends = AsyncTwitter.this.twitter.getTrends();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotTrends(trends);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getCurrentTrends() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CURRENT_TRENDS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Trends trends = AsyncTwitter.this.twitter.getCurrentTrends();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotCurrentTrends(trends);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getCurrentTrends(final boolean excludeHashTags) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CURRENT_TRENDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Trends trends = AsyncTwitter.this.twitter.getCurrentTrends(excludeHashTags);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotCurrentTrends(trends);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getDailyTrends() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DAILY_TRENDS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                List<Trends> trendsList = AsyncTwitter.this.twitter.getDailyTrends();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotDailyTrends(trendsList);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getDailyTrends(final Date date, final boolean excludeHashTags) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DAILY_TRENDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                List<Trends> trendsList = AsyncTwitter.this.twitter.getDailyTrends(date, excludeHashTags);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotDailyTrends(trendsList);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getWeeklyTrends() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.WEEKLY_TRENDS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                List<Trends> trendsList = AsyncTwitter.this.twitter.getWeeklyTrends();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotWeeklyTrends(trendsList);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getWeeklyTrends(final Date date, final boolean excludeHashTags) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.WEEKLY_TRENDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                List<Trends> trendsList = AsyncTwitter.this.twitter.getWeeklyTrends(date, excludeHashTags);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotWeeklyTrends(trendsList);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getPublicTimeline() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.PUBLIC_TIMELINE, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getPublicTimeline();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotPublicTimeline(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getHomeTimeline() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.HOME_TIMELINE, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getHomeTimeline();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotHomeTimeline(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getHomeTimeline(final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.HOME_TIMELINE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getHomeTimeline(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotHomeTimeline(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFriendsTimeline() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_TIMELINE, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getFriendsTimeline();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsTimeline(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFriendsTimeline(final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_TIMELINE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getFriendsTimeline(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsTimeline(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserTimeline(final String screenName, final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_TIMELINE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getUserTimeline(screenName, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserTimeline(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserTimeline(final int userId, final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_TIMELINE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getUserTimeline(userId, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserTimeline(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserTimeline(final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_TIMELINE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getUserTimeline(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserTimeline(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserTimeline(String screenName) {
        this.getUserTimeline(screenName, new Paging());
    }

    public void getUserTimeline(int userId) {
        this.getUserTimeline(userId, new Paging());
    }

    public void getUserTimeline() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_TIMELINE, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getUserTimeline();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserTimeline(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getMentions() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.MENTIONS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getMentions();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotMentions(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getMentions(final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.MENTIONS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getMentions(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotMentions(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedByMe() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_BY_ME, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getRetweetedByMe();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedByMe(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedByMe(final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_BY_ME, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getRetweetedByMe(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedByMe(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedToMe() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_TO_ME, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getRetweetedToMe();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedToMe(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedToMe(final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_TO_ME, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getRetweetedToMe(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedToMe(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetsOfMe() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETS_OF_ME, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getRetweetsOfMe();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetsOfMe(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetsOfMe(final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETS_OF_ME, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getRetweetsOfMe(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetsOfMe(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedByUser(final String screenName, final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_BY_USER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getRetweetedByUser(screenName, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedByUser(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedByUser(final int userId, final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_BY_USER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getRetweetedByUser(userId, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedByUser(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedToUser(final String screenName, final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_TO_USER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getRetweetedToUser(screenName, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedToUser(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedToUser(final int userId, final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_TO_USER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getRetweetedToUser(userId, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedToUser(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void showStatus(final long id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SHOW_STATUS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitter.this.twitter.showStatus(id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotShowStatus(status);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateStatus(final String statusText) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_STATUS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitter.this.twitter.updateStatus(statusText);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedStatus(status);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateStatus(final String statusText, final GeoLocation location) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_STATUS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitter.this.twitter.updateStatus(statusText, location);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedStatus(status);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateStatus(final String statusText, final long inReplyToStatusId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_STATUS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitter.this.twitter.updateStatus(statusText, inReplyToStatusId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedStatus(status);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateStatus(final String statusText, final long inReplyToStatusId, final GeoLocation location) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_STATUS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitter.this.twitter.updateStatus(statusText, inReplyToStatusId, location);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedStatus(status);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateStatus(final StatusUpdate latestStatus) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_STATUS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitter.this.twitter.updateStatus(latestStatus);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedStatus(status);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void destroyStatus(final long statusId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_STATUS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitter.this.twitter.destroyStatus(statusId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedStatus(status);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void retweetStatus(final long statusId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEET_STATUS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitter.this.twitter.retweetStatus(statusId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.retweetedStatus(status);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweets(final long statusId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getRetweets(statusId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweets(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedBy(final long statusId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_BY, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<User> users = AsyncTwitter.this.twitter.getRetweetedBy(statusId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedBy(users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedBy(final long statusId, final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_BY, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<User> users = AsyncTwitter.this.twitter.getRetweetedBy(statusId, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedBy(users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedByIDs(final long statusId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_BY_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitter.this.twitter.getRetweetedByIDs(statusId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedByIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedByIDs(final long statusId, final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_BY_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitter.this.twitter.getRetweetedByIDs(statusId, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedByIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void showUser(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SHOW_USER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.showUser(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserDetail(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void showUser(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SHOW_USER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.showUser(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserDetail(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void lookupUsers(final String[] screenNames) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.LOOKUP_USERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<User> users = AsyncTwitter.this.twitter.lookupUsers(screenNames);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.lookedupUsers(users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void lookupUsers(final int[] ids) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.LOOKUP_USERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<User> users = AsyncTwitter.this.twitter.lookupUsers(ids);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.lookedupUsers(users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void searchUsers(final String query, final int page) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SEARCH_USERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<User> users = AsyncTwitter.this.twitter.searchUsers(query, page);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.searchedUser(users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getSuggestedUserCategories() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SUGGESTED_USER_CATEGORIES, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Category> categories = AsyncTwitter.this.twitter.getSuggestedUserCategories();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotSuggestedUserCategories(categories);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserSuggestions(final String categorySlug) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_SUGGESTIONS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<User> users = AsyncTwitter.this.twitter.getUserSuggestions(categorySlug);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserSuggestions(users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getMemberSuggestions(final String categorySlug) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.MEMBER_SUGGESTIONS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<User> users = AsyncTwitter.this.twitter.getMemberSuggestions(categorySlug);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotMemberSuggestions(users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getProfileImage(final String screenName, final ProfileImage.ImageSize size) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.PROFILE_IMAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ProfileImage profileImage = AsyncTwitter.this.twitter.getProfileImage(screenName, size);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotProfileImage(profileImage);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getAccountTotals() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.ACCOUNT_TOTALS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                AccountTotals accountTotals = AsyncTwitter.this.twitter.getAccountTotals();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotAccountTotals(accountTotals);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getAccountSettings() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.ACCOUNT_SETTINGS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                AccountSettings accountSettings = AsyncTwitter.this.twitter.getAccountSettings();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotAccountSettings(accountSettings);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFriendsStatuses() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_STATUSES, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList<User> users = AsyncTwitter.this.twitter.getFriendsStatuses();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsStatuses(users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFriendsStatuses(final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_STATUSES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList<User> users = AsyncTwitter.this.twitter.getFriendsStatuses(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsStatuses(users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFriendsStatuses(String screenName) {
        this.getFriendsStatuses(screenName, -1L);
    }

    public void getFriendsStatuses(int userId) {
        this.getFriendsStatuses(userId, -1L);
    }

    public void getFriendsStatuses(final String screenName, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_STATUSES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList<User> users = AsyncTwitter.this.twitter.getFriendsStatuses(screenName, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsStatuses(users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFriendsStatuses(final int userId, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_STATUSES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList<User> users = AsyncTwitter.this.twitter.getFriendsStatuses(userId, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsStatuses(users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFollowersStatuses() {
        this.getFollowersStatuses(-1L);
    }

    public void getFollowersStatuses(final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_STATUSES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList<User> users = AsyncTwitter.this.twitter.getFollowersStatuses(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFollowersStatuses(users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFollowersStatuses(String screenName) {
        this.getFollowersStatuses(screenName, -1L);
    }

    public void getFollowersStatuses(int userId) {
        this.getFollowersStatuses(userId, -1L);
    }

    public void getFollowersStatuses(final String screenName, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_STATUSES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList<User> users = AsyncTwitter.this.twitter.getFollowersStatuses(screenName, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFollowersStatuses(users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFollowersStatuses(final int userId, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_STATUSES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList<User> users = AsyncTwitter.this.twitter.getFollowersStatuses(userId, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFollowersStatuses(users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void createUserList(final String listName, final boolean isPublicList, final String description) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_USER_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitter.this.twitter.createUserList(listName, isPublicList, description);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdUserList(list);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateUserList(final int listId, final String newListName, final boolean isPublicList, final String newDescription) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_USER_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitter.this.twitter.updateUserList(listId, newListName, isPublicList, newDescription);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedUserList(list);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserLists(final String listOwnerScreenName, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_LISTS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList<UserList> lists = AsyncTwitter.this.twitter.getUserLists(listOwnerScreenName, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserLists(lists);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void showUserList(final String listOwnerScreenName, final int id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_USER_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitter.this.twitter.showUserList(listOwnerScreenName, id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotShowUserList(list);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void destroyUserList(final int listId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_USER_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitter.this.twitter.destroyUserList(listId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedUserList(list);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserListStatuses(final String listOwnerScreenName, final int id, final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_LIST_STATUSES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getUserListStatuses(listOwnerScreenName, id, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListStatuses(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserListStatuses(final int listOwnerId, final int id, final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_LIST_STATUSES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getUserListStatuses(listOwnerId, id, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListStatuses(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserListMemberships(final String listMemberScreenName, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_LIST_MEMBERSHIPS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList<UserList> lists = AsyncTwitter.this.twitter.getUserListMemberships(listMemberScreenName, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListMemberships(lists);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserListSubscriptions(final String listOwnerScreenName, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_LIST_SUBSCRIPTIONS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList<UserList> lists = AsyncTwitter.this.twitter.getUserListSubscriptions(listOwnerScreenName, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListSubscriptions(lists);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getAllSubscribingUserLists(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.ALL_USER_LISTS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<UserList> lists = AsyncTwitter.this.twitter.getAllUserLists(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotAllUserLists(lists);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getAllSubscribingUserLists(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.ALL_USER_LISTS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<UserList> lists = AsyncTwitter.this.twitter.getAllUserLists(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotAllUserLists(lists);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserListMembers(final String listOwnerScreenName, final int listId, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.LIST_MEMBERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList<User> users = AsyncTwitter.this.twitter.getUserListMembers(listOwnerScreenName, listId, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListMembers(users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserListMembers(final int listOwnerId, final int listId, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.LIST_MEMBERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList<User> users = AsyncTwitter.this.twitter.getUserListMembers(listOwnerId, listId, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListMembers(users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void addUserListMember(final int listId, final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.ADD_LIST_MEMBER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitter.this.twitter.addUserListMember(listId, userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.addedUserListMember(list);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void addUserListMembers(final int listId, final int[] userIds) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.ADD_LIST_MEMBERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitter.this.twitter.addUserListMembers(listId, userIds);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.addedUserListMembers(list);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void addUserListMembers(final int listId, final String[] screenNames) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.ADD_LIST_MEMBERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitter.this.twitter.addUserListMembers(listId, screenNames);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.addedUserListMembers(list);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void deleteUserListMember(final int listId, final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DELETE_LIST_MEMBER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitter.this.twitter.deleteUserListMember(listId, userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.deletedUserListMember(list);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void checkUserListMembership(final String listOwnerScreenName, final int listId, final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CHECK_LIST_MEMBERSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.checkUserListMembership(listOwnerScreenName, listId, userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.checkedUserListMembership(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserListSubscribers(final String listOwnerScreenName, final int listId, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.LIST_SUBSCRIBERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList<User> users = AsyncTwitter.this.twitter.getUserListSubscribers(listOwnerScreenName, listId, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListSubscribers(users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void subscribeUserList(final String listOwnerScreenName, final int listId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SUBSCRIBE_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitter.this.twitter.subscribeUserList(listOwnerScreenName, listId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.subscribedUserList(list);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void unsubscribeUserList(final String listOwnerScreenName, final int listId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UNSUBSCRIBE_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitter.this.twitter.unsubscribeUserList(listOwnerScreenName, listId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.unsubscribedUserList(list);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void checkUserListSubscription(final String listOwnerScreenName, final int listId, final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CHECK_LIST_SUBSCRIPTION, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.checkUserListSubscription(listOwnerScreenName, listId, userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.checkedUserListSubscription(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getDirectMessages() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DIRECT_MESSAGES, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<DirectMessage> directMessages = AsyncTwitter.this.twitter.getDirectMessages();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotDirectMessages(directMessages);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getDirectMessages(final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DIRECT_MESSAGES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<DirectMessage> directMessages = AsyncTwitter.this.twitter.getDirectMessages(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotDirectMessages(directMessages);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getSentDirectMessages() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SENT_DIRECT_MESSAGES, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<DirectMessage> directMessages = AsyncTwitter.this.twitter.getSentDirectMessages();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotSentDirectMessages(directMessages);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getSentDirectMessages(final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SENT_DIRECT_MESSAGES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<DirectMessage> directMessages = AsyncTwitter.this.twitter.getSentDirectMessages(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotSentDirectMessages(directMessages);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void sendDirectMessage(final String screenName, final String text) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SEND_DIRECT_MESSAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                DirectMessage directMessage = AsyncTwitter.this.twitter.sendDirectMessage(screenName, text);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.sentDirectMessage(directMessage);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void sendDirectMessage(final int userId, final String text) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SEND_DIRECT_MESSAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                DirectMessage directMessage = AsyncTwitter.this.twitter.sendDirectMessage(userId, text);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.sentDirectMessage(directMessage);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void destroyDirectMessage(final long id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_DIRECT_MESSAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                DirectMessage directMessage = AsyncTwitter.this.twitter.destroyDirectMessage(id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedDirectMessage(directMessage);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void showDirectMessage(final long id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DIRECT_MESSAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                DirectMessage directMessage = AsyncTwitter.this.twitter.showDirectMessage(id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotDirectMessage(directMessage);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void createFriendship(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.createFriendship(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdFriendship(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void createFriendship(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.createFriendship(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdFriendship(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void createFriendship(final String screenName, final boolean follow) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.createFriendship(screenName, follow);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdFriendship(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void createFriendship(final int userId, final boolean follow) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.createFriendship(userId, follow);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdFriendship(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void destroyFriendship(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.destroyFriendship(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedFriendship(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void destroyFriendship(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.destroyFriendship(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedFriendship(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void existsFriendship(final String userA, final String userB) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.EXISTS_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                for (TwitterListener listener : listeners) {
                    boolean exists = AsyncTwitter.this.twitter.existsFriendship(userA, userB);
                    try {
                        listener.gotExistsFriendship(exists);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void showFriendship(final String sourceScreenName, final String targetScreenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SHOW_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Relationship relationship = AsyncTwitter.this.twitter.showFriendship(sourceScreenName, targetScreenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotShowFriendship(relationship);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void showFriendship(final int sourceId, final int targetId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SHOW_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Relationship relationship = AsyncTwitter.this.twitter.showFriendship(sourceId, targetId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotShowFriendship(relationship);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getIncomingFriendships(final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.INCOMING_FRIENDSHIPS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitter.this.twitter.getIncomingFriendships(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotIncomingFriendships(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getOutgoingFriendships(final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.OUTGOING_FRIENDSHIPS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitter.this.twitter.getOutgoingFriendships(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotOutgoingFriendships(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void lookupFriendships(final String[] screenNames) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.LOOKUP_FRIENDSHIPS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Friendship> friendships = AsyncTwitter.this.twitter.lookupFriendships(screenNames);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.lookedUpFriendships(friendships);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void lookupFriendships(final int[] ids) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.LOOKUP_FRIENDSHIPS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Friendship> friendships = AsyncTwitter.this.twitter.lookupFriendships(ids);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.lookedUpFriendships(friendships);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateFriendship(final String screenName, final boolean enableDeviceNotification, final boolean retweet) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Relationship relationship = AsyncTwitter.this.twitter.updateFriendship(screenName, enableDeviceNotification, retweet);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedFriendship(relationship);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateFriendship(final int userId, final boolean enableDeviceNotification, final boolean retweet) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Relationship relationship = AsyncTwitter.this.twitter.updateFriendship(userId, enableDeviceNotification, retweet);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedFriendship(relationship);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFriendsIDs() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_IDS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitter.this.twitter.getFriendsIDs();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFriendsIDs(final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitter.this.twitter.getFriendsIDs(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFriendsIDs(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitter.this.twitter.getFriendsIDs(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFriendsIDs(final int userId, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitter.this.twitter.getFriendsIDs(userId, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFriendsIDs(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitter.this.twitter.getFriendsIDs(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFriendsIDs(final String screenName, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitter.this.twitter.getFriendsIDs(screenName, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFollowersIDs() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_IDS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitter.this.twitter.getFollowersIDs();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFollowersIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFollowersIDs(final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitter.this.twitter.getFollowersIDs(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFollowersIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFollowersIDs(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitter.this.twitter.getFollowersIDs(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFollowersIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFollowersIDs(final int userId, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitter.this.twitter.getFollowersIDs(userId, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFollowersIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFollowersIDs(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitter.this.twitter.getFollowersIDs(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFollowersIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFollowersIDs(final String screenName, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitter.this.twitter.getFollowersIDs(screenName, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFollowersIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void verifyCredentials() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.VERIFY_CREDENTIALS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.verifyCredentials();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.verifiedCredentials(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateProfile(final String name, final String url, final String location, final String description) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_PROFILE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.updateProfile(name, url, location, description);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedProfile(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRateLimitStatus() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RATE_LIMIT_STATUS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                RateLimitStatus rateLimitStatus = AsyncTwitter.this.twitter.getRateLimitStatus();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRateLimitStatus(rateLimitStatus);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateProfileColors(final String profileBackgroundColor, final String profileTextColor, final String profileLinkColor, final String profileSidebarFillColor, final String profileSidebarBorderColor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_PROFILE_COLORS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.updateProfileColors(profileBackgroundColor, profileTextColor, profileLinkColor, profileSidebarFillColor, profileSidebarBorderColor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedProfileColors(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateProfileImage(final File image) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_PROFILE_IMAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.updateProfileImage(image);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedProfileImage(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateProfileImage(final InputStream image) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_PROFILE_IMAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.updateProfileImage(image);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedProfileImage(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateProfileBackgroundImage(final File image, final boolean tile) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_PROFILE_BACKGROUND_IMAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.updateProfileBackgroundImage(image, tile);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedProfileBackgroundImage(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateProfileBackgroundImage(final InputStream image, final boolean tile) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_PROFILE_BACKGROUND_IMAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.updateProfileBackgroundImage(image, tile);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedProfileBackgroundImage(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFavorites() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FAVORITES, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getFavorites();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFavorites(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFavorites(final int page) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FAVORITES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getFavorites(page);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFavorites(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFavorites(final String id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FAVORITES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getFavorites(id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFavorites(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFavorites(final String id, final int page) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FAVORITES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Status> statuses = AsyncTwitter.this.twitter.getFavorites(id, page);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFavorites(statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void createFavorite(final long id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_FAVORITE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitter.this.twitter.createFavorite(id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdFavorite(status);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void destroyFavorite(final long id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_FAVORITE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitter.this.twitter.destroyFavorite(id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedFavorite(status);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void enableNotification(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.ENABLE_NOTIFICATION, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.enableNotification(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.enabledNotification(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void enableNotification(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.ENABLE_NOTIFICATION, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.enableNotification(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.enabledNotification(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void disableNotification(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DISABLE_NOTIFICATION, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.disableNotification(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.disabledNotification(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void disableNotification(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DISABLE_NOTIFICATION, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.disableNotification(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.disabledNotification(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void createBlock(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_BLOCK, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.createBlock(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdBlock(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void createBlock(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_BLOCK, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.createBlock(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdBlock(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void destroyBlock(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_BLOCK, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.destroyBlock(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedBlock(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void destroyBlock(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_BLOCK, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.destroyBlock(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedBlock(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void existsBlock(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.EXISTS_BLOCK, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                boolean exists = AsyncTwitter.this.twitter.existsBlock(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotExistsBlock(exists);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void existsBlock(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.EXISTS_BLOCK, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                boolean exists = AsyncTwitter.this.twitter.existsBlock(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotExistsBlock(exists);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getBlockingUsers() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.BLOCKING_USERS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<User> users = AsyncTwitter.this.twitter.getBlockingUsers();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotBlockingUsers(users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getBlockingUsers(final int page) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.BLOCKING_USERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<User> users = AsyncTwitter.this.twitter.getBlockingUsers(page);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotBlockingUsers(users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getBlockingUsersIDs() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.BLOCKING_USERS_IDS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitter.this.twitter.getBlockingUsersIDs();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotBlockingUsersIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void reportSpam(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.REPORT_SPAM, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.reportSpam(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.reportedSpam(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void reportSpam(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.REPORT_SPAM, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitter.this.twitter.reportSpam(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.reportedSpam(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getAvailableTrends() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.AVAILABLE_TRENDS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Location> locations = AsyncTwitter.this.twitter.getAvailableTrends();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotAvailableTrends(locations);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getAvailableTrends(final GeoLocation location) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.AVAILABLE_TRENDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Location> locations = AsyncTwitter.this.twitter.getAvailableTrends(location);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotAvailableTrends(locations);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getLocationTrends(final int woeid) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.LOCATION_TRENDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Trends trends = AsyncTwitter.this.twitter.getLocationTrends(woeid);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotLocationTrends(trends);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void searchPlaces(final GeoQuery query) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SEARCH_PLACES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Place> places = AsyncTwitter.this.twitter.searchPlaces(query);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.searchedPlaces(places);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getSimilarPlaces(final GeoLocation location, final String name, final String containedWithin, final String streetAddress) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SIMILAR_PLACES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                SimilarPlaces similarPlaces = AsyncTwitter.this.twitter.getSimilarPlaces(location, name, containedWithin, streetAddress);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotSimilarPlaces(similarPlaces);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getNearbyPlaces(final GeoQuery query) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.NEAR_BY_PLACES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Place> places = AsyncTwitter.this.twitter.getNearbyPlaces(query);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotNearByPlaces(places);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void reverseGeoCode(final GeoQuery query) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.REVERSE_GEO_CODE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList<Place> places = AsyncTwitter.this.twitter.reverseGeoCode(query);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotReverseGeoCode(places);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getGeoDetails(final String id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.GEO_DETAILS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Place place = AsyncTwitter.this.twitter.getGeoDetails(id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotGeoDetails(place);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void createPlace(final String name, final String containedWithin, final String token, final GeoLocation location, final String streetAddress) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_PLACE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Place place = AsyncTwitter.this.twitter.createPlace(name, containedWithin, token, location, streetAddress);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdPlace(place);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getTermsOfService() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.TERMS_OF_SERVICE, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                String tos = AsyncTwitter.this.twitter.getTermsOfService();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotTermsOfService(tos);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getPrivacyPolicy() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.PRIVACY_POLICY, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                String privacyPolicy = AsyncTwitter.this.twitter.getPrivacyPolicy();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotPrivacyPolicy(privacyPolicy);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRelatedResults(final long statusId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RELATED_RESULTS, this.listeners){

            @Override
            void invoke(List<TwitterListener> listeners) throws TwitterException {
                RelatedResults relatedResults = AsyncTwitter.this.twitter.getRelatedResults(statusId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRelatedResults(relatedResults);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void test() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.TEST, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                boolean ok = AsyncTwitter.this.twitter.test();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.tested(ok);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        super.shutdown();
        Class clazz = AsyncTwitter.class;
        synchronized (clazz) {
            if (dispatcher != null) {
                dispatcher.shutdown();
                dispatcher = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dispatcher getDispatcher() {
        if (null == dispatcher) {
            Class clazz = TwitterStream.class;
            synchronized (clazz) {
                if (null == dispatcher) {
                    dispatcher = new DispatcherFactory(this.conf).getInstance();
                }
            }
        }
        return dispatcher;
    }

    public void setOAuthConsumer(String consumerKey, String consumerSecret) {
        this.twitter.setOAuthConsumer(consumerKey, consumerSecret);
    }

    public RequestToken getOAuthRequestToken() throws TwitterException {
        return this.twitter.getOAuthRequestToken();
    }

    public RequestToken getOAuthRequestToken(String callbackUrl) throws TwitterException {
        return this.twitter.getOAuthRequestToken(callbackUrl);
    }

    public AccessToken getOAuthAccessToken() throws TwitterException {
        return this.twitter.getOAuthAccessToken();
    }

    public AccessToken getOAuthAccessToken(String oauthVerifier) throws TwitterException {
        return this.twitter.getOAuthAccessToken(oauthVerifier);
    }

    public AccessToken getOAuthAccessToken(RequestToken requestToken) throws TwitterException {
        return this.twitter.getOAuthAccessToken(requestToken);
    }

    public AccessToken getOAuthAccessToken(RequestToken requestToken, String oauthVerifier) throws TwitterException {
        return this.twitter.getOAuthAccessToken(requestToken, oauthVerifier);
    }

    public void setOAuthAccessToken(AccessToken accessToken) {
        this.twitter.setOAuthAccessToken(accessToken);
    }

    public AccessToken getOAuthAccessToken(String token, String tokenSecret) throws TwitterException {
        return this.twitter.getOAuthAccessToken(token, tokenSecret);
    }

    public AccessToken getOAuthAccessToken(String token, String tokenSecret, String pin) throws TwitterException {
        return this.twitter.getOAuthAccessToken(new RequestToken(token, tokenSecret), pin);
    }

    public void setOAuthAccessToken(String token, String tokenSecret) {
        this.twitter.setOAuthAccessToken(token, tokenSecret);
    }

    public /* synthetic */ void httpResponseReceived(HttpResponseEvent x0) {
        super.httpResponseReceived(x0);
    }

    public /* synthetic */ int hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ boolean equals(Object x0) {
        return super.equals(x0);
    }

    public /* synthetic */ void addRateLimitStatusListener(RateLimitStatusListener x0) {
        super.addRateLimitStatusListener(x0);
    }

    public /* synthetic */ void setRateLimitStatusListener(RateLimitStatusListener x0) {
        super.setRateLimitStatusListener(x0);
    }

    public /* synthetic */ boolean isOAuthEnabled() {
        return super.isOAuthEnabled();
    }

    public /* synthetic */ String toString() {
        return super.toString();
    }

    public /* synthetic */ Configuration getConfiguration() {
        return super.getConfiguration();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AsyncTask
    implements Runnable {
        List<TwitterListener> listeners;
        TwitterMethod method;

        AsyncTask(TwitterMethod method, List<TwitterListener> listeners) {
            this.method = method;
            this.listeners = listeners;
        }

        abstract void invoke(List<TwitterListener> var1) throws TwitterException;

        @Override
        public void run() {
            block5: {
                try {
                    this.invoke(this.listeners);
                }
                catch (TwitterException te) {
                    if (null == this.listeners) break block5;
                    for (TwitterListener listener : this.listeners) {
                        try {
                            listener.onException(te, this.method);
                        }
                        catch (Exception ignore) {}
                    }
                }
            }
        }
    }
}

