/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.Arrays;
import twitter4j.IDs;
import twitter4j.TwitterException;
import twitter4j.TwitterResponseImpl;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.internal.util.ParseUtil;

final class IDsJSONImpl
extends TwitterResponseImpl
implements IDs {
    private int[] ids;
    private long previousCursor = -1L;
    private long nextCursor = -1L;
    private static final long serialVersionUID = -6585026560164704953L;

    IDsJSONImpl(HttpResponse res) throws TwitterException {
        super(res);
        String json = res.asString();
        this.init(json);
        DataObjectFactoryUtil.clearThreadLocalMap();
        DataObjectFactoryUtil.registerJSONObject(this, json);
    }

    IDsJSONImpl(String json) throws TwitterException {
        this.init(json);
    }

    private void init(String jsonStr) throws TwitterException {
        try {
            if (jsonStr.startsWith("{")) {
                JSONObject json = new JSONObject(jsonStr);
                JSONArray idList = json.getJSONArray("ids");
                this.ids = new int[idList.length()];
                for (int i = 0; i < idList.length(); ++i) {
                    try {
                        this.ids[i] = Integer.parseInt(idList.getString(i));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new TwitterException("Twitter API returned malformed response: " + json, nfe);
                    }
                }
                this.previousCursor = ParseUtil.getLong("previous_cursor", json);
                this.nextCursor = ParseUtil.getLong("next_cursor", json);
            } else {
                JSONArray idList = new JSONArray(jsonStr);
                this.ids = new int[idList.length()];
                for (int i = 0; i < idList.length(); ++i) {
                    try {
                        this.ids[i] = Integer.parseInt(idList.getString(i));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new TwitterException("Twitter API returned malformed response: " + idList, nfe);
                    }
                }
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    public int[] getIDs() {
        return this.ids;
    }

    public boolean hasPrevious() {
        return 0L != this.previousCursor;
    }

    public long getPreviousCursor() {
        return this.previousCursor;
    }

    public boolean hasNext() {
        return 0L != this.nextCursor;
    }

    public long getNextCursor() {
        return this.nextCursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IDs)) {
            return false;
        }
        IDs iDs = (IDs)o;
        return Arrays.equals(this.ids, iDs.getIDs());
    }

    public int hashCode() {
        return this.ids != null ? Arrays.hashCode(this.ids) : 0;
    }

    public String toString() {
        return "IDsJSONImpl{ids=" + Arrays.toString(this.ids) + ", previousCursor=" + this.previousCursor + ", nextCursor=" + this.nextCursor + '}';
    }
}

