/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.imagej.Image;
import adams.data.imagej.flattener.AbstractImageJFlattener;
import adams.data.imagej.flattener.Pixels;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import weka.core.Instance;

public class ImageJFlattener
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 2931644921913892736L;
    protected AbstractImageJFlattener m_FlattenAlgorithm;

    public String globalInfo() {
        return "Applies an ImageJ flattener to the incoming image and outputs the generated WEKA Instance.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("flattener", "flattenAlgorithm", (Object)new Pixels());
    }

    public void setFlattenAlgorithm(AbstractImageJFlattener value) {
        this.m_FlattenAlgorithm = value;
        this.reset();
    }

    public AbstractImageJFlattener getFlattenAlgorithm() {
        return this.m_FlattenAlgorithm;
    }

    public String flattenAlgorithmTipText() {
        return "The flattener to use for flattening the image.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("flattenAlgorithm");
        if (variable != null) {
            return variable;
        }
        if (this.m_FlattenAlgorithm != null) {
            return this.m_FlattenAlgorithm.getClass().getName();
        }
        return null;
    }

    public Class[] accepts() {
        return new Class[]{Image.class};
    }

    public Class[] generates() {
        return new Class[]{Instance.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            Instance inst = this.m_FlattenAlgorithm.flatten((Image)this.m_InputToken.getPayload());
            this.m_OutputToken = new Token((Object)inst);
        }
        catch (Exception e) {
            result = e.toString();
            this.getSystemErr().printStackTrace((Throwable)e);
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.setProvenance(this.m_InputToken.getProvenance());
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

