/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.data.imagej.transformer.AbstractImageJTransformer;
import adams.data.imagej.transformer.PassThrough;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.visualization.image.plugins.AbstractImageFilter;
import ij.ImagePlus;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Date;

public class ImageJTransformer
extends AbstractImageFilter {
    private static final long serialVersionUID = 9108452366270377935L;

    public String getCaption() {
        return "Apply ImageJ transformer...";
    }

    protected BufferedImage filter(BufferedImage image) {
        BufferedImage result = null;
        GenericObjectEditorDialog dialog = this.m_CurrentPanel.getParentDialog() != null ? new GenericObjectEditorDialog(this.m_CurrentPanel.getParentDialog()) : new GenericObjectEditorDialog(this.m_CurrentPanel.getParentFrame());
        dialog.getGOEEditor().setClassType(AbstractImageJTransformer.class);
        dialog.getGOEEditor().setCanChangeClassInDialog(true);
        if (this.hasLastSetup()) {
            dialog.setCurrent(this.getLastSetup());
        } else {
            dialog.setCurrent((Object)new PassThrough());
        }
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setLocationRelativeTo((Component)this.m_CurrentPanel);
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            this.m_CanceledByUser = true;
            return result;
        }
        this.setLastSetup(dialog.getCurrent());
        String title = this.m_CurrentPanel.getCurrentFile() != null ? this.m_CurrentPanel.getCurrentFile().toString() : "" + new Date();
        AbstractImageJTransformer transformer = (AbstractImageJTransformer)dialog.getCurrent();
        adams.data.imagej.Image[] transformed = transformer.transform(new adams.data.imagej.Image(new ImagePlus(title, (Image)image)));
        if (transformed.length == 0) {
            this.m_FilterError = "No filtered image generated!";
        }
        if (transformed.length > 1) {
            this.getSystemErr().println("WARNING: Generated more than one image, using only first one.");
        }
        if (transformed.length >= 1) {
            result = transformed[0].getImage().getBufferedImage();
        }
        return result;
    }
}

