/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.image;

import de.intarsys.cwt.image.IImage;
import de.intarsys.cwt.image.IImageContainer;
import de.intarsys.cwt.image.IImageEntry;
import de.intarsys.tools.attribute.AttributeMap;
import java.io.IOException;
import java.lang.ref.SoftReference;

public abstract class ImageEntry
implements IImageEntry {
    private final IImageContainer container;
    private final AttributeMap attributes = new AttributeMap();
    private SoftReference delegate;

    protected ImageEntry(IImageContainer container) {
        this.container = container;
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public IImageContainer getContainer() {
        return this.container;
    }

    protected synchronized IImage getDelegate() {
        IImage image = null;
        if (this.delegate != null) {
            image = (IImage)this.delegate.get();
        }
        if (image == null) {
            try {
                image = this.loadContent();
            }
            catch (Exception e) {
                image = this.getErrorImage(e);
            }
            this.delegate = new SoftReference<IImage>(image);
        }
        return image;
    }

    protected abstract IImage getErrorImage(Exception var1);

    public int getHeight() {
        return this.getDelegate().getHeight();
    }

    public int getWidth() {
        return this.getDelegate().getWidth();
    }

    protected abstract IImage loadContent() throws IOException;

    public Object removeAttribute(Object key) {
        return this.attributes.remove(key);
    }

    public Object setAttribute(Object key, Object o) {
        return this.attributes.put(key, o);
    }
}

