/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.image;

import java.io.IOException;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class ImageMetadata {
    private IIOMetadata[] imageMetadata;
    private IIOMetadata streamMetadata;

    public static ImageMetadata createFromImageReader(ImageReader imageReader) throws IOException {
        IIOMetadata[] imageMetadata = new IIOMetadata[imageReader.getNumImages(true)];
        int index = 0;
        while (index < imageMetadata.length) {
            imageMetadata[index] = imageReader.getImageMetadata(index);
            ++index;
        }
        return new ImageMetadata(imageReader.getStreamMetadata(), imageMetadata);
    }

    protected ImageMetadata() {
    }

    public ImageMetadata(IIOMetadata paramStreamMetadata, IIOMetadata[] paramImageMetadata) {
        this.streamMetadata = paramStreamMetadata;
        this.imageMetadata = paramImageMetadata;
    }

    public Node getAsTree(String formatName) {
        IIOMetadataNode root = new IIOMetadataNode("root");
        if (this.streamMetadata != null) {
            root.appendChild(this.streamMetadata.getAsTree(formatName));
        }
        int index = 0;
        while (index < this.imageMetadata.length) {
            IIOMetadataNode node = new IIOMetadataNode(String.valueOf(index));
            root.appendChild(node);
            node.appendChild(this.imageMetadata[index].getAsTree(formatName));
            ++index;
        }
        return root;
    }

    public IIOMetadata[] getImageMetadata() {
        return this.imageMetadata;
    }

    public String getNativeMetadataFormatName() {
        return this.imageMetadata[0].getNativeMetadataFormatName();
    }

    public IIOMetadata getStreamMetadata() {
        return this.streamMetadata;
    }

    protected void setImageMetadata(IIOMetadata[] paramMetadata) {
        this.imageMetadata = paramMetadata;
    }

    protected void setStreamMetadata(IIOMetadata paramMetadata) {
        this.streamMetadata = paramMetadata;
    }
}

