/*
 * Decompiled with CFR 0.152.
 */
package adams.core.gnuplot;

import adams.core.EnumWithCustomDisplay;
import adams.core.Utils;
import adams.core.gnuplot.AbstractPlotScriptlet;
import adams.core.option.AbstractOption;

public class SimplePlot
extends AbstractPlotScriptlet {
    private static final long serialVersionUID = -3540923217777778401L;
    public static final String NOTITLE = "notitle";
    protected PlotType m_PlotType;
    protected String m_PlotName;
    protected boolean m_FirstPlot;

    public String globalInfo() {
        return "For simple plots, like line plots.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("plot-type", "plotType", (Object)PlotType.LINES);
        this.m_OptionManager.add("plot-name", "plotName", (Object)"");
        this.m_OptionManager.add("first-plot", "firstPlot", (Object)false);
    }

    public void setPlotType(PlotType value) {
        this.m_PlotType = value;
        this.reset();
    }

    public PlotType getPlotType() {
        return this.m_PlotType;
    }

    public String plotTypeTipText() {
        return "The plot type to use.";
    }

    public void setPlotName(String value) {
        this.m_PlotName = value;
        this.reset();
    }

    public String getPlotName() {
        return this.m_PlotName;
    }

    public String plotNameTipText() {
        return "The name to use for the plot in the key; gnuplot default is used if empty; use 'notitle' to suppress title.";
    }

    public void setFirstPlot(boolean value) {
        this.m_FirstPlot = value;
        this.reset();
    }

    public boolean getFirstPlot() {
        return this.m_FirstPlot;
    }

    public String firstPlotTipText() {
        return "If enabled, the plot is assumed to be the first plot.";
    }

    @Override
    protected String doGenerate() {
        StringBuilder result = new StringBuilder();
        if (this.m_FirstPlot) {
            result.append("plot");
        } else {
            result.append("replot");
        }
        result.append(" ");
        result.append("\"" + this.getDataFile().getAbsolutePath() + "\"");
        result.append(" ");
        result.append("using " + this.m_Columns);
        result.append(" ");
        if (this.m_PlotName.equals(NOTITLE)) {
            result.append(NOTITLE);
        } else if (this.m_PlotName.length() > 0) {
            result.append("title \"" + Utils.backQuoteChars((String)this.m_PlotName) + "\"");
        }
        if (result.charAt(result.length() - 1) != ' ') {
            result.append(" ");
        }
        result.append("with " + (Object)((Object)this.m_PlotType));
        result.append("\n");
        return result.toString();
    }

    public static enum PlotType implements EnumWithCustomDisplay<PlotType>
    {
        LINES("lines"),
        POINTS("points"),
        LINESPOINTS("linespoints"),
        IMPULSES("impulses"),
        DOTS("dots"),
        STEPS("steps"),
        FSTEPS("fsteps"),
        HISTEPS("histeps"),
        ERRORBARS("errorbars"),
        XERRORBARS("xerrorbars"),
        YERRORBARS("yerrorbars"),
        XYERRORBARS("xyerrorbars"),
        ERRORLINES("errorlines"),
        XERRORLINES("xerrorlines"),
        YERRORLINES("yerrorlines"),
        XYERRORLINES("xyerrorlines"),
        BOXES("boxes"),
        FILLEDCURVES("filledcurves"),
        BOXERRORBARS("boxerrorbars"),
        BOXXYERRORBARS("boxxyerrorbars"),
        FINANCEBARDS("financebars"),
        CANDELSTICKS("candlesticks"),
        VECTORS("vectors");

        private String m_Display;
        private String m_Raw;

        private PlotType(String display) {
            this.m_Display = display;
            this.m_Raw = super.toString();
        }

        public String toDisplay() {
            return this.m_Display;
        }

        public String toRaw() {
            return this.m_Raw;
        }

        public PlotType parse(String s) {
            return PlotType.valueOf((AbstractOption)null, s);
        }

        public String getField() {
            return this.m_Display.replaceAll(" .*", "");
        }

        public String toString() {
            return this.m_Display;
        }

        public static String toString(AbstractOption option, Object object) {
            return ((PlotType)((Object)object)).toRaw();
        }

        public static PlotType valueOf(AbstractOption option, String str) {
            PlotType result = null;
            try {
                result = PlotType.valueOf(str);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (result == null) {
                for (PlotType f : PlotType.values()) {
                    if (!f.toDisplay().equals(str)) continue;
                    result = f;
                    break;
                }
            }
            return result;
        }
    }
}

