/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.api;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeInterface;
import de.intarsys.nativec.type.NativeArray;
import de.intarsys.nativec.type.NativeArrayType;
import de.intarsys.nativec.type.NativeBuffer;
import de.intarsys.nativec.type.NativeBufferType;
import de.intarsys.nativec.type.NativeInt;
import de.intarsys.nativec.type.NativeLong;
import de.intarsys.tools.valueholder.IValueHolder;
import de.intarsys.tools.valueholder.ObjectValueHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeTools {
    public static byte[] fromNativeByteArray(long ptr, int count) {
        if (ptr == 0L) {
            return null;
        }
        INativeHandle handle = NativeInterface.get().createHandle(ptr);
        NativeBufferType type = NativeBufferType.create(count);
        NativeBuffer nativeValue = (NativeBuffer)type.createNative(handle);
        return nativeValue.getBytes();
    }

    public static long fromNativeCLong(long ptr) {
        INativeHandle handle = NativeInterface.get().createHandle(ptr);
        NativeLong nativeValue = (NativeLong)NativeLong.META.createNative(handle);
        return nativeValue.intValue();
    }

    public static IValueHolder<Number> fromNativeCLongHolder(long ptr) {
        return new ObjectValueHolder((Object)NativeTools.fromNativeCLong(ptr));
    }

    public static int fromNativeInt(long ptr) {
        INativeHandle handle = NativeInterface.get().createHandle(ptr);
        NativeInt nativeValue = (NativeInt)NativeInt.META.createNative(handle);
        return nativeValue.intValue();
    }

    public static int[] fromNativeIntArray(INativeHandle handle, int count) {
        int[] ints = new int[count];
        int offset = NativeInt.META.getByteCount();
        int index = 0;
        while (index < count) {
            ints[index] = handle.getInt(index * offset);
            ++index;
        }
        return ints;
    }

    public static int[] fromNativeIntArray(long ptr, int count) {
        INativeHandle handle = NativeInterface.get().createHandle(ptr);
        return NativeTools.fromNativeIntArray(handle, count);
    }

    public static IValueHolder<Integer> fromNativeIntHolder(long ptr) {
        return new ObjectValueHolder((Object)NativeTools.fromNativeInt(ptr));
    }

    public static String fromNativeString(long ptr, int count) {
        return null;
    }

    public static INativeHandle toHandle(long address) {
        return NativeInterface.get().createHandle(address);
    }

    public static void toNativeByteArray(long ptr, byte[] value) {
        if (value != null) {
            INativeHandle handle = NativeInterface.get().createHandle(ptr);
            NativeBufferType type = NativeBufferType.create(value.length);
            NativeBuffer buffer = (NativeBuffer)type.createNative(handle);
            buffer.setValue(value);
        }
    }

    public static void toNativeCLong(long ptr, IValueHolder<Number> value) {
        NativeTools.toNativeCLong(ptr, ((Number)value.get()).longValue());
    }

    public static void toNativeCLong(long ptr, long value) {
        INativeHandle handle = NativeInterface.get().createHandle(ptr);
        NativeLong nativeValue = (NativeLong)NativeLong.META.createNative(handle);
        nativeValue.setValue(value);
    }

    public static void toNativeCLong(long ptr, int[] value) {
        if (value != null) {
            INativeHandle handle = NativeInterface.get().createHandle(ptr);
            NativeArrayType type = NativeArrayType.create(NativeLong.META, value.length);
            NativeArray array = (NativeArray)type.createNative(handle);
            int index = 0;
            while (index < value.length) {
                array.setValue(index, value[index]);
                ++index;
            }
        }
    }

    public static void toNativeCLong(long ptr, long[] value) {
        if (value != null) {
            INativeHandle handle = NativeInterface.get().createHandle(ptr);
            NativeArrayType type = NativeArrayType.create(NativeLong.META, value.length);
            NativeArray array = (NativeArray)type.createNative(handle);
            int index = 0;
            while (index < value.length) {
                array.setValue(index, value[index]);
                ++index;
            }
        }
    }

    public static void toNativeInt(long ptr, int value) {
        INativeHandle handle = NativeInterface.get().createHandle(ptr);
        handle.setSize(NativeInt.META.getByteCount());
        handle.setInt(0, value);
    }

    public static void toNativeInt(long ptr, int[] value) {
        if (value != null) {
            INativeHandle handle = NativeInterface.get().createHandle(ptr);
            NativeArrayType type = NativeArrayType.create(NativeInt.META, value.length);
            NativeArray array = (NativeArray)type.createNative(handle);
            int index = 0;
            while (index < value.length) {
                array.setValue(index, value[index]);
                ++index;
            }
        }
    }

    public static void toNativeInt(long ptr, IValueHolder<Integer> value) {
        NativeTools.toNativeInt(ptr, (Integer)value.get());
    }

    public static void toNativePointer(long ptr, INativeHandle value) {
        INativeHandle handle = NativeInterface.get().createHandle(ptr);
        handle.setNativeHandle(0, value);
    }
}

