/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.jna;

import com.sun.jna.JNATools;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import de.intarsys.nativec.api.INativeHandle;

public class JnaNativeHandle
implements INativeHandle {
    private final Pointer pointer;
    private int size;

    public JnaNativeHandle(JnaNativeHandle handle, int offset) {
        this.pointer = new Pointer(handle.getAddress() + (long)offset);
        this.size = handle.size - offset;
    }

    public JnaNativeHandle(long address) {
        this.pointer = new Pointer(address);
    }

    public JnaNativeHandle(Pointer pointer) {
        this.pointer = pointer;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof INativeHandle)) {
            return false;
        }
        INativeHandle otherHandle = (INativeHandle)obj;
        return JNATools.getPeer(this.pointer) == otherHandle.getAddress() && this.size == otherHandle.getSize();
    }

    public long getAddress() {
        return JNATools.getPeer(this.pointer);
    }

    public byte getByte(int index) {
        return this.pointer.getByte((long)index);
    }

    public byte[] getByteArray(int index, int count) {
        return this.pointer.getByteArray((long)index, count);
    }

    public long getCLong(int index) {
        if (Native.LONG_SIZE == 4) {
            return this.pointer.getInt((long)index);
        }
        return this.pointer.getLong((long)index);
    }

    public int getInt(int index) {
        return this.pointer.getInt((long)index);
    }

    public long getLong(int index) {
        return this.pointer.getLong((long)index);
    }

    public INativeHandle getNativeHandle(int index) {
        Pointer tempPointer = this.pointer.getPointer((long)index);
        return new JnaNativeHandle(tempPointer);
    }

    public Pointer getPointer() {
        return this.pointer;
    }

    public short getShort(int index) {
        return this.pointer.getShort((long)index);
    }

    public int getSize() {
        return this.size;
    }

    public String getString(int index) {
        return this.getPointer().getString((long)index);
    }

    public String getWideString(int index) {
        return this.getPointer().getString((long)index, true);
    }

    public int hashCode() {
        return this.pointer.hashCode();
    }

    public INativeHandle offset(int offset) {
        return new JnaNativeHandle(this, offset);
    }

    public void setByte(int index, byte value) {
        this.pointer.setByte((long)index, value);
    }

    public void setByteArray(int index, byte[] value, int valueOffset, int valueCount) {
        this.pointer.write((long)index, value, valueOffset, valueCount);
    }

    public void setCLong(int index, long value) {
        if (Native.LONG_SIZE == 4) {
            this.pointer.setInt((long)index, (int)value);
            return;
        }
        this.pointer.setLong((long)index, value);
    }

    public void setInt(int index, int value) {
        this.pointer.setInt((long)index, value);
    }

    public void setLong(int index, long value) {
        this.pointer.setLong((long)index, value);
    }

    public void setNativeHandle(int index, INativeHandle handle) {
        this.pointer.setPointer((long)index, new Pointer(handle.getAddress()));
    }

    public void setShort(int index, short value) {
        this.pointer.setShort((long)index, value);
    }

    public void setSize(int pSize) {
        this.size = pSize;
    }

    public void setString(int index, String value) {
        this.getPointer().setString((long)index, value);
    }

    public void setWideString(int index, String value) {
        this.getPointer().setString((long)index, value, true);
    }
}

