/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeTools;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeNumber;
import de.intarsys.nativec.type.NativeShortType;
import de.intarsys.nativec.type.NativeType;

public class NativeShort
extends NativeNumber {
    public static final NativeShortType META = new NativeShortType();

    static {
        NativeType.register(NativeShort.class, META);
    }

    public static NativeShort createFromAddress(long address) {
        return (NativeShort)META.createNative(NativeTools.toHandle(address));
    }

    public NativeShort() {
        this.allocate();
    }

    protected NativeShort(INativeHandle handle) {
        super(handle);
    }

    public NativeShort(short value) {
        this.allocate();
        this.setValue(value);
    }

    public byte byteValue() {
        return (byte)this.shortValue();
    }

    public INativeType getNativeType() {
        return META;
    }

    public Object getValue() {
        return new Short(this.shortValue());
    }

    public int intValue() {
        return this.shortValue();
    }

    public long longValue() {
        return this.shortValue();
    }

    public void setValue(Object value) {
        this.setValue(((Number)value).shortValue());
    }

    public void setValue(short value) {
        this.handle.setShort(0, value);
    }

    public short shortValue() {
        return this.handle.getShort(0);
    }

    public String toString() {
        if (this.getNativeHandle().getAddress() == 0L) {
            return "nope - null pointer";
        }
        return String.valueOf(this.shortValue());
    }
}

