/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.NativeInterface;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeStruct;
import de.intarsys.nativec.type.NativeType;
import de.intarsys.nativec.type.StructMember;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeStructType
extends NativeType {
    private int byteBoundary = 1;
    private int byteOffset = 0;
    private int byteSize = 0;
    private final Map<String, StructMember> fields = new HashMap<String, StructMember>();
    private int fieldsSize = 0;
    private int packing = NativeInterface.get().pointerSize();

    protected NativeStructType() {
    }

    protected NativeStructType(Class<?> instanceClass) {
        super(instanceClass);
    }

    public StructMember declare(String name, INativeType declaration) {
        int size = declaration.getByteCount();
        int boundary = Math.min(declaration.getPreferredBoundary(), this.packing);
        this.byteBoundary = Math.max(this.byteBoundary, boundary);
        this.byteOffset = this.byteOffset - ((this.byteOffset + boundary - 1) % boundary + 1) + boundary;
        StructMember field = new StructMember(this, name, this.fieldsSize++, declaration, this.byteOffset);
        this.fields.put(name, field);
        this.byteOffset += size;
        this.byteSize = this.byteOffset;
        return field;
    }

    public int getByteBoundary() {
        return this.byteBoundary;
    }

    @Override
    public int getByteCount() {
        return this.getByteSize();
    }

    public int getByteSize() {
        return this.byteSize;
    }

    public StructMember getField(String name) {
        return this.fields.get(name);
    }

    public List<StructMember> getFields() {
        return new ArrayList<StructMember>(this.fields.values());
    }

    public int getFieldsSize() {
        return this.fieldsSize;
    }

    public INativeObject getNativeObject(NativeStruct struct, String name) {
        StructMember member = this.fields.get(name);
        return member.getNativeObject(struct);
    }

    public int getPacking() {
        return this.packing;
    }

    @Override
    public int getPreferredBoundary() {
        return this.getByteBoundary();
    }

    public void setPacking(int pPacking) {
        if (!this.fields.isEmpty()) {
            throw new IllegalStateException("packing must be set before members are declared");
        }
        this.packing = pPacking;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (StructMember field : this.getFields()) {
            sb.append(field.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

