/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content;

import de.intarsys.pdf.content.CSLiteral;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.content.CSOperators;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.parser.CSContentParser;
import de.intarsys.pdf.writer.COSWriter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import java.io.IOException;
import java.util.Iterator;

public class CSContent {
    private CSOperation[] operations = new CSOperation[100];
    private int size = 0;

    public static CSContent createFromBytes(byte[] data) {
        try {
            CSContentParser parser = new CSContentParser();
            return parser.parseStream(data);
        }
        catch (IOException e) {
            throw new COSRuntimeException(e);
        }
        catch (COSLoadException e) {
            throw new COSRuntimeException(e);
        }
    }

    public static CSContent createFromCos(COSArray streams) {
        RandomAccessByteArray data = new RandomAccessByteArray(null);
        try {
            Iterator it = streams.iterator();
            while (it.hasNext()) {
                COSStream stream = ((COSObject)it.next()).asStream();
                if (stream == null) continue;
                data.write(stream.getDecodedBytes());
                data.write(32);
            }
            CSContentParser parser = new CSContentParser();
            data.seek(0L);
            return parser.parseStream((IRandomAccess)data);
        }
        catch (IOException e) {
            throw new COSRuntimeException(e);
        }
        catch (COSLoadException e) {
            throw new COSRuntimeException(e);
        }
    }

    public static CSContent createFromCos(COSStream stream) {
        return CSContent.createFromBytes(stream.getDecodedBytes());
    }

    public static CSContent createNew() {
        CSContent result = new CSContent();
        return result;
    }

    protected CSContent() {
    }

    public void addMarkedContent(COSName mark, byte[] content) {
        CSOperation operation;
        int i = 0;
        while (i < this.size) {
            operation = this.operations[i];
            if (operation.isOpBeginMarkedContent(mark)) {
                ++i;
                break;
            }
            ++i;
        }
        if (i < this.size) {
            int nesting = 0;
            ++i;
            while (i < this.size) {
                CSOperation operation2 = this.operations[i];
                if (operation2.isOpBeginMarkedContent(null)) {
                    ++nesting;
                }
                if (operation2.isOpEndMarkedContent()) {
                    if (nesting == 0) {
                        this.addOperation(i, new CSLiteral(content));
                        break;
                    }
                    --nesting;
                }
                ++i;
            }
        } else {
            operation = new CSOperation(CSOperators.CSO_BMC);
            operation.addOperand(CSOperation.OPERAND_Tx);
            this.addOperation(operation);
            this.addOperation(new CSLiteral(content));
            operation = new CSOperation(CSOperators.CSO_EMC);
            this.addOperation(operation);
        }
    }

    public void addOperation(CSOperation op) {
        if (this.size >= this.operations.length) {
            CSOperation[] newOperations = new CSOperation[this.size * 2];
            System.arraycopy(this.operations, 0, newOperations, 0, this.size);
            this.operations = newOperations;
        }
        this.operations[this.size++] = op;
    }

    public void addOperation(int index, CSOperation op) {
        if (this.size >= this.operations.length) {
            CSOperation[] newOperations = new CSOperation[this.size * 2];
            System.arraycopy(this.operations, 0, newOperations, 0, this.size);
            this.operations = newOperations;
        }
        System.arraycopy(this.operations, index, this.operations, index + 1, this.size - index);
        ++this.size;
        this.operations[index] = op;
    }

    public COSStream createStream() {
        COSStream result = COSStream.create(null);
        result.setDecodedBytes(this.toByteArray());
        return result;
    }

    public COSStream createStreamFlate() {
        COSStream result = COSStream.create(null);
        byte[] bytes = this.toByteArray();
        result.setDecodedBytes(bytes);
        if (bytes.length > 10) {
            result.addFilter(Filter.CN_Filter_FlateDecode);
        }
        return result;
    }

    public CSOperation getLastOperation() {
        if (this.size == 0) {
            return null;
        }
        return this.operations[this.size - 1];
    }

    public CSOperation getOperation(int index) {
        return this.operations[index];
    }

    public CSOperation[] getOperations() {
        CSOperation[] copy = new CSOperation[this.size];
        System.arraycopy(this.operations, 0, copy, 0, this.size());
        return copy;
    }

    public void removeLastOperation() {
        this.removeOperation(this.size - 1);
    }

    public void removeOperation(int index) {
        System.arraycopy(this.operations, index + 1, this.operations, index, this.size - index - 1);
        --this.size;
    }

    public void setMarkedContent(COSName mark, byte[] content) {
        CSOperation operation;
        int i = 0;
        while (i < this.size) {
            operation = this.operations[i];
            if (operation.isOpBeginMarkedContent(mark)) {
                ++i;
                break;
            }
            ++i;
        }
        if (i < this.size) {
            this.addOperation(i, new CSLiteral(content));
            int nesting = 0;
            ++i;
            while (i < this.size) {
                CSOperation operation2 = this.operations[i];
                if (operation2.isOpBeginMarkedContent(null)) {
                    ++nesting;
                }
                if (operation2.isOpEndMarkedContent()) {
                    if (nesting == 0) break;
                    --nesting;
                }
                this.removeOperation(i);
            }
        } else {
            operation = new CSOperation(CSOperators.CSO_BMC);
            operation.addOperand(CSOperation.OPERAND_Tx);
            this.addOperation(operation);
            this.addOperation(new CSLiteral(content));
            operation = new CSOperation(CSOperators.CSO_EMC);
            this.addOperation(operation);
        }
    }

    public int size() {
        return this.size;
    }

    public byte[] toByteArray() {
        RandomAccessByteArray randomAccess = new RandomAccessByteArray(null);
        COSWriter writer = new COSWriter((IRandomAccess)randomAccess, null);
        try {
            writer.writeContentStream(this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return randomAccess.toByteArray();
    }

    public String toString() {
        return new String(this.toByteArray());
    }
}

