/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.StandardCryptHandler;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class ArcFourCryptHandler
extends StandardCryptHandler {
    public static final String CIPHER_ALGORITHM = "RC4";
    public static final String KEY_ALGORITHM = "RC4";
    public static final String DIGEST_ALGORITHM = "MD5";

    protected synchronized byte[] basicDecrypt(byte[] data, byte[] encryptionKey, int objectNum, int genNum) throws COSSecurityException {
        try {
            this.updateHash(encryptionKey, objectNum, genNum);
            byte[] keyBase = this.md.digest();
            SecretKeySpec skeySpec = new SecretKeySpec(keyBase, 0, this.length, "RC4");
            this.cipher.init(2, skeySpec);
            return this.cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new COSSecurityException(e);
        }
    }

    protected synchronized byte[] basicEncrypt(byte[] data, byte[] encryptionKey, int objectNum, int genNum) throws COSSecurityException {
        try {
            this.updateHash(encryptionKey, objectNum, genNum);
            byte[] keyBase = this.md.digest();
            SecretKeySpec skeySpec = new SecretKeySpec(keyBase, 0, this.length, "RC4");
            this.cipher.init(2, skeySpec);
            return this.cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new COSSecurityException(e);
        }
    }

    public void initialize(byte[] pCryptKey) throws COSSecurityException {
        super.initialize(pCryptKey);
        try {
            this.md = MessageDigest.getInstance(DIGEST_ALGORITHM);
            this.cipher = Cipher.getInstance("RC4");
        }
        catch (NoSuchAlgorithmException e) {
            throw new COSSecurityException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new COSSecurityException(e);
        }
    }
}

