/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.fd;

import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.fd.FDFDF;
import de.intarsys.pdf.st.EnumWriteMode;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class FDDocument {
    private COSDocument cosDoc;
    private FDFDF fdf;

    protected FDDocument(COSDocument newDoc) {
        this.cosDoc = newDoc;
    }

    protected FDDocument() {
        this.cosDoc = COSDocument.createNew(STDocument.DOCTYPE_FDF);
    }

    public static FDDocument createFromCOS(COSDocument doc) {
        FDDocument result = new FDDocument(doc);
        result.initializeFromCOS();
        return result;
    }

    public static FDDocument createNew() {
        FDDocument result = new FDDocument();
        result.initializeFromScratch();
        return result;
    }

    protected void initializeFromCOS() {
        this.fdf = (FDFDF)FDFDF.META.createFromCos(this.getCatalog().cosGetFDF());
    }

    protected void initializeFromScratch() {
        this.fdf = (FDFDF)FDFDF.META.createNew();
        this.getCatalog().cosSetFDF(this.fdf.cosGetDict());
    }

    public COSCatalog getCatalog() {
        return this.cosGetDoc().getCatalog();
    }

    public COSDocument cosGetDoc() {
        return this.cosDoc;
    }

    public FDFDF getFdf() {
        return this.fdf;
    }

    public void save() throws IOException {
        this.save(this.getLocator(), null);
    }

    public ILocator getLocator() {
        return this.cosDoc.getLocator();
    }

    public void save(ILocator locator, Map options) throws IOException {
        if (options == null) {
            options = new HashMap();
        }
        this.cosDoc.setWriteModeHint(EnumWriteMode.FULL);
        this.cosDoc.save(locator, options);
    }

    public void save(ILocator locator) throws IOException {
        this.save(locator, null);
    }
}

