/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.font.CMapRangeMap;

public class CMapBFRangeStringMap
extends CMapRangeMap {
    private final char[] chars;
    private final int last;

    public CMapBFRangeStringMap(byte[] start, byte[] end, byte[] destination) {
        super(start, end);
        this.chars = new char[destination.length >> 1];
        int byteIndex = 0;
        int charIndex = 0;
        while (byteIndex < destination.length) {
            this.chars[charIndex++] = (char)((destination[byteIndex++] << 8) + destination[byteIndex++]);
        }
        this.last = this.chars.length - 1;
    }

    public char[] toChars(int codepoint) {
        if (codepoint >= this.start && codepoint <= this.end) {
            return new char[]{(char)(codepoint - this.start + this.chars[this.last])};
        }
        return null;
    }

    public int toCID(int codepoint) {
        if (codepoint >= this.start && codepoint <= this.end) {
            return codepoint - this.start + this.chars[this.last];
        }
        return 0;
    }

    public int toCodepoint(int cid) {
        char tempChar = this.chars[this.last];
        if (cid >= tempChar && cid <= tempChar + this.end - this.start) {
            return this.start + cid - tempChar;
        }
        return 0;
    }
}

