/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font.freetype;

import de.intarsys.cwt.freetype.CharMap;
import de.intarsys.cwt.freetype.Face;
import de.intarsys.cwt.freetype.FreetypeException;
import de.intarsys.cwt.freetype.GlyphSlot;
import de.intarsys.cwt.freetype.nativec.FTEnum;
import de.intarsys.pdf.content.GraphicsState;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontTrueType;
import de.intarsys.pdf.font.PDFontType0;
import de.intarsys.pdf.font.PDFontType1;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformGlyphs;
import de.intarsys.pdf.platform.cwt.font.PlatformFontException;
import de.intarsys.pdf.platform.cwt.font.freetype.FreetypeGlyphs;
import de.intarsys.pdf.platform.cwt.rendering.ICSPlatformDevice;
import de.intarsys.tools.attribute.Attribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class FreetypeFont
implements IPlatformFont {
    private static final Attribute ATTR_PLATFORMGLYPHS = new Attribute("platformGlyphs");
    protected static final Attribute ATTR_SCALE = new Attribute("platformFontScale");
    protected static final Attribute ATTR_TRANSFORM = new Attribute("platformFontTransform");
    private final PDFont font;
    private final Face face;
    private int highByte = -1;
    private double textSpaceFactor = 1.0;
    private PDGlyphs currentGlyphs = null;
    private boolean symbolic = false;

    protected FreetypeFont(PDFont font, Face face) {
        this.font = font;
        this.face = face;
        this.textSpaceFactor = 1000.0 / (double)this.getFace().getUnitsPerEM();
        PDFontDescriptor fontDescriptor = null;
        try {
            fontDescriptor = font.getFontDescriptor();
            this.symbolic = fontDescriptor.isSymbolic();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected IPlatformGlyphs basicCreate(PDGlyphs glyphs) throws PlatformFontException {
        int codepoint = glyphs.getCodepoint();
        if (codepoint < 0) {
            return null;
        }
        return new FreetypeGlyphs(this, glyphs);
    }

    public synchronized IPlatformGlyphs createPlatformGlyphs(PDGlyphs glyphs) throws PlatformFontException {
        IPlatformGlyphs result = (IPlatformGlyphs)glyphs.getAttribute((Object)ATTR_PLATFORMGLYPHS);
        if (result == null) {
            result = this.basicCreate(glyphs);
            glyphs.setAttribute((Object)ATTR_PLATFORMGLYPHS, (Object)result);
        }
        return result;
    }

    public int getAscent() {
        int result = this.getFace().getAscender();
        return (int)((double)result * this.getTextSpaceFactor());
    }

    public Rectangle2D getBBox() {
        Rectangle2D fontBox = this.getFace().getBBox();
        int x = (int)(fontBox.getMinX() * this.getTextSpaceFactor());
        int y = (int)(fontBox.getMinY() * this.getTextSpaceFactor());
        int width = (int)(fontBox.getWidth() * this.getTextSpaceFactor());
        int height = (int)(fontBox.getHeight() * this.getTextSpaceFactor());
        return new Rectangle2D.Float(x, y, width, height);
    }

    public int getCharIndex(char unicode) {
        CharMap oldMap = null;
        try {
            oldMap = this.face.getCharMap();
            this.face.selectCharMap(FTEnum.ENCODING_UNICODE);
            return this.face.getCharIndex((int)unicode);
        }
        catch (FreetypeException e) {
            this.face.setCharMap(oldMap);
            return unicode;
        }
    }

    public int getDescent() {
        int result = this.getFace().getDescender();
        return (int)((double)result * this.getTextSpaceFactor());
    }

    public Face getFace() {
        return this.face;
    }

    public int getHeight() {
        int result = this.getFace().getHeight();
        return (int)((double)result * this.getTextSpaceFactor());
    }

    public Object getImpl() {
        return this.getFace();
    }

    public PDFont getPDFont() {
        return this.font;
    }

    public double getTextSpaceFactor() {
        return this.textSpaceFactor;
    }

    public int getUnderlinePosition() {
        return this.face.getUnderlinePosition();
    }

    public int getUnderlineThickness() {
        return this.face.getUnderlineThickness();
    }

    public boolean isBoldStyle() {
        return false;
    }

    public boolean isItalicStyle() {
        return false;
    }

    public boolean isMonospaced() {
        return false;
    }

    public boolean isSymbolFont() {
        return false;
    }

    public boolean isSymbolic() {
        return this.symbolic;
    }

    protected GlyphSlot loadGlyphSlot(PDGlyphs glyphs) throws PlatformFontException {
        if (this.currentGlyphs == glyphs) {
            return this.face.getGlyphSlot();
        }
        this.currentGlyphs = glyphs;
        if (this.isSymbolic()) {
            if (this.font instanceof PDFontType1) {
                Encoding encoding = this.font.getEncoding();
                if (encoding.isFontSpecificEncoding()) {
                    String glyphName = encoding.getDifferenceGlyphName(glyphs.getCodepoint());
                    if (glyphName != null) {
                        this.loadShapeFromName(this.face, glyphName);
                    } else {
                        this.loadShapeFromCode(this.face, glyphs.getCodepoint());
                    }
                } else {
                    String glyphName = encoding.getGlyphName(glyphs.getCodepoint());
                    this.loadShapeFromName(this.face, glyphName);
                }
            } else if (this.font instanceof PDFontTrueType) {
                CharMap charMap = this.face.getCharMap();
                if (charMap == null || charMap.getPlatformID() == 1) {
                    this.loadShapeFromCode(this.face, glyphs.getCodepoint());
                } else {
                    if (this.highByte == -1) {
                        this.highByte = this.face.getFirstChar() & 0xFF00;
                    }
                    int code = this.highByte | glyphs.getCodepoint();
                    this.loadShapeFromCode(this.face, code);
                }
            } else if (this.font instanceof PDFontType0) {
                int code = this.font.getEncoding().getDecoded(glyphs.getCodepoint());
                int index = ((PDFontType0)this.font).getGlyphIndex(code);
                this.loadShapeFromIndex(this.face, index);
            } else {
                this.loadShapeFromIndex(this.face, glyphs.getCodepoint());
            }
        } else if (this.font instanceof PDFontType1) {
            String glyphName = this.font.getEncoding().getGlyphName(glyphs.getCodepoint());
            if (glyphName == ".notdef") {
                int code = this.font.getEncoding().getDecoded(glyphs.getCodepoint());
                this.loadShapeFromCode(this.face, code);
            } else {
                this.loadShapeFromName(this.face, glyphName);
            }
        } else if (this.font instanceof PDFontTrueType) {
            CharMap charMap = this.face.getCharMap();
            if (charMap != null && charMap.isMicrosoftUnicode()) {
                int code = this.font.getEncoding().getDecoded(glyphs.getCodepoint());
                this.loadShapeFromCode(this.face, code);
            } else {
                int code = this.font.getMacintoshRomanCode(glyphs.getCodepoint());
                this.loadShapeFromCode(this.face, code);
            }
        } else if (this.font instanceof PDFontType0) {
            int code = this.font.getEncoding().getDecoded(glyphs.getCodepoint());
            int index = ((PDFontType0)this.font).getGlyphIndex(code);
            this.loadShapeFromIndex(this.face, index);
        } else {
            this.loadShapeFromIndex(this.face, glyphs.getCodepoint());
        }
        return this.face.getGlyphSlot();
    }

    protected void loadShapeFromCode(Face face, int code) throws PlatformFontException {
        try {
            face.loadChar(code, 10241);
        }
        catch (FreetypeException e) {
            throw new PlatformFontException(e);
        }
    }

    protected void loadShapeFromIndex(Face face, int index) throws PlatformFontException {
        try {
            face.loadGlyph(index, 10241);
        }
        catch (FreetypeException e) {
            throw new PlatformFontException(e);
        }
    }

    protected void loadShapeFromName(Face face, String glyphName) {
        int index = face.getNameIndex(glyphName);
        try {
            face.loadGlyph(index, 10241);
        }
        catch (FreetypeException freetypeException) {
            // empty catch block
        }
    }

    public void saveState(ICSPlatformDevice device, GraphicsState oldState, GraphicsState newState) {
    }

    public void textStateChanged(ICSPlatformDevice device) {
        GraphicsState graphicsState = device.getGraphicsState();
        float fontScale = 1.0f / (float)this.getFace().getUnitsPerEM() * graphicsState.textState.fontSize;
        AffineTransform tempTransform = AffineTransform.getScaleInstance(fontScale * graphicsState.textState.derivedHorizontalScalingFactor, fontScale);
        graphicsState.setAttribute((Object)ATTR_TRANSFORM, (Object)tempTransform);
    }
}

